/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.stream.Stream;
import net.auoeke.reflect.Accessor;
import net.auoeke.reflect.Invoker;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Modules {
    public static final Module everyone = (Module)Accessor.getReference(Module.class, "EVERYONE_MODULE");

    public static void open(Module module, String pkg) {
        ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{lambda$open$0()})).invoke(module, pkg, everyone, true, true);
    }

    public static void open(Class<?> type) {
        Modules.open(type.getModule(), type.getPackageName());
    }

    public static void open(Module module) {
        module.getPackages().forEach(pkg -> Modules.open(module, pkg));
    }

    public static void open(ModuleLayer layer) {
        layer.modules().forEach(Modules::open);
    }

    public static void open(ClassLoader loader) {
        Modules.layers(loader).forEach(Modules::open);
    }

    public static Stream<ModuleLayer> layers(ClassLoader loader) {
        return ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("1", new Object[]{lambda$layers$2()})).invokeExact(loader);
    }

    public static Stream<ModuleLayer> allLayers(ModuleLayer leaf) {
        List<ModuleLayer> parents = leaf.parents();
        Stream<ModuleLayer> layers = Stream.of(leaf);
        return parents.isEmpty() ? layers : Stream.concat(layers, parents.stream().flatMap(Modules::allLayers));
    }

    public static Stream<Module> modules(ClassLoader loader) {
        return Modules.layers(loader).flatMap(layer -> layer.modules().stream());
    }

    private static /* synthetic */ MethodHandle lambda$layers$2() {
        return Invoker.findStatic(ModuleLayer.class, "layers", Stream.class, ClassLoader.class);
    }

    private static /* synthetic */ MethodHandle lambda$open$0() {
        return Invoker.findSpecial(Module.class, "implAddExportsOrOpens", Void.TYPE, String.class, Module.class, Boolean.TYPE, Boolean.TYPE);
    }
}

