/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.reflect.Field;
import net.auoeke.reflect.Fields;
import net.auoeke.reflect.Flags;
import net.gudenau.lib.unsafe.Unsafe;

public class Pointer
implements Cloneable {
    public static final int UNKNOWN = -1;
    public static final int BOOLEAN = 0;
    public static final int BYTE = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int REFERENCE = 8;
    public static final int ADDRESS = 9;
    public final Object base;
    public final long offset;
    public final int type;

    protected Pointer(Object base, long offset, int type) {
        this.base = base;
        this.offset = offset;
        this.type = type;
    }

    public static Pointer of(Object base, long offset, int type) {
        if (type < -1 || type > 9) {
            throw new IllegalArgumentException(Integer.toString(type));
        }
        return new Pointer(base, offset, type);
    }

    public static Pointer of(Object base, long offset, Class<?> type) {
        return new Pointer(base, offset, Pointer.typeID(type));
    }

    public static Pointer of(Object base, long offset) {
        return new Pointer(base, offset, -1);
    }

    public static Pointer of(long offset) {
        return new Pointer(null, offset, -1);
    }

    public static Pointer of(long offset, int type) {
        return Pointer.of(null, offset, type);
    }

    public static Pointer of(long offset, Class<?> type) {
        return Pointer.of(null, offset, type);
    }

    private static Pointer of(Object instance, Field field) {
        return Pointer.of(Flags.isStatic(field) ? field.getDeclaringClass() : instance, Fields.offset(field), field.getType());
    }

    public static Pointer of(Field field) {
        return Pointer.of(null, field);
    }

    public static Pointer of(Class<?> type, String field) {
        return Pointer.of(null, Fields.of(type, field));
    }

    public static Pointer of(Object object, String field) {
        return Pointer.of(object, Fields.of(object, field));
    }

    public Pointer clone() {
        return new Pointer(this.base, this.offset, this.type);
    }

    public Pointer bind(Object base) {
        return new Pointer(base, this.offset, this.type);
    }

    public Pointer offset(long offset) {
        return new Pointer(this.base, offset, this.type);
    }

    public Pointer type(int type) {
        return Pointer.of(this.base, this.offset, type);
    }

    public Pointer type(Class<?> type) {
        return Pointer.of(this.base, this.offset, type);
    }

    public Pointer field(Field field) {
        return Pointer.of(this.base, field);
    }

    public Pointer field(Class<?> type, String name) {
        return Pointer.of(this.base, Fields.of(type, name));
    }

    public Pointer staticField(String name) {
        return Pointer.of(null, Fields.of((Class)this.base, name));
    }

    public Pointer instanceField(String name) {
        return Pointer.of(this.base, Fields.of(this.base, name));
    }

    public Object get() {
        return switch (this.type) {
            case 0 -> this.getBoolean();
            case 1 -> this.getByte();
            case 2 -> Character.valueOf(this.getChar());
            case 3 -> this.getShort();
            case 4 -> this.getInt();
            case 5 -> this.getLong();
            case 6 -> Float.valueOf(this.getFloat());
            case 7 -> this.getDouble();
            case 8 -> this.getReference();
            case 9 -> this.getAddress();
            default -> throw new IllegalStateException("type is not set");
        };
    }

    public Object get(Object object) {
        return switch (this.type) {
            case 0 -> this.getBoolean(object);
            case 1 -> this.getByte(object);
            case 2 -> Character.valueOf(this.getChar(object));
            case 3 -> this.getShort(object);
            case 4 -> this.getInt(object);
            case 5 -> this.getLong(object);
            case 6 -> Float.valueOf(this.getFloat(object));
            case 7 -> this.getDouble(object);
            case 8 -> this.getReference(object);
            case 9 -> this.getAddress(object);
            default -> throw new IllegalStateException("type is not set");
        };
    }

    public void put(Object value) {
        switch (this.type) {
            case 0: {
                this.putBoolean(this.base, (Boolean)value);
                break;
            }
            case 1: {
                this.putByte(this.base, (Byte)value);
                break;
            }
            case 2: {
                this.putChar(this.base, ((Character)value).charValue());
                break;
            }
            case 3: {
                this.putShort(this.base, (Short)value);
                break;
            }
            case 4: {
                this.putInt(this.base, (Integer)value);
                break;
            }
            case 5: {
                this.putLong(this.base, (Long)value);
                break;
            }
            case 6: {
                this.putFloat(this.base, ((Float)value).floatValue());
                break;
            }
            case 7: {
                this.putDouble(this.base, (Double)value);
                break;
            }
            case 8: {
                this.putReference(this.base, value);
                break;
            }
            case 9: {
                this.putAddress(this.base, (Long)value);
                break;
            }
            default: {
                throw new IllegalStateException("type is not set");
            }
        }
    }

    public void put(Object object, Object value) {
        switch (this.type) {
            case 0: {
                this.putBoolean(object, (Boolean)value);
                break;
            }
            case 1: {
                this.putByte(object, (Byte)value);
                break;
            }
            case 2: {
                this.putChar(object, ((Character)value).charValue());
                break;
            }
            case 3: {
                this.putShort(object, (Short)value);
                break;
            }
            case 4: {
                this.putInt(object, (Integer)value);
                break;
            }
            case 5: {
                this.putLong(object, (Long)value);
                break;
            }
            case 6: {
                this.putFloat(object, ((Float)value).floatValue());
                break;
            }
            case 7: {
                this.putDouble(object, (Double)value);
                break;
            }
            case 8: {
                this.putReference(object, value);
                break;
            }
            case 9: {
                this.putAddress(object, (Long)value);
                break;
            }
            default: {
                throw new IllegalStateException("type is not set");
            }
        }
    }

    public void copy(Object destination) {
        this.put(destination, this.get());
    }

    public void copy(Object source, Object destination) {
        this.put(destination, this.get(source));
    }

    public <T> T getT() {
        return (T)Unsafe.getReference((Object)this.base, (long)this.offset);
    }

    public <T> T getT(Object object) {
        return (T)Unsafe.getReference((Object)object, (long)this.offset);
    }

    public Object getReference() {
        return Unsafe.getReference((Object)this.base, (long)this.offset);
    }

    public Object getReference(Object object) {
        return Unsafe.getReference((Object)object, (long)this.offset);
    }

    public void putReference(Object object, Object value) {
        Unsafe.putReference((Object)object, (long)this.offset, (Object)value);
    }

    public void putReference(Object value) {
        Unsafe.putReference((Object)this.base, (long)this.offset, (Object)value);
    }

    public void copyReference(Object destination) {
        this.putReference(destination, this.getReference());
    }

    public void copyReference(Object source, Object destination) {
        this.putReference(destination, this.getReference(source));
    }

    public boolean getBoolean() {
        return Unsafe.getBoolean((Object)this.base, (long)this.offset);
    }

    public boolean getBoolean(Object object) {
        return Unsafe.getBoolean((Object)object, (long)this.offset);
    }

    public void putBoolean(boolean value) {
        Unsafe.putBoolean((Object)this.base, (long)this.offset, (boolean)value);
    }

    public void putBoolean(Object object, boolean value) {
        Unsafe.putBoolean((Object)object, (long)this.offset, (boolean)value);
    }

    public void copyBoolean(Object destination) {
        this.putBoolean(destination, this.getBoolean());
    }

    public void copyBoolean(Object source, Object destination) {
        this.putBoolean(destination, this.getBoolean(source));
    }

    public byte getByte() {
        return Unsafe.getByte((Object)this.base, (long)this.offset);
    }

    public byte getByte(Object object) {
        return Unsafe.getByte((Object)object, (long)this.offset);
    }

    public void putByte(Object object, byte value) {
        Unsafe.putByte((Object)object, (long)this.offset, (byte)value);
    }

    public void putByte(byte value) {
        Unsafe.putByte((Object)this.base, (long)this.offset, (byte)value);
    }

    public void copyByte(Object destination) {
        this.putByte(destination, this.getByte());
    }

    public void copyByte(Object source, Object destination) {
        this.putByte(destination, this.getByte(source));
    }

    public short getShort() {
        return Unsafe.getShort((Object)this.base, (long)this.offset);
    }

    public short getShort(Object object) {
        return Unsafe.getShort((Object)object, (long)this.offset);
    }

    public void putShort(Object object, short value) {
        Unsafe.putShort((Object)object, (long)this.offset, (short)value);
    }

    public void putShort(short value) {
        Unsafe.putShort((Object)this.base, (long)this.offset, (short)value);
    }

    public void copyShort(Object destination) {
        this.putShort(destination, this.getShort());
    }

    public void copyShort(Object source, Object destination) {
        this.putShort(destination, this.getShort(source));
    }

    public char getChar() {
        return Unsafe.getChar((Object)this.base, (long)this.offset);
    }

    public char getChar(Object object) {
        return Unsafe.getChar((Object)object, (long)this.offset);
    }

    public void putChar(Object object, char value) {
        Unsafe.putChar((Object)object, (long)this.offset, (char)value);
    }

    public void putChar(char value) {
        Unsafe.putChar((Object)this.base, (long)this.offset, (char)value);
    }

    public void copyChar(Object destination) {
        this.putChar(destination, this.getChar());
    }

    public void copyChar(Object source, Object destination) {
        this.putChar(destination, this.getChar(source));
    }

    public int getInt() {
        return Unsafe.getInt((Object)this.base, (long)this.offset);
    }

    public int getInt(Object object) {
        return Unsafe.getInt((Object)object, (long)this.offset);
    }

    public void putInt(Object object, int value) {
        Unsafe.putInt((Object)object, (long)this.offset, (int)value);
    }

    public void putInt(int value) {
        Unsafe.putInt((Object)this.base, (long)this.offset, (int)value);
    }

    public void copyInt(Object destination) {
        this.putInt(destination, this.getInt());
    }

    public void copyInt(Object source, Object destination) {
        this.putInt(destination, this.getInt(source));
    }

    public long getLong() {
        return Unsafe.getLong((Object)this.base, (long)this.offset);
    }

    public long getLong(Object object) {
        return Unsafe.getLong((Object)object, (long)this.offset);
    }

    public void putLong(Object object, long value) {
        Unsafe.putLong((Object)object, (long)this.offset, (long)value);
    }

    public void putLong(long value) {
        Unsafe.putLong((Object)this.base, (long)this.offset, (long)value);
    }

    public void copyLong(Object destination) {
        this.putLong(destination, this.getLong());
    }

    public void copyLong(Object source, Object destination) {
        this.putLong(destination, this.getLong(source));
    }

    public float getFloat() {
        return Unsafe.getFloat((Object)this.base, (long)this.offset);
    }

    public float getFloat(Object object) {
        return Unsafe.getFloat((Object)object, (long)this.offset);
    }

    public void putFloat(Object object, float value) {
        Unsafe.putFloat((Object)object, (long)this.offset, (float)value);
    }

    public void putFloat(float value) {
        Unsafe.putFloat((Object)this.base, (long)this.offset, (float)value);
    }

    public void copyFloat(Object destination) {
        this.putFloat(destination, this.getFloat());
    }

    public void copyFloat(Object source, Object destination) {
        this.putFloat(destination, this.getFloat(source));
    }

    public double getDouble() {
        return Unsafe.getDouble((Object)this.base, (long)this.offset);
    }

    public double getDouble(Object object) {
        return Unsafe.getDouble((Object)object, (long)this.offset);
    }

    public void putDouble(Object object, double value) {
        Unsafe.putDouble((Object)object, (long)this.offset, (double)value);
    }

    public void putDouble(double value) {
        Unsafe.putDouble((Object)this.base, (long)this.offset, (double)value);
    }

    public void copyDouble(Object destination) {
        this.putDouble(destination, this.getDouble());
    }

    public void copyDouble(Object source, Object destination) {
        this.putDouble(destination, this.getDouble(source));
    }

    public long getAddress() {
        return Unsafe.getAddress((Object)this.base, (long)this.offset);
    }

    public long getAddress(Object base) {
        return Unsafe.getAddress((Object)base, (long)this.offset);
    }

    public void putAddress(long address) {
        Unsafe.putAddress((Object)this.base, (long)this.offset, (long)address);
    }

    public void putAddress(Object base, long address) {
        Unsafe.putAddress((Object)base, (long)this.offset, (long)address);
    }

    public void copyAddress(Object destination) {
        this.putAddress(destination, this.getAddress());
    }

    public void copyAddress(Object source, Object destination) {
        this.putAddress(destination, this.getAddress(source));
    }

    public <T> T getReferenceVolatile() {
        return (T)Unsafe.getReferenceVolatile((Object)this.base, (long)this.offset);
    }

    public <T> T getReferenceVolatile(Object object) {
        return (T)Unsafe.getReferenceVolatile((Object)object, (long)this.offset);
    }

    public void putReferenceVolatile(Object object, Object value) {
        Unsafe.putReferenceVolatile((Object)object, (long)this.offset, (Object)value);
    }

    public void putReferenceVolatile(Object value) {
        Unsafe.putReferenceVolatile((Object)this.base, (long)this.offset, (Object)value);
    }

    public boolean getBooleanVolatile() {
        return Unsafe.getBooleanVolatile((Object)this.base, (long)this.offset);
    }

    public boolean getBooleanVolatile(Object object) {
        return Unsafe.getBooleanVolatile((Object)object, (long)this.offset);
    }

    public void putBooleanVolatile(Object object, boolean value) {
        Unsafe.putBooleanVolatile((Object)object, (long)this.offset, (boolean)value);
    }

    public void putBooleanVolatile(boolean value) {
        Unsafe.putBooleanVolatile((Object)this.base, (long)this.offset, (boolean)value);
    }

    public byte getByteVolatile() {
        return Unsafe.getByteVolatile((Object)this.base, (long)this.offset);
    }

    public byte getByteVolatile(Object object) {
        return Unsafe.getByteVolatile((Object)object, (long)this.offset);
    }

    public void putByteVolatile(Object object, byte value) {
        Unsafe.putByteVolatile((Object)object, (long)this.offset, (byte)value);
    }

    public void putByteVolatile(byte value) {
        Unsafe.putByteVolatile((Object)this.base, (long)this.offset, (byte)value);
    }

    public short getShortVolatile() {
        return Unsafe.getShortVolatile((Object)this.base, (long)this.offset);
    }

    public short getShortVolatile(Object object) {
        return Unsafe.getShortVolatile((Object)object, (long)this.offset);
    }

    public void putShortVolatile(Object object, short value) {
        Unsafe.putShortVolatile((Object)object, (long)this.offset, (short)value);
    }

    public void putShortVolatile(short value) {
        Unsafe.putShortVolatile((Object)this.base, (long)this.offset, (short)value);
    }

    public char getCharVolatile() {
        return Unsafe.getCharVolatile((Object)this.base, (long)this.offset);
    }

    public char getCharVolatile(Object object) {
        return Unsafe.getCharVolatile((Object)object, (long)this.offset);
    }

    public void putCharVolatile(Object object, char value) {
        Unsafe.putCharVolatile((Object)object, (long)this.offset, (char)value);
    }

    public void putCharVolatile(char value) {
        Unsafe.putCharVolatile((Object)this.base, (long)this.offset, (char)value);
    }

    public int getIntVolatile() {
        return Unsafe.getIntVolatile((Object)this.base, (long)this.offset);
    }

    public int getIntVolatile(Object object) {
        return Unsafe.getIntVolatile((Object)object, (long)this.offset);
    }

    public void putIntVolatile(Object object, int value) {
        Unsafe.putIntVolatile((Object)object, (long)this.offset, (int)value);
    }

    public void putIntVolatile(int value) {
        Unsafe.putIntVolatile((Object)this.base, (long)this.offset, (int)value);
    }

    public long getLongVolatile() {
        return Unsafe.getLongVolatile((Object)this.base, (long)this.offset);
    }

    public long getLongVolatile(Object object) {
        return Unsafe.getLongVolatile((Object)object, (long)this.offset);
    }

    public void putLongVolatile(Object object, long value) {
        Unsafe.putLongVolatile((Object)object, (long)this.offset, (long)value);
    }

    public void putLongVolatile(long value) {
        Unsafe.putLongVolatile((Object)this.base, (long)this.offset, (long)value);
    }

    public float getFloatVolatile() {
        return Unsafe.getFloatVolatile((Object)this.base, (long)this.offset);
    }

    public float getFloatVolatile(Object object) {
        return Unsafe.getFloatVolatile((Object)object, (long)this.offset);
    }

    public void putFloatVolatile(Object object, float value) {
        Unsafe.putFloatVolatile((Object)object, (long)this.offset, (float)value);
    }

    public void putFloatVolatile(float value) {
        Unsafe.putFloatVolatile((Object)this.base, (long)this.offset, (float)value);
    }

    public double getDoubleVolatile() {
        return Unsafe.getDoubleVolatile((Object)this.base, (long)this.offset);
    }

    public double getDoubleVolatile(Object object) {
        return Unsafe.getDoubleVolatile((Object)object, (long)this.offset);
    }

    public void putDoubleVolatile(Object object, double value) {
        Unsafe.putDoubleVolatile((Object)object, (long)this.offset, (double)value);
    }

    public void putDoubleVolatile(double value) {
        Unsafe.putDoubleVolatile((Object)this.base, (long)this.offset, (double)value);
    }

    private static int typeID(Class<?> type) {
        return type == Boolean.TYPE ? 0 : (type == Byte.TYPE ? 1 : (type == Character.TYPE ? 2 : (type == Short.TYPE ? 3 : (type == Integer.TYPE ? 4 : (type == Long.TYPE ? 5 : (type == Float.TYPE ? 6 : (type == Double.TYPE ? 7 : 8)))))));
    }
}

