/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.VirtualMachine;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.ConstantBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import net.auoeke.reflect.Accessor;
import net.auoeke.reflect.Classes;
import net.auoeke.reflect.Exceptions;
import net.auoeke.result.Result;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Reflect {
    public static Result<Instrumentation> instrument() {
        return  /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{lambda$instrument$11()});
    }

    private static /* synthetic */ Result lambda$instrument$11() {
        String AgentName = Reflect.class.getPackageName() + ".Agent";
        String AgentPath = AgentName.replace('.', '/') + ".class";
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        return Result.of(() -> (Instrumentation)Accessor.getReference(systemLoader.loadClass(AgentName), "instrumentation")).filterNotNull().flatOr(() -> Result.ofVoid(() -> Accessor.putReference(Class.forName("openj9.internal.tools.attach.target.AttachHandler"), "allowAttachSelf", (Object)"true")).flatOr(() -> Result.ofVoid(() -> ((Map)Accessor.getReference(Class.forName("jdk.internal.misc.VM"), "savedProps")).put("jdk.attach.allowAttachSelf", "true")).multiply(() -> Accessor.putBoolean(Class.forName("sun.tools.attach.HotSpotVirtualMachine"), "ALLOW_ATTACH_SELF", true))).thenResult(() -> {
            VirtualMachine vm = VirtualMachine.attach(String.valueOf(ProcessHandle.current().pid()));
            try {
                Manifest manifest = Stream.concat(Stream.ofNullable(Classes.findResource(Reflect.class, "META-INF/MANIFEST.MF")), Classes.resources(Reflect.class.getClassLoader(), "META-INF/MANIFEST.MF")).distinct().map(url -> {
                    try (InputStream stream = url.openConnection().getInputStream();){
                        Manifest manifest = new Manifest(stream);
                        return manifest;
                    }
                }).filter(m -> AgentName.equals(m.getMainAttributes().getValue("Agent-Class"))).findFirst().orElseThrow(() -> new FileNotFoundException("MANIFEST.MF with \"Agent-Class: %s\"".formatted(AgentName)));
                String filename = "agent-%s.jar".formatted(HexFormat.of().formatHex(MessageDigest.getInstance("SHA-256").digest(manifest.toString().getBytes())));
                Path agent = Files.createDirectories(Path.of(System.getProperty("java.io.tmpdir"), "net.auoeke/reflect"), new FileAttribute[0]).resolve(filename);
                if (!Files.exists(agent, new LinkOption[0])) {
                    try (JarOutputStream jar = new JarOutputStream(Files.newOutputStream(agent, new OpenOption[0]), manifest);){
                        jar.putNextEntry(new ZipEntry(AgentPath));
                        jar.write(Classes.read(Classes.findResource(Reflect.class, AgentPath).openStream()));
                    }
                    catch (Throwable trouble) {
                        Files.deleteIfExists(agent);
                        throw trouble;
                    }
                }
                try {
                    vm.loadAgent(agent.toString());
                    Instrumentation trouble = (Instrumentation)Accessor.getReference(systemLoader.loadClass(AgentName), "instrumentation");
                    return trouble;
                }
                catch (AgentLoadException exception) {
                    throw Exceptions.message(exception, message -> String.valueOf(agent) + ": " + message);
                }
            }
            finally {
                vm.detach();
            }
        }));
    }
}

