package net.automatalib.util.automaton.builder;

import de.learnlib.tooling.annotation.Generated;
import java.lang.Object;
import java.lang.SafeVarargs;
import net.automatalib.automaton.MutableAutomaton;

/**
 *  A fluent builder for {@link net.automatalib.automaton.Automaton automata}.
 *
 *  @param <S>
 *          state type
 *  @param <I>
 *          input symbol type
 *  @param <T>
 *          transition type
 *  @param <SP>
 *          state property type
 *  @param <TP>
 *          transition property type
 *  @param <A>
 *          concrete automaton type
 */
@Generated(
        generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
        source = "net.automatalib.util.automaton.builder.AutomatonBuilderImpl"
)
public class AutomatonBuilder<S, I, T, SP, TP, A extends MutableAutomaton<S, ? super I, T, ? super SP, ? super TP>> {
    private final AutomatonBuilderImpl<S, I, T, SP, TP, A> delegate;

    private AutomatonBuilder0 AutomatonBuilder0;

    private AutomatonBuilder1 AutomatonBuilder1;

    /**
     *  Constructs a new builder with the given (mutable) automaton to write to.
     *
     *  @param automaton
     *          the automaton to write to
     */
    AutomatonBuilder(A automaton) {
        delegate = new AutomatonBuilderImpl<S, I, T, SP, TP, A>(automaton);
    }

    private AutomatonBuilder<S, I, T, SP, TP, A> getAutomatonBuilder() {
        return this;
    }

    private AutomatonBuilder0 getAutomatonBuilder0() {
        if (AutomatonBuilder0 == null) {
            AutomatonBuilder0 = new AutomatonBuilder0();
        }
        return AutomatonBuilder0;
    }

    private AutomatonBuilder1 getAutomatonBuilder1() {
        if (AutomatonBuilder1 == null) {
            AutomatonBuilder1 = new AutomatonBuilder1();
        }
        return AutomatonBuilder1;
    }

    /**
     *  Associates with the given state the given state property.
     *
     *  @param stateId
     *          the object to identify the state
     *  @param stateProperty
     *          the property to associate with the state
     * @return the next fluent state
     */
    public AutomatonBuilder<S, I, T, SP, TP, A> withStateProperty(Object stateId,
            SP stateProperty) {
        delegate.withStateProperty(stateId, stateProperty);
        return getAutomatonBuilder();
    }

    /**
     *  Returns the constructed automaton.
     *
     *  @return the automaton
     */
    public A create() {
        return delegate.create();
    }

    /**
     *  Marks the given state as initial.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public AutomatonBuilder<S, I, T, SP, TP, A> withInitial(Object stateId) {
        delegate.withInitial(stateId);
        return getAutomatonBuilder();
    }

    /**
     *  Starts a definition of transition(s) from a given source state.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public AutomatonBuilder0 from(Object stateId) {
        delegate.from(stateId);
        return getAutomatonBuilder0();
    }

    /**
     *  Starts a definition of transition(s) from multiple given source states.
     *
     *  @param firstStateId
     *          the mandatory object to identify the first state
     *  @param otherStateIds
     *          the optional objects to identify additional states
     * @return the next fluent state
     */
    public AutomatonBuilder0 from(Object firstStateId, Object... otherStateIds) {
        delegate.from(firstStateId, otherStateIds);
        return getAutomatonBuilder0();
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.AutomatonBuilderImpl"
    )
    public final class AutomatonBuilder0 {
        private AutomatonBuilder0() {
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public AutomatonBuilder1 on(I input) {
            delegate.on(input);
            return getAutomatonBuilder1();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final AutomatonBuilder1 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getAutomatonBuilder1();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.AutomatonBuilderImpl"
    )
    public final class AutomatonBuilder1 {
        private AutomatonBuilder1() {
        }

        /**
         *  Associates with the given state the given state property.
         *
         *  @param stateId
         *          the object to identify the state
         *  @param stateProperty
         *          the property to associate with the state
         * @return the next fluent state
         */
        public AutomatonBuilder<S, I, T, SP, TP, A> withStateProperty(Object stateId,
                SP stateProperty) {
            delegate.withStateProperty(stateId, stateProperty);
            return getAutomatonBuilder();
        }

        /**
         *  Associates a transition property with the currently scoped transition(s).
         *
         *  @param transProp
         *          the property
         * @return the next fluent state
         */
        public AutomatonBuilder1 withProperty(TP transProp) {
            delegate.withProperty(transProp);
            return getAutomatonBuilder1();
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public AutomatonBuilder1 loop() {
            delegate.loop();
            return getAutomatonBuilder1();
        }

        /**
         *  Returns the constructed automaton.
         *
         *  @return the automaton
         */
        public A create() {
            return delegate.create();
        }

        /**
         *  Marks the given state as initial.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public AutomatonBuilder<S, I, T, SP, TP, A> withInitial(Object stateId) {
            delegate.withInitial(stateId);
            return getAutomatonBuilder();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public AutomatonBuilder0 from(Object stateId) {
            delegate.from(stateId);
            return getAutomatonBuilder0();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public AutomatonBuilder0 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getAutomatonBuilder0();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public AutomatonBuilder1 to(Object stateId) {
            delegate.to(stateId);
            return getAutomatonBuilder1();
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public AutomatonBuilder1 on(I input) {
            delegate.on(input);
            return getAutomatonBuilder1();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final AutomatonBuilder1 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getAutomatonBuilder1();
        }
    }
}
