package net.automatalib.util.automaton.builder;

import de.learnlib.tooling.annotation.Generated;
import java.lang.Object;
import java.lang.SafeVarargs;
import net.automatalib.automaton.fsa.MutableDFA;

/**
 *  A fluent builder for {@link net.automatalib.automaton.fsa.DFA}s.
 *
 *  @param <S>
 *          state type
 *  @param <I>
 *          input symbol type
 *  @param <A>
 *          concrete automaton type
 */
@Generated(
        generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
        source = "net.automatalib.util.automaton.builder.DFABuilderImpl"
)
public class DFABuilder<S, I, A extends MutableDFA<S, ? super I>> {
    private final DFABuilderImpl<S, I, A> delegate;

    private DFABuilder0 DFABuilder0;

    private DFABuilder1 DFABuilder1;

    private DFABuilder2 DFABuilder2;

    private DFABuilder3 DFABuilder3;

    private DFABuilder4 DFABuilder4;

    private DFABuilder5 DFABuilder5;

    private DFABuilder6 DFABuilder6;

    /**
     *  Constructs a new builder with the given (mutable) automaton to write to.
     *
     *  @param automaton
     *          the automaton to write to
     */
    DFABuilder(A automaton) {
        delegate = new DFABuilderImpl<S, I, A>(automaton);
    }

    private DFABuilder<S, I, A> getDFABuilder() {
        return this;
    }

    private DFABuilder0 getDFABuilder0() {
        if (DFABuilder0 == null) {
            DFABuilder0 = new DFABuilder0();
        }
        return DFABuilder0;
    }

    private DFABuilder1 getDFABuilder1() {
        if (DFABuilder1 == null) {
            DFABuilder1 = new DFABuilder1();
        }
        return DFABuilder1;
    }

    private DFABuilder2 getDFABuilder2() {
        if (DFABuilder2 == null) {
            DFABuilder2 = new DFABuilder2();
        }
        return DFABuilder2;
    }

    private DFABuilder3 getDFABuilder3() {
        if (DFABuilder3 == null) {
            DFABuilder3 = new DFABuilder3();
        }
        return DFABuilder3;
    }

    private DFABuilder4 getDFABuilder4() {
        if (DFABuilder4 == null) {
            DFABuilder4 = new DFABuilder4();
        }
        return DFABuilder4;
    }

    private DFABuilder5 getDFABuilder5() {
        if (DFABuilder5 == null) {
            DFABuilder5 = new DFABuilder5();
        }
        return DFABuilder5;
    }

    private DFABuilder6 getDFABuilder6() {
        if (DFABuilder6 == null) {
            DFABuilder6 = new DFABuilder6();
        }
        return DFABuilder6;
    }

    /**
     *  Marks the given state as accepting.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public DFABuilder<S, I, A> withAccepting(Object stateId) {
        delegate.withAccepting(stateId);
        return getDFABuilder();
    }

    /**
     *  Marks the given states as accepting.
     *
     *  @param stateId
     *          the object to identify the mandatory state
     *  @param stateIds
     *          the objects to identify the additional states
     * @return the next fluent state
     */
    public DFABuilder<S, I, A> withAccepting(Object stateId, Object... stateIds) {
        delegate.withAccepting(stateId, stateIds);
        return getDFABuilder();
    }

    /**
     *  Marks the given state as initial.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public DFABuilder0 withInitial(Object stateId) {
        delegate.withInitial(stateId);
        return getDFABuilder0();
    }

    /**
     *  Starts a definition of transition(s) from a given source state.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public DFABuilder1 from(Object stateId) {
        delegate.from(stateId);
        return getDFABuilder1();
    }

    /**
     *  Starts a definition of transition(s) from multiple given source states.
     *
     *  @param firstStateId
     *          the mandatory object to identify the first state
     *  @param otherStateIds
     *          the optional objects to identify additional states
     * @return the next fluent state
     */
    public DFABuilder1 from(Object firstStateId, Object... otherStateIds) {
        delegate.from(firstStateId, otherStateIds);
        return getDFABuilder1();
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.DFABuilderImpl"
    )
    public final class DFABuilder0 {
        private DFABuilder0() {
        }

        /**
         *  Marks the given state as accepting.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder0 withAccepting(Object stateId) {
            delegate.withAccepting(stateId);
            return getDFABuilder0();
        }

        /**
         *  Marks the given states as accepting.
         *
         *  @param stateId
         *          the object to identify the mandatory state
         *  @param stateIds
         *          the objects to identify the additional states
         * @return the next fluent state
         */
        public DFABuilder0 withAccepting(Object stateId, Object... stateIds) {
            delegate.withAccepting(stateId, stateIds);
            return getDFABuilder0();
        }

        /**
         *  Returns the constructed automaton.
         *
         *  @return the automaton
         */
        public A create() {
            return delegate.create();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder2 from(Object stateId) {
            delegate.from(stateId);
            return getDFABuilder2();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public DFABuilder2 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getDFABuilder2();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.DFABuilderImpl"
    )
    public final class DFABuilder1 {
        private DFABuilder1() {
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public DFABuilder3 on(I input) {
            delegate.on(input);
            return getDFABuilder3();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final DFABuilder3 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getDFABuilder3();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.DFABuilderImpl"
    )
    public final class DFABuilder2 {
        private DFABuilder2() {
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public DFABuilder4 on(I input) {
            delegate.on(input);
            return getDFABuilder4();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final DFABuilder4 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getDFABuilder4();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.DFABuilderImpl"
    )
    public final class DFABuilder3 {
        private DFABuilder3() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public DFABuilder5 loop() {
            delegate.loop();
            return getDFABuilder5();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder5 to(Object stateId) {
            delegate.to(stateId);
            return getDFABuilder5();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.DFABuilderImpl"
    )
    public final class DFABuilder4 {
        private DFABuilder4() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public DFABuilder6 loop() {
            delegate.loop();
            return getDFABuilder6();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder6 to(Object stateId) {
            delegate.to(stateId);
            return getDFABuilder6();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.DFABuilderImpl"
    )
    public final class DFABuilder5 {
        private DFABuilder5() {
        }

        /**
         *  Marks the given state as accepting.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder<S, I, A> withAccepting(Object stateId) {
            delegate.withAccepting(stateId);
            return getDFABuilder();
        }

        /**
         *  Marks the given states as accepting.
         *
         *  @param stateId
         *          the object to identify the mandatory state
         *  @param stateIds
         *          the objects to identify the additional states
         * @return the next fluent state
         */
        public DFABuilder<S, I, A> withAccepting(Object stateId, Object... stateIds) {
            delegate.withAccepting(stateId, stateIds);
            return getDFABuilder();
        }

        /**
         *  Marks the given state as initial.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder0 withInitial(Object stateId) {
            delegate.withInitial(stateId);
            return getDFABuilder0();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder1 from(Object stateId) {
            delegate.from(stateId);
            return getDFABuilder1();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public DFABuilder1 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getDFABuilder1();
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public DFABuilder3 on(I input) {
            delegate.on(input);
            return getDFABuilder3();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final DFABuilder3 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getDFABuilder3();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.DFABuilderImpl"
    )
    public final class DFABuilder6 {
        private DFABuilder6() {
        }

        /**
         *  Marks the given state as accepting.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder0 withAccepting(Object stateId) {
            delegate.withAccepting(stateId);
            return getDFABuilder0();
        }

        /**
         *  Marks the given states as accepting.
         *
         *  @param stateId
         *          the object to identify the mandatory state
         *  @param stateIds
         *          the objects to identify the additional states
         * @return the next fluent state
         */
        public DFABuilder0 withAccepting(Object stateId, Object... stateIds) {
            delegate.withAccepting(stateId, stateIds);
            return getDFABuilder0();
        }

        /**
         *  Returns the constructed automaton.
         *
         *  @return the automaton
         */
        public A create() {
            return delegate.create();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public DFABuilder2 from(Object stateId) {
            delegate.from(stateId);
            return getDFABuilder2();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public DFABuilder2 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getDFABuilder2();
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public DFABuilder4 on(I input) {
            delegate.on(input);
            return getDFABuilder4();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final DFABuilder4 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getDFABuilder4();
        }
    }
}
