package net.automatalib.util.automaton.builder;

import de.learnlib.tooling.annotation.Generated;
import java.lang.Object;
import java.lang.SafeVarargs;
import net.automatalib.automaton.fsa.MutableFSA;

/**
 *  A fluent builder for {@link net.automatalib.automaton.fsa.FiniteStateAcceptor}s.
 *
 *  @param <S>
 *          state type
 *  @param <I>
 *          input symbol type
 *  @param <A>
 *          concrete automaton type
 */
@Generated(
        generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
        source = "net.automatalib.util.automaton.builder.FSABuilderImpl"
)
public class FSABuilder<S, I, A extends MutableFSA<S, ? super I>> {
    private final FSABuilderImpl<S, I, A> delegate;

    private FSABuilder0 FSABuilder0;

    private FSABuilder1 FSABuilder1;

    private FSABuilder2 FSABuilder2;

    /**
     *  Constructs a new builder with the given (mutable) automaton to write to.
     *
     *  @param automaton
     *          the automaton to write to
     */
    FSABuilder(A automaton) {
        delegate = new FSABuilderImpl<S, I, A>(automaton);
    }

    private FSABuilder<S, I, A> getFSABuilder() {
        return this;
    }

    private FSABuilder0 getFSABuilder0() {
        if (FSABuilder0 == null) {
            FSABuilder0 = new FSABuilder0();
        }
        return FSABuilder0;
    }

    private FSABuilder1 getFSABuilder1() {
        if (FSABuilder1 == null) {
            FSABuilder1 = new FSABuilder1();
        }
        return FSABuilder1;
    }

    private FSABuilder2 getFSABuilder2() {
        if (FSABuilder2 == null) {
            FSABuilder2 = new FSABuilder2();
        }
        return FSABuilder2;
    }

    /**
     *  Marks the given state as accepting.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public FSABuilder<S, I, A> withAccepting(Object stateId) {
        delegate.withAccepting(stateId);
        return getFSABuilder();
    }

    /**
     *  Marks the given states as accepting.
     *
     *  @param stateId
     *          the object to identify the mandatory state
     *  @param stateIds
     *          the objects to identify the additional states
     * @return the next fluent state
     */
    public FSABuilder<S, I, A> withAccepting(Object stateId, Object... stateIds) {
        delegate.withAccepting(stateId, stateIds);
        return getFSABuilder();
    }

    /**
     *  Returns the constructed automaton.
     *
     *  @return the automaton
     */
    public A create() {
        return delegate.create();
    }

    /**
     *  Marks the given state as initial.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public FSABuilder<S, I, A> withInitial(Object stateId) {
        delegate.withInitial(stateId);
        return getFSABuilder();
    }

    /**
     *  Marks the given states as initial.
     *
     *  @param stateId
     *          the object to identify the mandatory state
     *  @param stateIds
     *          the objects to identify the additional states
     * @return the next fluent state
     */
    public FSABuilder<S, I, A> withInitial(Object stateId, Object... stateIds) {
        delegate.withInitial(stateId, stateIds);
        return getFSABuilder();
    }

    /**
     *  Starts a definition of transition(s) from a given source state.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public FSABuilder0 from(Object stateId) {
        delegate.from(stateId);
        return getFSABuilder0();
    }

    /**
     *  Starts a definition of transition(s) from multiple given source states.
     *
     *  @param firstStateId
     *          the mandatory object to identify the first state
     *  @param otherStateIds
     *          the optional objects to identify additional states
     * @return the next fluent state
     */
    public FSABuilder0 from(Object firstStateId, Object... otherStateIds) {
        delegate.from(firstStateId, otherStateIds);
        return getFSABuilder0();
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.FSABuilderImpl"
    )
    public final class FSABuilder0 {
        private FSABuilder0() {
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public FSABuilder1 on(I input) {
            delegate.on(input);
            return getFSABuilder1();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final FSABuilder1 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getFSABuilder1();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.FSABuilderImpl"
    )
    public final class FSABuilder1 {
        private FSABuilder1() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public FSABuilder2 loop() {
            delegate.loop();
            return getFSABuilder2();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public FSABuilder2 to(Object stateId) {
            delegate.to(stateId);
            return getFSABuilder2();
        }

        /**
         *  Sets the target states of the current transition definition(s).
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public FSABuilder2 to(Object firstStateId, Object... otherStateIds) {
            delegate.to(firstStateId, otherStateIds);
            return getFSABuilder2();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.FSABuilderImpl"
    )
    public final class FSABuilder2 {
        private FSABuilder2() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public FSABuilder2 loop() {
            delegate.loop();
            return getFSABuilder2();
        }

        /**
         *  Marks the given state as accepting.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public FSABuilder<S, I, A> withAccepting(Object stateId) {
            delegate.withAccepting(stateId);
            return getFSABuilder();
        }

        /**
         *  Marks the given states as accepting.
         *
         *  @param stateId
         *          the object to identify the mandatory state
         *  @param stateIds
         *          the objects to identify the additional states
         * @return the next fluent state
         */
        public FSABuilder<S, I, A> withAccepting(Object stateId, Object... stateIds) {
            delegate.withAccepting(stateId, stateIds);
            return getFSABuilder();
        }

        /**
         *  Returns the constructed automaton.
         *
         *  @return the automaton
         */
        public A create() {
            return delegate.create();
        }

        /**
         *  Marks the given state as initial.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public FSABuilder<S, I, A> withInitial(Object stateId) {
            delegate.withInitial(stateId);
            return getFSABuilder();
        }

        /**
         *  Marks the given states as initial.
         *
         *  @param stateId
         *          the object to identify the mandatory state
         *  @param stateIds
         *          the objects to identify the additional states
         * @return the next fluent state
         */
        public FSABuilder<S, I, A> withInitial(Object stateId, Object... stateIds) {
            delegate.withInitial(stateId, stateIds);
            return getFSABuilder();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public FSABuilder0 from(Object stateId) {
            delegate.from(stateId);
            return getFSABuilder0();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public FSABuilder0 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getFSABuilder0();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public FSABuilder2 to(Object stateId) {
            delegate.to(stateId);
            return getFSABuilder2();
        }

        /**
         *  Sets the target states of the current transition definition(s).
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public FSABuilder2 to(Object firstStateId, Object... otherStateIds) {
            delegate.to(firstStateId, otherStateIds);
            return getFSABuilder2();
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public FSABuilder1 on(I input) {
            delegate.on(input);
            return getFSABuilder1();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final FSABuilder1 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getFSABuilder1();
        }
    }
}
