package net.automatalib.util.automaton.builder;

import de.learnlib.tooling.annotation.Generated;
import java.lang.Object;
import java.lang.SafeVarargs;
import net.automatalib.automaton.transducer.MutableMealyMachine;

/**
 *  A fluent builder for {@link net.automatalib.automaton.transducer.MealyMachine}s.
 *
 *  @param <S>
 *          state type
 *  @param <I>
 *          input symbol type
 *  @param <T>
 *          transition type
 *  @param <O>
 *          output symbol type
 *  @param <A>
 *          concrete automaton type
 */
@Generated(
        generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
        source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
)
public class MealyBuilder<S, I, T, O, A extends MutableMealyMachine<S, ? super I, T, ? super O>> {
    private final MealyBuilderImpl<S, I, T, O, A> delegate;

    private MealyBuilder0 MealyBuilder0;

    private MealyBuilder1 MealyBuilder1;

    private MealyBuilder2 MealyBuilder2;

    private MealyBuilder3 MealyBuilder3;

    private MealyBuilder4 MealyBuilder4;

    private MealyBuilder5 MealyBuilder5;

    private MealyBuilder6 MealyBuilder6;

    private MealyBuilder7 MealyBuilder7;

    private MealyBuilder8 MealyBuilder8;

    /**
     *  Constructs a new builder with the given (mutable) automaton to write to.
     *
     *  @param automaton
     *          the automaton to write to
     */
    MealyBuilder(A automaton) {
        delegate = new MealyBuilderImpl<S, I, T, O, A>(automaton);
    }

    private MealyBuilder<S, I, T, O, A> getMealyBuilder() {
        return this;
    }

    private MealyBuilder0 getMealyBuilder0() {
        if (MealyBuilder0 == null) {
            MealyBuilder0 = new MealyBuilder0();
        }
        return MealyBuilder0;
    }

    private MealyBuilder1 getMealyBuilder1() {
        if (MealyBuilder1 == null) {
            MealyBuilder1 = new MealyBuilder1();
        }
        return MealyBuilder1;
    }

    private MealyBuilder2 getMealyBuilder2() {
        if (MealyBuilder2 == null) {
            MealyBuilder2 = new MealyBuilder2();
        }
        return MealyBuilder2;
    }

    private MealyBuilder3 getMealyBuilder3() {
        if (MealyBuilder3 == null) {
            MealyBuilder3 = new MealyBuilder3();
        }
        return MealyBuilder3;
    }

    private MealyBuilder4 getMealyBuilder4() {
        if (MealyBuilder4 == null) {
            MealyBuilder4 = new MealyBuilder4();
        }
        return MealyBuilder4;
    }

    private MealyBuilder5 getMealyBuilder5() {
        if (MealyBuilder5 == null) {
            MealyBuilder5 = new MealyBuilder5();
        }
        return MealyBuilder5;
    }

    private MealyBuilder6 getMealyBuilder6() {
        if (MealyBuilder6 == null) {
            MealyBuilder6 = new MealyBuilder6();
        }
        return MealyBuilder6;
    }

    private MealyBuilder7 getMealyBuilder7() {
        if (MealyBuilder7 == null) {
            MealyBuilder7 = new MealyBuilder7();
        }
        return MealyBuilder7;
    }

    private MealyBuilder8 getMealyBuilder8() {
        if (MealyBuilder8 == null) {
            MealyBuilder8 = new MealyBuilder8();
        }
        return MealyBuilder8;
    }

    /**
     *  Marks the given state as initial.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public MealyBuilder0 withInitial(Object stateId) {
        delegate.withInitial(stateId);
        return getMealyBuilder0();
    }

    /**
     *  Starts a definition of transition(s) from a given source state.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public MealyBuilder1 from(Object stateId) {
        delegate.from(stateId);
        return getMealyBuilder1();
    }

    /**
     *  Starts a definition of transition(s) from multiple given source states.
     *
     *  @param firstStateId
     *          the mandatory object to identify the first state
     *  @param otherStateIds
     *          the optional objects to identify additional states
     * @return the next fluent state
     */
    public MealyBuilder1 from(Object firstStateId, Object... otherStateIds) {
        delegate.from(firstStateId, otherStateIds);
        return getMealyBuilder1();
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder0 {
        private MealyBuilder0() {
        }

        /**
         *  Returns the constructed automaton.
         *
         *  @return the automaton
         */
        public A create() {
            return delegate.create();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MealyBuilder2 from(Object stateId) {
            delegate.from(stateId);
            return getMealyBuilder2();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public MealyBuilder2 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getMealyBuilder2();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder1 {
        private MealyBuilder1() {
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public MealyBuilder3 on(I input) {
            delegate.on(input);
            return getMealyBuilder3();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final MealyBuilder3 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getMealyBuilder3();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder2 {
        private MealyBuilder2() {
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public MealyBuilder4 on(I input) {
            delegate.on(input);
            return getMealyBuilder4();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final MealyBuilder4 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getMealyBuilder4();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder3 {
        private MealyBuilder3() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public MealyBuilder6 loop() {
            delegate.loop();
            return getMealyBuilder6();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MealyBuilder6 to(Object stateId) {
            delegate.to(stateId);
            return getMealyBuilder6();
        }

        /**
         *  Associates an output symbol with the currently scoped transition(s).
         *
         *  @param output
         *          the output
         * @return the next fluent state
         */
        public MealyBuilder5 withOutput(O output) {
            delegate.withOutput(output);
            return getMealyBuilder5();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder4 {
        private MealyBuilder4() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public MealyBuilder8 loop() {
            delegate.loop();
            return getMealyBuilder8();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MealyBuilder8 to(Object stateId) {
            delegate.to(stateId);
            return getMealyBuilder8();
        }

        /**
         *  Associates an output symbol with the currently scoped transition(s).
         *
         *  @param output
         *          the output
         * @return the next fluent state
         */
        public MealyBuilder7 withOutput(O output) {
            delegate.withOutput(output);
            return getMealyBuilder7();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder5 {
        private MealyBuilder5() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public MealyBuilder6 loop() {
            delegate.loop();
            return getMealyBuilder6();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MealyBuilder6 to(Object stateId) {
            delegate.to(stateId);
            return getMealyBuilder6();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder6 {
        private MealyBuilder6() {
        }

        /**
         *  Marks the given state as initial.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MealyBuilder0 withInitial(Object stateId) {
            delegate.withInitial(stateId);
            return getMealyBuilder0();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MealyBuilder1 from(Object stateId) {
            delegate.from(stateId);
            return getMealyBuilder1();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public MealyBuilder1 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getMealyBuilder1();
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public MealyBuilder3 on(I input) {
            delegate.on(input);
            return getMealyBuilder3();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final MealyBuilder3 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getMealyBuilder3();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder7 {
        private MealyBuilder7() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public MealyBuilder8 loop() {
            delegate.loop();
            return getMealyBuilder8();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MealyBuilder8 to(Object stateId) {
            delegate.to(stateId);
            return getMealyBuilder8();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MealyBuilderImpl"
    )
    public final class MealyBuilder8 {
        private MealyBuilder8() {
        }

        /**
         *  Returns the constructed automaton.
         *
         *  @return the automaton
         */
        public A create() {
            return delegate.create();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MealyBuilder2 from(Object stateId) {
            delegate.from(stateId);
            return getMealyBuilder2();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public MealyBuilder2 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getMealyBuilder2();
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public MealyBuilder4 on(I input) {
            delegate.on(input);
            return getMealyBuilder4();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final MealyBuilder4 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getMealyBuilder4();
        }
    }
}
