package net.automatalib.util.automaton.builder;

import de.learnlib.tooling.annotation.Generated;
import java.lang.Object;
import java.lang.SafeVarargs;
import net.automatalib.automaton.transducer.MutableMooreMachine;

/**
 *  A fluent builder for {@link net.automatalib.automaton.transducer.MooreMachine}s.
 *
 *  @param <S>
 *          state type
 *  @param <I>
 *          input symbol type
 *  @param <T>
 *          transition type
 *  @param <O>
 *          output symbol type
 *  @param <A>
 *          concrete automaton type
 */
@Generated(
        generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
        source = "net.automatalib.util.automaton.builder.MooreBuilderImpl"
)
public class MooreBuilder<S, I, T, O, A extends MutableMooreMachine<S, ? super I, T, ? super O>> {
    private final MooreBuilderImpl<S, I, T, O, A> delegate;

    private MooreBuilder0 MooreBuilder0;

    private MooreBuilder1 MooreBuilder1;

    private MooreBuilder2 MooreBuilder2;

    private MooreBuilder3 MooreBuilder3;

    private MooreBuilder4 MooreBuilder4;

    private MooreBuilder5 MooreBuilder5;

    private MooreBuilder6 MooreBuilder6;

    /**
     *  Constructs a new builder with the given (mutable) automaton to write to.
     *
     *  @param automaton
     *          the automaton to write to
     */
    MooreBuilder(A automaton) {
        delegate = new MooreBuilderImpl<S, I, T, O, A>(automaton);
    }

    private MooreBuilder<S, I, T, O, A> getMooreBuilder() {
        return this;
    }

    private MooreBuilder0 getMooreBuilder0() {
        if (MooreBuilder0 == null) {
            MooreBuilder0 = new MooreBuilder0();
        }
        return MooreBuilder0;
    }

    private MooreBuilder1 getMooreBuilder1() {
        if (MooreBuilder1 == null) {
            MooreBuilder1 = new MooreBuilder1();
        }
        return MooreBuilder1;
    }

    private MooreBuilder2 getMooreBuilder2() {
        if (MooreBuilder2 == null) {
            MooreBuilder2 = new MooreBuilder2();
        }
        return MooreBuilder2;
    }

    private MooreBuilder3 getMooreBuilder3() {
        if (MooreBuilder3 == null) {
            MooreBuilder3 = new MooreBuilder3();
        }
        return MooreBuilder3;
    }

    private MooreBuilder4 getMooreBuilder4() {
        if (MooreBuilder4 == null) {
            MooreBuilder4 = new MooreBuilder4();
        }
        return MooreBuilder4;
    }

    private MooreBuilder5 getMooreBuilder5() {
        if (MooreBuilder5 == null) {
            MooreBuilder5 = new MooreBuilder5();
        }
        return MooreBuilder5;
    }

    private MooreBuilder6 getMooreBuilder6() {
        if (MooreBuilder6 == null) {
            MooreBuilder6 = new MooreBuilder6();
        }
        return MooreBuilder6;
    }

    /**
     *  Marks the given state as initial.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public MooreBuilder0 withInitial(Object stateId) {
        delegate.withInitial(stateId);
        return getMooreBuilder0();
    }

    /**
     *  Marks the given state as initial and allows to set its output.
     *
     *  @param stateId
     *          the object to identify the state
     *  @param output
     *          the output of the state
     * @return the next fluent state
     */
    public MooreBuilder0 withInitial(Object stateId, O output) {
        delegate.withInitial(stateId, output);
        return getMooreBuilder0();
    }

    /**
     *  Starts a definition of transition(s) from a given source state.
     *
     *  @param stateId
     *          the object to identify the state
     * @return the next fluent state
     */
    public MooreBuilder1 from(Object stateId) {
        delegate.from(stateId);
        return getMooreBuilder1();
    }

    /**
     *  Starts a definition of transition(s) from multiple given source states.
     *
     *  @param firstStateId
     *          the mandatory object to identify the first state
     *  @param otherStateIds
     *          the optional objects to identify additional states
     * @return the next fluent state
     */
    public MooreBuilder1 from(Object firstStateId, Object... otherStateIds) {
        delegate.from(firstStateId, otherStateIds);
        return getMooreBuilder1();
    }

    /**
     *  Associates with the given state the given output symbol.
     *
     *  @param stateId
     *          the object to identify the state
     *  @param output
     *          the output symbol
     * @return the next fluent state
     */
    public MooreBuilder<S, I, T, O, A> withOutput(Object stateId, O output) {
        delegate.withOutput(stateId, output);
        return getMooreBuilder();
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MooreBuilderImpl"
    )
    public final class MooreBuilder0 {
        private MooreBuilder0() {
        }

        /**
         *  Returns the constructed automaton.
         *
         *  @return the automaton
         */
        public A create() {
            return delegate.create();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MooreBuilder2 from(Object stateId) {
            delegate.from(stateId);
            return getMooreBuilder2();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public MooreBuilder2 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getMooreBuilder2();
        }

        /**
         *  Associates with the given state the given output symbol.
         *
         *  @param stateId
         *          the object to identify the state
         *  @param output
         *          the output symbol
         * @return the next fluent state
         */
        public MooreBuilder0 withOutput(Object stateId, O output) {
            delegate.withOutput(stateId, output);
            return getMooreBuilder0();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MooreBuilderImpl"
    )
    public final class MooreBuilder1 {
        private MooreBuilder1() {
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public MooreBuilder3 on(I input) {
            delegate.on(input);
            return getMooreBuilder3();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final MooreBuilder3 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getMooreBuilder3();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MooreBuilderImpl"
    )
    public final class MooreBuilder2 {
        private MooreBuilder2() {
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public MooreBuilder4 on(I input) {
            delegate.on(input);
            return getMooreBuilder4();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final MooreBuilder4 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getMooreBuilder4();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MooreBuilderImpl"
    )
    public final class MooreBuilder3 {
        private MooreBuilder3() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public MooreBuilder5 loop() {
            delegate.loop();
            return getMooreBuilder5();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MooreBuilder5 to(Object stateId) {
            delegate.to(stateId);
            return getMooreBuilder5();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MooreBuilderImpl"
    )
    public final class MooreBuilder4 {
        private MooreBuilder4() {
        }

        /**
         *  Sets the target state(s) of the current transition definition(s) by looping back to the respective source
         *  state(s).
         * @return the next fluent state
         */
        public MooreBuilder6 loop() {
            delegate.loop();
            return getMooreBuilder6();
        }

        /**
         *  Sets the target state of the current transition definition(s).
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MooreBuilder6 to(Object stateId) {
            delegate.to(stateId);
            return getMooreBuilder6();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MooreBuilderImpl"
    )
    public final class MooreBuilder5 {
        private MooreBuilder5() {
        }

        /**
         *  Marks the given state as initial.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MooreBuilder0 withInitial(Object stateId) {
            delegate.withInitial(stateId);
            return getMooreBuilder0();
        }

        /**
         *  Marks the given state as initial and allows to set its output.
         *
         *  @param stateId
         *          the object to identify the state
         *  @param output
         *          the output of the state
         * @return the next fluent state
         */
        public MooreBuilder0 withInitial(Object stateId, O output) {
            delegate.withInitial(stateId, output);
            return getMooreBuilder0();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MooreBuilder1 from(Object stateId) {
            delegate.from(stateId);
            return getMooreBuilder1();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public MooreBuilder1 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getMooreBuilder1();
        }

        /**
         *  Associates with the given state the given output symbol.
         *
         *  @param stateId
         *          the object to identify the state
         *  @param output
         *          the output symbol
         * @return the next fluent state
         */
        public MooreBuilder<S, I, T, O, A> withOutput(Object stateId, O output) {
            delegate.withOutput(stateId, output);
            return getMooreBuilder();
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public MooreBuilder3 on(I input) {
            delegate.on(input);
            return getMooreBuilder3();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final MooreBuilder3 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getMooreBuilder3();
        }
    }

    /**
     * A state (-class) of the enclosing fluent interface.
     */
    @Generated(
            generator = "de.learnlib.tooling.processor.edsl.EDSLProcessor",
            source = "net.automatalib.util.automaton.builder.MooreBuilderImpl"
    )
    public final class MooreBuilder6 {
        private MooreBuilder6() {
        }

        /**
         *  Returns the constructed automaton.
         *
         *  @return the automaton
         */
        public A create() {
            return delegate.create();
        }

        /**
         *  Starts a definition of transition(s) from a given source state.
         *
         *  @param stateId
         *          the object to identify the state
         * @return the next fluent state
         */
        public MooreBuilder2 from(Object stateId) {
            delegate.from(stateId);
            return getMooreBuilder2();
        }

        /**
         *  Starts a definition of transition(s) from multiple given source states.
         *
         *  @param firstStateId
         *          the mandatory object to identify the first state
         *  @param otherStateIds
         *          the optional objects to identify additional states
         * @return the next fluent state
         */
        public MooreBuilder2 from(Object firstStateId, Object... otherStateIds) {
            delegate.from(firstStateId, otherStateIds);
            return getMooreBuilder2();
        }

        /**
         *  Associates with the given state the given output symbol.
         *
         *  @param stateId
         *          the object to identify the state
         *  @param output
         *          the output symbol
         * @return the next fluent state
         */
        public MooreBuilder0 withOutput(Object stateId, O output) {
            delegate.withOutput(stateId, output);
            return getMooreBuilder0();
        }

        /**
         *  Sets the input symbol of the current transition definition(s).
         *
         *  @param input
         *          the input symbol
         * @return the next fluent state
         */
        public MooreBuilder4 on(I input) {
            delegate.on(input);
            return getMooreBuilder4();
        }

        /**
         *  Sets multiple input symbols of the current transition definition(s).
         *
         *  @param firstInput
         *          the mandatory first input symbol
         *  @param otherInputs
         *          the optional additional input symbols
         * @return the next fluent state
         */
        @SafeVarargs
        public final MooreBuilder4 on(I firstInput, I... otherInputs) {
            delegate.on(firstInput, otherInputs);
            return getMooreBuilder4();
        }
    }
}
