/* Copyright (C) 2013-2025 TU Dortmund University
 * This file is part of AutomataLib <https://automatalib.net>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.automatalib.util.ts.iterator;

import java.util.Collection;
import java.util.Iterator;

import net.automatalib.common.util.collection.AbstractSimplifiedIterator;
import net.automatalib.ts.TransitionSystem;

public final class UndefinedInputsIterator<S, I> extends AbstractSimplifiedIterator<I> {

    private final TransitionSystem<S, I, ?> ts;
    private final Iterator<? extends I> inputsIt;
    private final S state;

    public UndefinedInputsIterator(TransitionSystem<S, I, ?> ts, S state, Iterator<? extends I> inputsIt) {
        this.ts = ts;
        this.inputsIt = inputsIt;
        this.state = state;
    }

    @Override
    protected boolean calculateNext() {
        while (inputsIt.hasNext()) {
            I input = inputsIt.next();
            Collection<?> transitions = ts.getTransitions(state, input);
            if (transitions.isEmpty()) {
                super.nextValue = input;
                return true;
            }
        }
        return false;
    }
}
