/* Copyright (C) 2013 TU Dortmund
 * This file is part of AutomataLib, http://www.automatalib.net/.
 * 
 * AutomataLib is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 3.0 as published by the Free Software Foundation.
 * 
 * AutomataLib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with AutomataLib; if not, see
 * http://www.gnu.de/documents/lgpl.en.html.
 */
package net.automatalib.automata.transout.impl;

import net.automatalib.automata.base.fast.FastDetState;

/**
 * A state in a {@link FastMoore} automaton.
 *  
 * @author Malte Isberner 
 *
 * @param <O> output symbol class.
 */
public final class FastMooreState<O> extends FastDetState<FastMooreState<O>,FastMooreState<O>> {
	private O output;
	
	/**
	 * Constructor.
	 * @param numInputs number of input symbols.
	 * @param output output symbol.
	 */
	public FastMooreState(int numInputs, O output) {
		super(numInputs);
		this.output = output;
	}

	/**
	 * Retrieves the output symbol generated by this state.
	 * @return the output symbol.
	 */
	public O getOutput() {
		return output;
	}

	/**
	 * Sets the output symbol generated by this state.
	 * @param output the output symbol.
	 */
	public void setOutput(O output) {
		this.output = output;
	}
}
