/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.AddressDAO;
import net.blugrid.core.model.Address;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AddressDAOImpl
implements AddressDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Address postPartyAddress(Token token, Address address, UUID partyuud) {
        Address response = new Address();
        response = address;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outaddressuuid as addressuuid  FROM proc_post_party_address ( :sessiontoken::t_pgpmessage, :partyuuid::t_uuid,  :contactpurposetypecode::t_contactpurposetype, :addressuuid::t_uuid, :addressline1::t_Address, :addressline2::t_Address, :addressline3::t_Address, :incityname::t_City, :instatename::t_name, :postalcode::t_PostalCode,  :incountrycode2::t_code2,  :instatecode::t_code,  :status::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("partyuuid", (Object)partyuud);
        parameters.addValue("addressuuid", (Object)address.getAddressuuid());
        parameters.addValue("contactpurposetypecode", (Object)address.getContactpurposetypecode());
        parameters.addValue("addressline1", (Object)address.getAddressline1());
        parameters.addValue("addressline2", (Object)address.getAddressline2());
        parameters.addValue("addressline3", (Object)address.getAddressline3());
        parameters.addValue("incityname", (Object)address.getCityname());
        parameters.addValue("instatename", (Object)address.getStatename());
        parameters.addValue("postalcode", (Object)address.getPostalcode());
        parameters.addValue("incountrycode2", (Object)address.getCountry().getCountrycode2());
        parameters.addValue("instatecode", (Object)address.getState().getCode());
        parameters.addValue("status", (Object)address.getStatus());
        Address addr = (Address)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Address.class));
        response.setAddressuuid(addr.getAddressuuid());
        return response;
    }

    @Override
    public Address postWebsiteAddress(Token token, Address address, UUID deviceuuid) {
        Address response = new Address();
        response = address;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outaddressuuid as addressuuid  FROM proc_post_website_address ( :sessiontoken::t_pgpmessage, :indeviceuuid::t_uuid,  :contactpurposetypecode::t_contactpurposetype, :addressuuid::t_uuid, :addressline1::t_Address, :addressline2::t_Address, :addressline3::t_Address, :incityname::t_City, :instatename::t_name, :postalcode::t_PostalCode,  :incountrycode2::t_code2,  :instatecode::t_code,  :status::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("indeviceuuid", (Object)deviceuuid);
        parameters.addValue("addressuuid", (Object)address.getAddressuuid());
        parameters.addValue("contactpurposetypecode", (Object)address.getContactpurposetypecode());
        parameters.addValue("addressline1", (Object)address.getAddressline1());
        parameters.addValue("addressline2", (Object)address.getAddressline2());
        parameters.addValue("addressline3", (Object)address.getAddressline3());
        parameters.addValue("incityname", (Object)address.getCityname());
        parameters.addValue("instatename", (Object)address.getStatename());
        parameters.addValue("postalcode", (Object)address.getPostalcode());
        parameters.addValue("incountrycode2", (Object)address.getCountry().getCountrycode2());
        parameters.addValue("instatecode", (Object)address.getState().getCode());
        parameters.addValue("status", (Object)address.getStatus());
        Address addr = (Address)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Address.class));
        response.setAddressuuid(addr.getAddressuuid());
        return response;
    }
}

