/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.AdvertisingCampaignDAO;
import net.blugrid.core.dao.AdvertisingSetDAO;
import net.blugrid.core.model.AdvertisingCampaign;
import net.blugrid.core.model.AdvertisingCampaignResponse;
import net.blugrid.core.model.AdvertisingSet;
import net.blugrid.core.model.AdvertisingSetResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AdvertisingCampaignDAOImpl
implements AdvertisingCampaignDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private AdvertisingSetDAO AdvertisingSetdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_advertisingcampaign(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_advertisingcampaign(    :token::t_pgpmessage,    :inadvertisingcampaignuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inadvertisingcampaignuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public AdvertisingCampaignResponse post(Token token, AdvertisingCampaign advertisingcampaign) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_advertisingcampaign(    :token::t_pgpmessage,    :inadvertisingcampaignuuid::t_uuid,   :inadvertisingcampaignname::t_name,    :ineffectivetimestamp::t_timestamp,    :inexpirytimestamp::t_timestamp,    :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (advertisingcampaign.getAdvertisingcampaignuuid() != null) {
            parameters.addValue("inadvertisingcampaignuuid", (Object)advertisingcampaign.getAdvertisingcampaignuuid());
        } else {
            parameters.addValue("inadvertisingcampaignuuid", null);
        }
        parameters.addValue("inadvertisingcampaignname", (Object)advertisingcampaign.getAdvertisingcampaignname());
        parameters.addValue("ineffectivetimestamp", (Object)advertisingcampaign.getEffectivetimestamp());
        parameters.addValue("inexpirytimestamp", (Object)advertisingcampaign.getExpirytimestamp());
        parameters.addValue("instatus", (Object)advertisingcampaign.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        AdvertisingCampaignResponse response = PostgresqlJson.jsonToAdvertisingCampaignResponse((JsonData)json);
        if (response.getStatus().equalsIgnoreCase("OK")) {
            ArrayList<AdvertisingSet> advertisingset = new ArrayList<AdvertisingSet>();
            for (int i = 0; i < advertisingcampaign.getAdvertisingsets().size(); ++i) {
                ((AdvertisingSet)advertisingcampaign.getAdvertisingsets().get(i)).setAdvertisingcampaignuuid(response.getAdvertisingcampaign().getAdvertisingcampaignuuid());
                AdvertisingSetResponse advertisingsetresponse = this.AdvertisingSetdao.post(token, (AdvertisingSet)advertisingcampaign.getAdvertisingsets().get(i));
                if (!advertisingsetresponse.getStatus().equalsIgnoreCase("OK")) continue;
                advertisingset.add(advertisingsetresponse.getAdvertisingset());
            }
            response.getAdvertisingcampaign().setAdvertisingsets(advertisingset);
        }
        return response;
    }
}

