/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.CustomerAccountDAO;
import net.blugrid.core.model.CompetitionCustomerAccount;
import net.blugrid.core.model.CompetitionCustomerAccountResponse;
import net.blugrid.core.model.CustomerAccount;
import net.blugrid.core.model.EventCustomerAccount;
import net.blugrid.core.model.EventCustomerAccountResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerAccountDAOImpl
implements CustomerAccountDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public CompetitionCustomerAccount postCompetition(Token Token2, CompetitionCustomerAccount custacc) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT c.outcustomeraccountuuid AS customeraccountuuid FROM proc_post_customeraccount (  :sessiontoken::t_pgpmessage,  :partyuuid::t_uuid,  :customeraccountuuid::t_uuid,  :customeraccounttype::t_customeraccounttype,  :customeraccountcode::t_codemetadata,  :lastchangedatetime::t_timestampz,  :effectivedate::t_timestampz,  :expirationdate::t_timestampz,   :customeraccountstatus::t_customeraccountstatus,   :competitionuuid::t_uuid,   NULL:t_uuid ) c ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("partyuuid", (Object)custacc.getPartyuuid());
        parameters.addValue("customeraccountuuid", (Object)custacc.getCustomeraccountuuid());
        parameters.addValue("customeraccounttype", (Object)custacc.getCustomeraccounttype());
        parameters.addValue("customeraccountcode", (Object)custacc.getCustomeraccountcode());
        parameters.addValue("lastchangedatetime", (Object)custacc.getLastchangedatetime());
        parameters.addValue("effectivedate", (Object)custacc.getEffectivedate());
        parameters.addValue("expirationdate", (Object)custacc.getExpirationdate());
        parameters.addValue("competitionuuid", (Object)custacc.getCompetition().getCompetitionuuid());
        parameters.addValue("customeraccountstatus", (Object)"New");
        CustomerAccount newcustacc = (CustomerAccount)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerAccount.class));
        custacc.setCustomeraccountuuid(newcustacc.getCustomeraccountuuid());
        return custacc;
    }

    @Override
    public EventCustomerAccount postEvent(Token Token2, EventCustomerAccount custacc) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT c.outcustomeraccountuuid AS customeraccountuuid FROM proc_post_customeraccount (  :sessiontoken::t_pgpmessage,  :partyuuid::t_uuid,  :customeraccountuuid::t_uuid,  :customeraccounttype::t_customeraccounttype,  :customeraccountcode::t_codemetadata,  :lastchangedatetime::t_timestampz,  :effectivedate::t_timestampz,  :expirationdate::t_timestampz,   :customeraccountstatus::t_customeraccountstatus,   NULL::t_uuid,   :eventuuid::t_uuid ) c ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("partyuuid", (Object)custacc.getPartyuuid());
        parameters.addValue("customeraccountuuid", (Object)custacc.getCustomeraccountuuid());
        parameters.addValue("customeraccounttype", (Object)"Event");
        parameters.addValue("customeraccountcode", (Object)custacc.getCustomeraccountcode());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        parameters.addValue("lastchangedatetime", (Object)dateFormat.format(custacc.getLastchangedatetime()));
        parameters.addValue("effectivedate", (Object)dateFormat.format(custacc.getEffectivedate()));
        parameters.addValue("expirationdate", (Object)dateFormat.format(custacc.getExpirationdate()));
        parameters.addValue("eventuuid", (Object)custacc.getEvent().getEventuuid());
        parameters.addValue("customeraccountstatus", (Object)"New");
        CustomerAccount newcustacc = (CustomerAccount)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerAccount.class));
        custacc.setCustomeraccountuuid(newcustacc.getCustomeraccountuuid());
        return custacc;
    }

    @Override
    public CompetitionCustomerAccountResponse getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_customeraccount(  :sessiontoken::t_pgpmessage,  :competitionuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("competitionuuid", (Object)uuid);
        CompetitionCustomerAccountResponse response = (CompetitionCustomerAccountResponse)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(CompetitionCustomerAccountResponse.class));
        return response;
    }

    @Override
    public EventCustomerAccountResponse getByEventCustomerByUUID(Token token, UUID uuid) {
        EventCustomerAccountResponse response = new EventCustomerAccountResponse();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_eventcustomeraccount(  :sessiontoken::t_pgpmessage,  :customeracountuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("customeracountuuid", (Object)uuid);
        List jsondata = namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        EventCustomerAccount ctac = PostgresqlJson.jsonToEventCustomerAccount((JsonData)((JsonData)jsondata.get(0)));
        response.setCustomeraccount(ctac);
        response.setStatus("OK");
        return response;
    }

    @Override
    public CompetitionCustomerAccountResponse activateByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outstatus::text AS status,     outsource::text AS source,      outmessage::text AS message   FROM proc_post_customeraccount (     :sessiontoken::t_pgpmessage,    :customeraccountuuid::t_uuid,     :customeraccountstatus::t_customeraccountstatus ) c ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("customeraccountuuid", (Object)uuid);
        parameters.addValue("customeraccountstatus", (Object)"Active");
        CompetitionCustomerAccountResponse response = (CompetitionCustomerAccountResponse)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(CompetitionCustomerAccountResponse.class));
        return response;
    }
}

