/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.FormTemplateDAO;
import net.blugrid.core.model.FormTemplate;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class FormTemplateDAOImpl
implements FormTemplateDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson as json FROM proc_view_formtemplate(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson as json FROM proc_view_formtemplate(    :token::t_pgpmessage,    :informtemplatetemplateuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("informtemplatetemplateuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public FormTemplate post(Token token, FormTemplate formtemplate) {
        FormTemplate response = new FormTemplate();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outformtemplateuuid as formtemplateuuid  FROM proc_post_formtemplate(    :token::t_pgpmessage,    :informtemplateuuid::t_uuid,    :informtemplatename::t_name  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("informtemplateuuid", (Object)formtemplate.getFormtemplateuuid().toString());
        parameters.addValue("informtemplatename", (Object)formtemplate.getFormtemplatename());
        response = (FormTemplate)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(FormTemplate.class));
        return response;
    }

    @Override
    public FormTemplate updateModelData(Token token, UUID uuid, String modeldata) {
        FormTemplate response = new FormTemplate();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outformtemplateuuid as formtemplateuuid  FROM proc_post_formtemplate(    :token::t_pgpmessage,    :inwebcontentuuid::t_uuid,    null::t_json,    null::t_json,    :inmodeldata::t_json  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inwebcontentuuid", (Object)uuid.toString());
        parameters.addValue("inmodeldata", (Object)modeldata);
        response = (FormTemplate)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(FormTemplate.class));
        return response;
    }

    @Override
    public FormTemplate updateFormData(Token token, UUID uuid, String formdata) {
        FormTemplate response = new FormTemplate();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outformtemplateuuid as formtemplateuuid  FROM proc_post_formtemplate(    :token::t_pgpmessage,    :inwebcontentuuid::t_uuid,    :informdata::t_json,    null::t_json,    null::t_json  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inwebcontentuuid", (Object)uuid.toString());
        parameters.addValue("informdata", (Object)formdata);
        response = (FormTemplate)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(FormTemplate.class));
        return response;
    }

    @Override
    public FormTemplate updateSchemaData(Token token, UUID uuid, String schemadata) {
        FormTemplate response = new FormTemplate();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outformtemplateuuid as formtemplateuuid  FROM proc_post_formtemplate(    :token::t_pgpmessage,    :inwebcontentuuid::t_uuid,    null::t_json,    :inschemadata::t_json,    null::t_json  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inwebcontentuuid", (Object)uuid.toString());
        parameters.addValue("inschemadata", (Object)schemadata);
        response = (FormTemplate)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(FormTemplate.class));
        return response;
    }
}

