/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import net.blugrid.core.dao.GoogleAnalyticsAccountDAO;
import net.blugrid.core.model.GoogleAnalyticsAccount;
import net.blugrid.core.model.GoogleAnalyticsAccountResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class GoogleAnalyticsAccountDAOImpl
implements GoogleAnalyticsAccountDAO {
    private static final Logger logger = Logger.getLogger(GoogleAnalyticsAccountDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_googleanalyticsaccount(    :token::t_pgpmessage,    null::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public GoogleAnalyticsAccountResponse post(Token token, GoogleAnalyticsAccount googleanalyticsaccount) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_googleanalyticsaccount(   :insessiontoken::t_pgpmessage,   :ingoogleanalyticsaccountuuid::t_uuid,   :ingoogleanalyticsaccountname::t_name,   :intrackingid::t_code,   :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("ingoogleanalyticsaccountuuid", (Object)googleanalyticsaccount.getGoogleanalyticsaccountuuid());
        parameters.addValue("ingoogleanalyticsaccountname", (Object)googleanalyticsaccount.getGoogleanalyticsaccountname());
        parameters.addValue("intrackingid", (Object)googleanalyticsaccount.getTrackingid());
        parameters.addValue("instatus", (Object)googleanalyticsaccount.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        GoogleAnalyticsAccountResponse response = PostgresqlJson.jsonToGoogleAnalyticsAccountResponse((String)json.getJson());
        return response;
    }

    @Override
    public List<GoogleAnalyticsAccount> postList(Token token, List<GoogleAnalyticsAccount> googleanalyticsaccountList) {
        ArrayList<GoogleAnalyticsAccount> response = new ArrayList<GoogleAnalyticsAccount>();
        if (googleanalyticsaccountList != null) {
            for (int i = 0; i < googleanalyticsaccountList.size(); ++i) {
                GoogleAnalyticsAccountResponse sp = this.post(token, googleanalyticsaccountList.get(i));
                if (!sp.getStatus().equalsIgnoreCase("OK")) continue;
                response.add(sp.getGoogleanalyticsaccount());
            }
        }
        return response;
    }
}

