/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import javax.sql.DataSource;
import net.blugrid.core.dao.HashtagDAO;
import net.blugrid.core.model.Hashtag;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class HashtagDAOImpl
implements HashtagDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_hashtag(   :token::t_pgpmessage ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public Hashtag post(Token Token2, Hashtag hashtag) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outhashtaguuid AS hashtaguuid FROM proc_post_hashtag(   :insessiontoken::t_pgpmessage,  :inhashtaguuid::t_uuid,  :inhashtagname::t_descriptionshort  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("inhashtaguuid", (Object)hashtag.getHashtaguuid());
        parameters.addValue("inhashtagname", (Object)hashtag.getHashtag());
        Hashtag uuid = (Hashtag)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Hashtag.class));
        hashtag.setHashtaguuid(uuid.getHashtaguuid());
        return hashtag;
    }
}

