/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.ItemDAO;
import net.blugrid.core.dao.WebPageDAO;
import net.blugrid.core.model.Image;
import net.blugrid.core.model.Item;
import net.blugrid.core.model.ItemClassificationValue;
import net.blugrid.core.model.ItemCollection;
import net.blugrid.core.model.ItemResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.OptionSet;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Subscription;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.UuidResponse;
import net.blugrid.core.model.WebPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ItemDAOImpl
implements ItemDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebPageDAO WebPagedao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_item(:token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_item(:token::t_pgpmessage,   :itemuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("itemuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public List<Item> put(Token token, List<Item> itemlist) {
        ArrayList<Item> newitems = new ArrayList<Item>();
        for (int i = 0; i < itemlist.size(); ++i) {
            ItemResponse itemResponse = new ItemResponse();
            itemResponse = this.post(token, itemlist.get(i));
            newitems.add(itemResponse.getItem());
        }
        return newitems;
    }

    @Override
    public ItemResponse post(Token Token2, Item item) {
        MapSqlParameterSource eparameters;
        int i;
        ItemResponse itemResponse = new ItemResponse();
        itemResponse.setStatus("OK");
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outstatus AS status,    outsource AS source,    outmessage AS message,    outitemuuid::t_uuid AS uuid FROM proc_post_item (    :sessiontoken::t_pgpmessage,   :itemuuid::t_uuid,   :typecode::t_itemtype,   :name::t_name,   :description::t_descriptionshort,   :shortdescription::t_code,   :longdescription::t_descriptionnarrative,   :itemcode::t_code,   :cost::t_money,   :rrp::t_money,   :normalprice::t_money,   :currentprice::t_money,   :rangedflag::t_flagyes,   :activeflag::t_flagyes,   :discountflag::t_flagyes,   :priceauditflag::t_flag,   :authorizedtosellflag::t_flagyes,   :loyaltyexemptflag::t_flag,   :sellinguomcode::t_code,   :itemcategoryuuid::t_uuid,   :familyuuid::t_uuid,   :branduuid::t_uuid,   :manufactureruuid::t_uuid,    :indocumentuuid::t_uuid,    :ineventuuid::t_uuid,    :ineventadmissionclassuuid::t_uuid,    :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("itemuuid", (Object)item.getItemuuid());
        parameters.addValue("name", (Object)item.getName());
        parameters.addValue("typecode", (Object)item.getTypecode());
        parameters.addValue("description", (Object)item.getDescription());
        parameters.addValue("shortdescription", (Object)item.getShortdescription());
        parameters.addValue("longdescription", (Object)item.getLongdescription());
        parameters.addValue("itemcode", (Object)item.getItemcode());
        parameters.addValue("cost", (Object)item.getCost());
        parameters.addValue("rrp", (Object)item.getRrp());
        parameters.addValue("normalprice", (Object)item.getNormalprice());
        parameters.addValue("currentprice", (Object)item.getCurrentprice());
        parameters.addValue("rangedflag", (Object)item.getRangedflag());
        parameters.addValue("activeflag", (Object)item.getActiveflag());
        parameters.addValue("discountflag", (Object)item.getDiscountflag());
        parameters.addValue("priceauditflag", (Object)item.getPriceauditflag());
        parameters.addValue("authorizedtosellflag", (Object)item.getAuthorizedtosellflag());
        parameters.addValue("loyaltyexemptflag", (Object)item.getLoyaltyexemptflag());
        if (item.getSelluom() != null) {
            parameters.addValue("sellinguomcode", (Object)item.getSelluom().getUnitofmeasurecode());
        } else {
            parameters.addValue("sellinguomcode", (Object)"");
        }
        parameters.addValue("itemcategoryuuid", (Object)item.getItemcategory().getItemcategoryuuid());
        parameters.addValue("familyuuid", null);
        parameters.addValue("branduuid", null);
        parameters.addValue("manufactureruuid", null);
        if (item.getTermsofservicedocument() != null) {
            parameters.addValue("indocumentuuid", (Object)item.getTermsofservicedocument().getDocumentuuid());
        } else {
            parameters.addValue("indocumentuuid", null);
        }
        if (item.getEventticket() != null) {
            parameters.addValue("ineventuuid", (Object)item.getEventticket().getEventuuid());
            if (item.getEventticket().getEventadmissionclass() != null) {
                parameters.addValue("ineventadmissionclassuuid", (Object)item.getEventticket().getEventadmissionclass().getEventadmissionclassuuid());
            } else {
                parameters.addValue("ineventadmissionclassuuid", null);
            }
        } else {
            parameters.addValue("ineventuuid", null);
            parameters.addValue("ineventadmissionclassuuid", null);
        }
        parameters.addValue("instatus", (Object)item.getStatus());
        UuidResponse uuid = new UuidResponse();
        uuid = (UuidResponse)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(UuidResponse.class));
        if (!uuid.getStatus().equalsIgnoreCase("OK")) {
            itemResponse.setStatus(uuid.getStatus());
            itemResponse.setSource(uuid.getSource());
            itemResponse.setMessage(uuid.getMessage());
            return itemResponse;
        }
        item.setItemuuid(uuid.getUuid());
        if (!item.getItemclassificationvalues().isEmpty()) {
            this.PostItemClassificationValues(Token2, item.getItemclassificationvalues(), item.getItemuuid());
        }
        if (!item.getItemoptionsets().isEmpty()) {
            ArrayList<OptionSet> optsetList = new ArrayList<OptionSet>();
            String attsql = "SELECT outoptionsetuuid as optionsetuuid  FROM proc_post_itemoptionset (    :sessiontoken::t_pgpmessage,    :optionsetuuid::t_uuid,    :optionsetname::t_name,    :itemuuid::t_uuid,    :itemuuidlist::text[] ) ";
            for (i = 0; i < item.getItemoptionsets().size(); ++i) {
                MapSqlParameterSource eparameters2 = new MapSqlParameterSource();
                eparameters2.addValue("sessiontoken", (Object)Token2.getid_token());
                eparameters2.addValue("optionsetuuid", (Object)((OptionSet)item.getItemoptionsets().get(i)).getOptionsetuuid());
                eparameters2.addValue("optionsetname", (Object)((OptionSet)item.getItemoptionsets().get(i)).getOptionsetname());
                eparameters2.addValue("itemuuid", (Object)item.getItemuuid());
                ArrayList<String> optionslist = new ArrayList<String>();
                for (int j = 0; j < ((OptionSet)item.getItemoptionsets().get(i)).getOptionsetoptions().size(); ++j) {
                    String itmuuid = ((Item)((OptionSet)item.getItemoptionsets().get(i)).getOptionsetoptions().get(j)).getItemuuid().toString();
                    optionslist.add(itmuuid);
                }
                String optionstr = ((Object)optionslist).toString();
                optionstr = optionstr.replace("[", "{");
                optionstr = optionstr.replace("]", "}");
                eparameters2.addValue("itemuuidlist", (Object)optionstr);
                OptionSet optset = (OptionSet)namedParameterJdbcTemplate.queryForObject(attsql, (SqlParameterSource)eparameters2, (RowMapper)BeanPropertyRowMapper.newInstance(OptionSet.class));
                optsetList.add(optset);
            }
            item.setItemoptionsets(optsetList);
        }
        if (!item.getItemcollection().isEmpty()) {
            String attsql = "SELECT outstatus as status  FROM proc_post_itemcollection (    :insessiontoken::t_pgpmessage,    :initemuuid::t_uuid,    :initemuuidlist::text[],    :initemcontentslist::float[] ) ";
            eparameters = new MapSqlParameterSource();
            eparameters.addValue("insessiontoken", (Object)Token2.getid_token());
            eparameters.addValue("initemuuid", (Object)item.getItemuuid());
            ArrayList<String> itemslist = new ArrayList<String>();
            for (int j = 0; j < item.getItemcollection().size(); ++j) {
                if (((ItemCollection)item.getItemcollection().get(j)).getItem() == null) continue;
                String itmuuid = ((ItemCollection)item.getItemcollection().get(j)).getItem().getItemuuid().toString();
                itemslist.add(itmuuid);
            }
            String itemsstr = ((Object)itemslist).toString();
            itemsstr = itemsstr.replace("[", "{");
            itemsstr = itemsstr.replace("]", "}");
            eparameters.addValue("initemuuidlist", (Object)itemsstr);
            ArrayList<String> contentslist = new ArrayList<String>();
            for (int j = 0; j < item.getItemcollection().size(); ++j) {
                String itemcontents = ((ItemCollection)item.getItemcollection().get(j)).getContents().toString();
                contentslist.add(itemcontents);
            }
            String contentsstr = ((Object)contentslist).toString();
            contentsstr = contentsstr.replace("[", "{");
            contentsstr = contentsstr.replace("]", "}");
            eparameters.addValue("initemcontentslist", (Object)contentsstr);
            Response response = (Response)namedParameterJdbcTemplate.queryForObject(attsql, (SqlParameterSource)eparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
            for (int i2 = 0; i2 < item.getItemcollection().size(); ++i2) {
                if (((ItemCollection)item.getItemcollection().get(i2)).getItem().getItemclassificationvalues().isEmpty()) continue;
                this.PostItemClassificationValues(Token2, ((ItemCollection)item.getItemcollection().get(i2)).getItem().getItemclassificationvalues(), ((ItemCollection)item.getItemcollection().get(i2)).getItem().getItemuuid());
            }
        }
        if (!item.getWebpages().isEmpty()) {
            for (int i3 = 0; i3 < item.getWebpages().size(); ++i3) {
                ObjectResponse<WebPage> webpageResponse = this.WebPagedao.postByUUID(Token2, (WebPage)item.getWebpages().get(i3));
                if (!webpageResponse.getStatus().equalsIgnoreCase("OK") || webpageResponse.getData() == null) continue;
                item.getWebpages().set(i3, webpageResponse.getData());
            }
        }
        if (!item.getSubscriptions().isEmpty()) {
            String websql = "SELECT outsubscriptionuuid as subscriptionuuid  FROM proc_post_subscription (    :insessiontoken::t_pgpmessage,    :insubscriptionuuid::t_uuid,    :insubscriptionname::t_descriptionshort,    :insubscriptiondescription::t_text,    :intermperiodinterval::t_periodintervaltype,    :intermperiodcount::t_shortcount1,    :inrrptermprice::t_money,    :inrrponceoffprice::t_money,    :innormaltermprice::t_money,    :innormalonceoffprice::t_money,    :incurrenttermprice::t_money,    :incurrentonceoffprice::t_money,    :initemuuid::t_uuid,    :indocumentuuid::t_uuid ) ";
            eparameters = new MapSqlParameterSource();
            eparameters.addValue("insessiontoken", (Object)Token2.getid_token());
            eparameters.addValue("initemuuid", (Object)item.getItemuuid());
            for (i = 0; i < item.getSubscriptions().size(); ++i) {
                eparameters.addValue("insubscriptionuuid", (Object)((Subscription)item.getSubscriptions().get(i)).getSubscriptionuuid());
                eparameters.addValue("insubscriptionname", (Object)((Subscription)item.getSubscriptions().get(i)).getSubscriptionname());
                eparameters.addValue("insubscriptiondescription", (Object)((Subscription)item.getSubscriptions().get(i)).getSubscriptiondescription());
                eparameters.addValue("intermperiodinterval", (Object)((Subscription)item.getSubscriptions().get(i)).getTermperiodinterval());
                eparameters.addValue("intermperiodcount", (Object)((Subscription)item.getSubscriptions().get(i)).getTermperiodcount());
                eparameters.addValue("inrrptermprice", (Object)((Subscription)item.getSubscriptions().get(i)).getRrptermprice());
                eparameters.addValue("inrrponceoffprice", (Object)((Subscription)item.getSubscriptions().get(i)).getRrponceoffprice());
                eparameters.addValue("innormaltermprice", (Object)((Subscription)item.getSubscriptions().get(i)).getNormaltermprice());
                eparameters.addValue("innormalonceoffprice", (Object)((Subscription)item.getSubscriptions().get(i)).getNormalonceoffprice());
                eparameters.addValue("incurrenttermprice", (Object)((Subscription)item.getSubscriptions().get(i)).getCurrenttermprice());
                eparameters.addValue("incurrentonceoffprice", (Object)((Subscription)item.getSubscriptions().get(i)).getCurrentonceoffprice());
                if (((Subscription)item.getSubscriptions().get(i)).getTermofservicedocument() != null) {
                    eparameters.addValue("indocumentuuid", (Object)((Subscription)item.getSubscriptions().get(i)).getTermofservicedocument().getDocumentuuid().toString());
                } else {
                    eparameters.addValue("indocumentuuid", null);
                }
                Subscription subscription = (Subscription)namedParameterJdbcTemplate.queryForObject(websql, (SqlParameterSource)eparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Subscription.class));
                ((Subscription)item.getSubscriptions().get(i)).setSubscriptionuuid(subscription.getSubscriptionuuid());
            }
        }
        itemResponse.setItem(item);
        itemResponse.setStatus("OK");
        return itemResponse;
    }

    @Override
    public Image postImage(Token Token2, Item item, Image image) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outimageuuid AS imageuuid FROM proc_post_image (    :sessiontoken::t_pgpmessage,   :imageuuid::t_uuid,   :name::t_name,   :url::t_urladdress,   :filename::t_descriptionshort,   :itemuuid::t_uuid,    NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("imageuuid", (Object)image.getImageuuid());
        parameters.addValue("name", (Object)image.getName());
        parameters.addValue("url", (Object)image.getUrl());
        parameters.addValue("filename", (Object)image.getFilename());
        parameters.addValue("itemuuid", (Object)item.getItemuuid());
        Image imguuid = (Image)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Image.class));
        image.setImageuuid(imguuid.getImageuuid());
        return image;
    }

    private void PostItemClassificationValues(Token token, List<ItemClassificationValue> itemclassificationlist, UUID itemuuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String attsql = "SELECT outstatus as status,   outsource as source,   outmessage as message  FROM proc_post_itemclassificationvalue (  :sessiontoken::t_pgpmessage,  :attributeuuid::t_uuid,  :value::t_name,  :valuedescription::t_description,  :itemuuid::t_uuid ) ";
        for (int i = 0; i < itemclassificationlist.size(); ++i) {
            ItemClassificationValue itemclassification = new ItemClassificationValue();
            MapSqlParameterSource eparameters = new MapSqlParameterSource();
            eparameters.addValue("sessiontoken", (Object)token.getid_token());
            eparameters.addValue("attributeuuid", (Object)itemclassificationlist.get(i).getAttributeuuid());
            eparameters.addValue("value", (Object)itemclassificationlist.get(i).getValue());
            eparameters.addValue("valuedescription", (Object)itemclassificationlist.get(i).getValuedescription());
            eparameters.addValue("itemuuid", (Object)itemuuid);
            Response response = (Response)namedParameterJdbcTemplate.queryForObject(attsql, (SqlParameterSource)eparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        }
    }

    @Override
    public String itemCompare(Token token, List<Item> itemList) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_item_compare(   :token::t_pgpmessage,   :initemuuidlist::text[] ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        ArrayList<String> list = new ArrayList<String>();
        for (int j = 0; j < itemList.size(); ++j) {
            String uuid = itemList.get(j).getItemuuid().toString();
            list.add(uuid);
        }
        String str = ((Object)list).toString();
        str = str.replace("[", "{");
        str = str.replace("]", "}");
        parameters.addValue("initemuuidlist", (Object)str);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }
}

