/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.LocationDAO;
import net.blugrid.core.dao.PositionDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Location;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Position;
import net.blugrid.core.model.Token;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PositionDAOImpl
implements PositionDAO {
    private static final Logger logger = Logger.getLogger(PositionDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private LocationDAO Locationdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_position(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_position(   :token::t_pgpmessage,   :inpositionuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inpositionuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public ObjectResponse<Position> post(Token Token2, Position position) {
        ObjectResponse<Location> locationResponse;
        if (position.getLocation() != null && (locationResponse = this.Locationdao.post(Token2, position.getLocation())).getStatus().equalsIgnoreCase("OK") && locationResponse.getData() != null) {
            position.setLocation((Location)locationResponse.getData());
        }
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_position(   :insessiontoken::t_pgpmessage,  :inpositionuuid::t_uuid,  :inpositioncode::t_code,  :intitle::t_descriptionshort,  :indescription::t_descriptionshort,  :innotes::t_text,  :inlocationuuid::t_uuid,  :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("inpositionuuid", (Object)position.getPositionuuid());
        parameters.addValue("inpositioncode", (Object)position.getPositioncode());
        parameters.addValue("intitle", (Object)position.getTitle());
        parameters.addValue("indescription", (Object)position.getDescription());
        parameters.addValue("innotes", (Object)position.getNotes());
        parameters.addValue("inlocationuuid", (Object)position.getLocation().getLocationuuid());
        parameters.addValue("instatus", (Object)position.getStatus());
        JsonData jsondata = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<Position>>(){}.getType();
        ObjectResponse resp = (ObjectResponse)new Gson().fromJson(jsondata.getJson(), type);
        return resp;
    }
}

