/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.SurveyDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.SurveyResponse;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SurveyDAOImpl
implements SurveyDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getByUUID(Token Token2, UUID partyuuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT s.outsurveydata AS survey FROM proc_vw_survey_results (  :sessiontoken::t_pgpmessage,  :partyuuid::t_uuid ) s ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("partyuuid", (Object)partyuuid);
        String survey = null;
        survey = (String)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, String.class);
        return survey;
    }

    @Override
    public String postSurveyResponse(Token token, SurveyResponse surveyresponse) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_surveyresponse (  :sessiontoken::t_pgpmessage,  :partyuuid::t_uuid,   :insurveyuuid::t_uuid,   :inresponsedata::t_json  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("partyuuid", (Object)surveyresponse.getPartyuuid());
        parameters.addValue("insurveyuuid", (Object)surveyresponse.getSurveyuuid());
        parameters.addValue("inresponsedata", surveyresponse.getResponsedata());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }
}

