/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.TargetLocationDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.TargetLocation;
import net.blugrid.core.model.TargetLocationResponse;
import net.blugrid.core.model.TargetLocationSelector;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TargetLocationDAOImpl
implements TargetLocationDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_targetlocation(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_targetlocation(    :token::t_pgpmessage,    :intargetlocationuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("intargetlocationuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public TargetLocationResponse post(Token token, TargetLocation targetlocation) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_targetlocation(    :token::t_pgpmessage,    :intargetlocationuuid::t_uuid,   :intargetlocationname::t_name,    :inproximity::t_quantity,   :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (targetlocation.getTargetlocationuuid() != null) {
            parameters.addValue("intargetlocationuuid", (Object)targetlocation.getTargetlocationuuid());
        } else {
            parameters.addValue("intargetlocationuuid", null);
        }
        parameters.addValue("intargetlocationname", (Object)targetlocation.getTargetlocationname());
        parameters.addValue("inproximity", (Object)targetlocation.getProximity());
        parameters.addValue("instatus", (Object)targetlocation.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        TargetLocationResponse response = PostgresqlJson.jsonToTargetLocationResponse((JsonData)json);
        if (response.getStatus().equalsIgnoreCase("OK")) {
            ArrayList newlocationselectors = new ArrayList();
            for (int i = 0; i < targetlocation.getTargetlocationselectors().size(); ++i) {
                sql = "SELECT outjson AS json from proc_post_targetlocationselector(    :token::t_pgpmessage,    :intargetlocationuuid::t_uuid,   :inlocationselectortype::t_locationselectortype,    :inexcludeflag::t_flag,   :inselections::t_text,    :instatus::t_status  ) ";
                MapSqlParameterSource sparameters = new MapSqlParameterSource();
                sparameters.addValue("token", (Object)token.getid_token());
                sparameters.addValue("intargetlocationuuid", (Object)response.getTargetlocation().getTargetlocationuuid());
                sparameters.addValue("inlocationselectortype", (Object)((TargetLocationSelector)targetlocation.getTargetlocationselectors().get(i)).getLocationselectortype());
                sparameters.addValue("inexcludeflag", (Object)((TargetLocationSelector)targetlocation.getTargetlocationselectors().get(i)).getExcludeflag());
                sparameters.addValue("instatus", (Object)((TargetLocationSelector)targetlocation.getTargetlocationselectors().get(i)).getStatus());
                if (((TargetLocationSelector)targetlocation.getTargetlocationselectors().get(i)).getSelections().size() > 0) {
                    ArrayList<String> clist = new ArrayList<String>();
                    for (int j = 0; j < ((TargetLocationSelector)targetlocation.getTargetlocationselectors().get(i)).getSelections().size(); ++j) {
                        String cname = ((String)((TargetLocationSelector)targetlocation.getTargetlocationselectors().get(i)).getSelections().get(j)).toString();
                        clist.add(cname);
                    }
                    String str = ((Object)clist).toString();
                    str = str.replace("[", "{");
                    str = str.replace("]", "}");
                    sparameters.addValue("inselections", (Object)str);
                } else {
                    sparameters.addValue("inselections", null);
                }
                json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)sparameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
                newlocationselectors.add(targetlocation.getTargetlocationselectors().get(i));
            }
            response.getTargetlocation().setTargetlocationselectors(newlocationselectors);
        }
        return response;
    }
}

