/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.WebPageTemplateDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebPageTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class WebPageTemplateDAOImpl
implements WebPageTemplateDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_webpagetemplate(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_webpagetemplate(    :token::t_pgpmessage,    NULL::t_uuid,    :inuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public WebPageTemplate postByUUID(Token token, WebPageTemplate webpagetemplate) {
        WebPageTemplate response = new WebPageTemplate();
        response = webpagetemplate;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String websql = "SELECT outwebpagetemplateuuid as webpagetemplateuuid  FROM proc_post_webpagetemplate (    :insessiontoken::t_pgpmessage,    :inwebpagetemplateuuid::t_uuid,    :inwebpagetemplatename::t_descriptionshort,    :inwebpagetemplatetitle::t_text,    :inwebpagetemplatedescription::t_text,    :inurl::t_descriptionshort,    :inurlparams::t_descriptionshort,    :inmenuitem::t_flag,    :inlinkname::t_descriptionshort,    :inicon::t_name,    :insequence::t_identity,    :inparentuuid::t_uuid,    :initemuuid::t_uuid,    :indeviceuuid::t_uuid ) ";
        MapSqlParameterSource eparameters = new MapSqlParameterSource();
        eparameters.addValue("insessiontoken", (Object)token.getid_token());
        WebPageTemplate uuid = (WebPageTemplate)namedParameterJdbcTemplate.queryForObject(websql, (SqlParameterSource)eparameters, (RowMapper)BeanPropertyRowMapper.newInstance(WebPageTemplate.class));
        response.setWebpagetemplateuuid(uuid.getWebpagetemplateuuid());
        return response;
    }
}

