/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.maven;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.build.maven.MavenCoordinate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderResolver
implements Closeable {
    private final Log log;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;
    private final Map<MavenCoordinate, ClassLoader> classLoaders;

    public ClassLoaderResolver(Log log, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories) {
        this.log = log;
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
        this.classLoaders = new HashMap<MavenCoordinate, ClassLoader>();
    }

    public ClassLoader resolve(MavenCoordinate mavenCoordinate) throws MojoFailureException, MojoExecutionException {
        ClassLoader classLoader = this.classLoaders.get(mavenCoordinate);
        if (classLoader == null) {
            classLoader = this.doResolve(mavenCoordinate);
            this.classLoaders.put(mavenCoordinate, classLoader);
        }
        return classLoader;
    }

    private ClassLoader doResolve(MavenCoordinate mavenCoordinate) throws MojoExecutionException, MojoFailureException {
        ArrayList<URL> urls = new ArrayList<URL>();
        this.log.info((CharSequence)("Resolving transformer dependency: " + mavenCoordinate));
        try {
            DependencyNode root = this.repositorySystem.collectDependencies(this.repositorySystemSession, new CollectRequest(new Dependency(mavenCoordinate.asArtifact(), "runtime"), this.remoteRepositories)).getRoot();
            this.repositorySystem.resolveDependencies(this.repositorySystemSession, new DependencyRequest().setRoot(root));
            PreorderNodeListGenerator preorderNodeListGenerator = new PreorderNodeListGenerator();
            root.accept((DependencyVisitor)preorderNodeListGenerator);
            for (Artifact artifact : preorderNodeListGenerator.getArtifacts(false)) {
                urls.add(artifact.getFile().toURI().toURL());
            }
        }
        catch (DependencyCollectionException exception) {
            throw new MojoExecutionException("Could not collect dependencies for " + mavenCoordinate, (Exception)((Object)exception));
        }
        catch (DependencyResolutionException exception) {
            throw new MojoExecutionException("Could not resolve dependencies for " + mavenCoordinate, (Exception)((Object)exception));
        }
        catch (MalformedURLException exception) {
            throw new MojoFailureException("Could not resolve file as URL for " + mavenCoordinate, (Throwable)exception);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), ByteBuddy.class.getClassLoader());
    }

    @Override
    public void close() throws IOException {
        for (ClassLoader classLoader : this.classLoaders.values()) {
            if (!(classLoader instanceof Closeable)) continue;
            ((Closeable)((Object)classLoader)).close();
        }
    }
}

