/*
 * Decompiled with CFR 0.152.
 */
package net.cassite.daf4j.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.cassite.daf4j.And;
import net.cassite.daf4j.Condition;
import net.cassite.daf4j.ConditionTypes;
import net.cassite.daf4j.DataAccess;
import net.cassite.daf4j.DataUtils;
import net.cassite.daf4j.ExpressionBoolean;
import net.cassite.daf4j.ExpressionTypes;
import net.cassite.daf4j.Focus;
import net.cassite.daf4j.IData;
import net.cassite.daf4j.IExpression;
import net.cassite.daf4j.Or;
import net.cassite.daf4j.OrderBase;
import net.cassite.daf4j.ParameterAggregate;
import net.cassite.daf4j.PreResult;
import net.cassite.daf4j.QueryParameter;
import net.cassite.daf4j.QueryParameterTypes;
import net.cassite.daf4j.QueryParameterWithFocus;
import net.cassite.daf4j.Selectable;
import net.cassite.daf4j.UpdateEntry;
import net.cassite.daf4j.Where;
import net.cassite.daf4j.types.XBool;
import net.cassite.daf4j.types.XDate;
import net.cassite.daf4j.types.XDouble;
import net.cassite.daf4j.types.XInt;
import net.cassite.daf4j.types.XLong;
import net.cassite.daf4j.types.XString;
import net.cassite.daf4j.util.AliasMap;
import net.cassite.daf4j.util.ConstantMap;
import net.cassite.daf4j.util.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPQLDataAccess
implements DataAccess {
    private static final String aliasPrefix = "var";
    private Logger logger = LoggerFactory.getLogger(DataAccess.class);
    private final EntityManager entityManager;

    public JPQLDataAccess(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    private String generateExpression(Args args) {
        if (args.expression.expType() == ExpressionTypes.add) {
            return this.objToString(args.fillObj(args.expression.expArgs()[0])) + " + " + this.objToString(args.fillObj(args.expression.expArgs()[1]));
        }
        if (args.expression.expType() == ExpressionTypes.avg) {
            if (!args.notDistinctOrAlreadyDone && args.generatingSelect) {
                return "AVG(DISTINCT " + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
            }
            return "AVG(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.concat) {
            return "CONCAT(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ", " + this.objToString(args.fillObj(args.expression.expArgs()[1])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.count) {
            if (!args.notDistinctOrAlreadyDone && args.generatingSelect) {
                return "COUNT(DISTINCT " + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
            }
            return "COUNT(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.divide) {
            return this.objToString(args.fillObj(args.expression.expArgs()[0])) + " / " + this.objToString(args.fillObj(args.expression.expArgs()[1]));
        }
        if (args.expression.expType() == ExpressionTypes.exists) {
            PreResult query = (PreResult)args.expression.expArgs()[0];
            Args a = args.prepareForSubQuery(query);
            String toReturn = "EXISTS(" + this.generateSelect(a, false) + ")";
            args.aliasMap.setAliasCount(a.aliasMap.getAliasCount());
            return toReturn;
        }
        if (args.expression.expType() == ExpressionTypes.length) {
            return "LENGTH(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.locate) {
            return "LOCATE(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ", " + this.objToString(args.fillObj(args.expression.expArgs()[1])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.lower) {
            return "LOWER(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.max) {
            if (!args.notDistinctOrAlreadyDone && args.generatingSelect) {
                return "MAX(DISTINCT " + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
            }
            return "MAX(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.min) {
            if (!args.notDistinctOrAlreadyDone && args.generatingSelect) {
                return "MIN(DISTINCT " + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
            }
            return "MIN(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.minus) {
            return this.objToString(args.fillObj(args.expression.expArgs()[0])) + " - " + this.objToString(args.fillObj(args.expression.expArgs()[1]));
        }
        if (args.expression.expType() == ExpressionTypes.mod) {
            return "MOD(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ", " + this.objToString(args.fillObj(args.expression.expArgs()[1])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.multi) {
            return this.objToString(args.fillObj(args.expression.expArgs()[0])) + " * " + this.objToString(args.fillObj(args.expression.expArgs()[1]));
        }
        if (args.expression.expType() == ExpressionTypes.notExists) {
            PreResult query = (PreResult)args.expression.expArgs()[0];
            Args a = args.prepareForSubQuery(query);
            String toReturn = "NOT EXISTS(" + this.generateSelect(a, false) + ")";
            args.aliasMap.setAliasCount(a.aliasMap.getAliasCount());
            return toReturn;
        }
        if (args.expression.expType() == ExpressionTypes.substring) {
            return "SUBSTRING(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ", " + this.objToString(args.fillObj(args.expression.expArgs()[1])) + ", " + this.objToString(args.fillObj(args.expression.expArgs()[2])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.sum) {
            if (!args.notDistinctOrAlreadyDone && args.generatingSelect) {
                return "SUM(DISTINCT " + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
            }
            return "SUM(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.trim) {
            return "TRIM(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        if (args.expression.expType() == ExpressionTypes.unary_negative) {
            return "- " + this.objToString(args.fillObj(args.expression.expArgs()[0]));
        }
        if (args.expression.expType() == ExpressionTypes.upper) {
            return "UPPER(" + this.objToString(args.fillObj(args.expression.expArgs()[0])) + ")";
        }
        throw new UnsupportedOperationException(args.expression.expType() + " not supported");
    }

    private String objToString(Args args) {
        if (args.obj.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            boolean isFirst = true;
            for (Object o : (Object[])args.obj) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.objToString(args.fillObj(o)));
            }
            return sb.append(")").toString();
        }
        if (args.obj instanceof Iterable) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            boolean isFirst = true;
            for (Object o : (Iterable)args.obj) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.objToString(args.fillObj(o)));
            }
            return sb.append(")").toString();
        }
        if (args.obj.getClass().getName().startsWith("java.") || args.obj.getClass().getName().startsWith("javax.")) {
            return "?" + args.constantMap.add(args.obj);
        }
        if (args.obj instanceof IData) {
            return this.dataToString((IData)args.obj, args);
        }
        if (args.obj instanceof IExpression) {
            return this.generateExpression(args.fillExp((IExpression)args.obj));
        }
        if (args.entity == args.obj) {
            return args.aliasMap.get((Object)new Location(null));
        }
        try {
            Location l = this.findEntity(args.obj, args);
            return args.aliasMap.get((Object)l);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(args.obj.getClass() + " not supported");
        }
    }

    private Location findEntity(Object entity, Object toFind, List<String> list, Args args, Set<Object> alreadySearched, List<List<String>> locationsMightBeJoined) {
        LinkedHashMap<Object, String> objectStringMap = new LinkedHashMap<Object, String>();
        try {
            for (Field f : entity.getClass().getFields()) {
                IData data;
                Object obj;
                Class cls;
                if (!IData.class.isAssignableFrom(f.getType())) continue;
                try {
                    cls = (Class<Integer>)((Object)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0]);
                }
                catch (ClassCastException e) {
                    Class<?> type = f.getType();
                    if (XInt.class.isAssignableFrom(type)) {
                        cls = Integer.class;
                    }
                    if (XLong.class.isAssignableFrom(type)) {
                        cls = Long.class;
                    }
                    if (XDouble.class.isAssignableFrom(type)) {
                        cls = Double.class;
                    }
                    if (XDate.class.isAssignableFrom(type)) {
                        cls = Date.class;
                    }
                    if (XString.class.isAssignableFrom(type)) {
                        cls = String.class;
                    }
                    if (XBool.class.isAssignableFrom(type)) {
                        cls = Boolean.class;
                    }
                    throw e;
                }
                if (cls.getName().startsWith("java.") || cls.getName().startsWith("javax.") || (obj = (data = (IData)f.get(entity)).get()) == null) continue;
                if (obj instanceof Iterable) {
                    Iterator it = ((Iterable)obj).iterator();
                    if (!it.hasNext()) continue;
                    Object o = it.next();
                    ArrayList<String> tmp = new ArrayList<String>(list);
                    tmp.add(f.getName());
                    locationsMightBeJoined.add(new ArrayList<String>(tmp));
                    if (o == toFind) {
                        list.add(f.getName());
                        if (toFind != args.entity) {
                            for (List<String> locationList : locationsMightBeJoined) {
                                Location loc = DataUtils.generateLocationAndFillMap(locationList, (AliasMap)args.aliasMap);
                                if (args.toJoin.containsKey(loc)) continue;
                                args.toJoin.put(loc, args.aliasMap.get((Object)loc));
                            }
                        }
                        return DataUtils.generateLocationAndFillMap(list, (AliasMap)args.aliasMap);
                    }
                    if (alreadySearched.contains(o)) continue;
                    alreadySearched.add(o);
                    objectStringMap.put(o, f.getName());
                    continue;
                }
                ArrayList<String> tmp = new ArrayList<String>(list);
                tmp.add(f.getName());
                locationsMightBeJoined.add(new ArrayList<String>(tmp));
                if (obj == toFind) {
                    list.add(f.getName());
                    if (toFind != args.entity) {
                        for (List<String> locationList : locationsMightBeJoined) {
                            Location loc = DataUtils.generateLocationAndFillMap(locationList, (AliasMap)args.aliasMap);
                            if (args.toJoin.containsKey(loc)) continue;
                            args.toJoin.put(loc, args.aliasMap.get((Object)loc));
                        }
                    }
                    return DataUtils.generateLocationAndFillMap(list, (AliasMap)args.aliasMap);
                }
                if (alreadySearched.contains(obj)) continue;
                alreadySearched.add(obj);
                objectStringMap.put(obj, f.getName());
            }
            for (Object obj : objectStringMap.keySet()) {
                ArrayList<String> nextList = new ArrayList<String>(list);
                nextList.add((String)objectStringMap.get(obj));
                ArrayList<List<String>> nextLocationsMightBeJoined = new ArrayList<List<String>>(locationsMightBeJoined);
                Location location = this.findEntity(obj, toFind, nextList, args, alreadySearched, nextLocationsMightBeJoined);
                if (null == location) continue;
                return location;
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Location findEntity(Object toFind, Args args) {
        Location l = this.findEntity(args.entity, toFind, new ArrayList<String>(), args, new HashSet<Object>(), new ArrayList<List<String>>());
        if (l == null) {
            throw new IllegalArgumentException("Cannot find location of " + toFind);
        }
        return l;
    }

    private String dataToString(IData<?> data, Args args) {
        Object entity = data.getEntity();
        String alias = args.aliasMap.get((Object)new Location(new ArrayList()));
        if (entity != args.entity) {
            Location location = this.findEntity(entity, args);
            alias = args.aliasMap.get((Object)location);
        }
        return alias + "." + DataUtils.findFieldNameByIData(data);
    }

    private String generateCondition(Args args) {
        if (args.condition.type == ConditionTypes.between) {
            return this.objToString(args.fillObj(args.condition.data)) + " BETWEEN " + this.objToString(args.fillObj(args.condition.args.get(0))) + " AND " + this.objToString(args.fillObj(args.condition.args.get(1)));
        }
        if (args.condition.type == ConditionTypes.eq) {
            return this.objToString(args.fillObj(args.condition.data)) + " = " + this.objToString(args.fillObj(args.condition.args.get(0)));
        }
        if (args.condition.type == ConditionTypes.ge) {
            return this.objToString(args.fillObj(args.condition.data)) + " >= " + this.objToString(args.fillObj(args.condition.args.get(0)));
        }
        if (args.condition.type == ConditionTypes.gt) {
            return this.objToString(args.fillObj(args.condition.data)) + " > " + this.objToString(args.fillObj(args.condition.args.get(0)));
        }
        if (args.condition.type == ConditionTypes.in) {
            Args a = args.prepareForSubQuery((PreResult)args.condition.args.get(0));
            String subQuery = this.generateSelect(a, false);
            args.aliasMap.setAliasCount(a.aliasMap.getAliasCount());
            return this.objToString(args.fillObj(args.condition.data)) + " IN (" + subQuery + ")";
        }
        if (args.condition.type == ConditionTypes.isNotNull) {
            return this.objToString(args.fillObj(args.condition.data)) + " IS NOT NULL";
        }
        if (args.condition.type == ConditionTypes.isNull) {
            return this.objToString(args.fillObj(args.condition.data)) + " IS NULL";
        }
        if (args.condition.type == ConditionTypes.le) {
            return this.objToString(args.fillObj(args.condition.data)) + " <= " + this.objToString(args.fillObj(args.condition.args.get(0)));
        }
        if (args.condition.type == ConditionTypes.like) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.objToString(args.fillObj(args.condition.data)));
            sb.append(" LIKE ");
            boolean isFirst = true;
            for (Object o : args.condition.args) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" + ");
                }
                sb.append(this.objToString(args.fillObj(o)));
            }
            return sb.toString();
        }
        if (args.condition.type == ConditionTypes.lt) {
            return this.objToString(args.fillObj(args.condition.data)) + " < " + this.objToString(args.fillObj(args.condition.args.get(0)));
        }
        if (args.condition.type == ConditionTypes.member) {
            return this.objToString(args.fillObj(args.condition.data)) + " MEMBER " + this.objToString(args.fillObj(args.condition.args.get(0)));
        }
        if (args.condition.type == ConditionTypes.ne) {
            return this.objToString(args.fillObj(args.condition.data)) + " <> " + this.objToString(args.fillObj(args.condition.args.get(0)));
        }
        if (args.condition.type == ConditionTypes.notIn) {
            Args a = args.prepareForSubQuery((PreResult)args.condition.args.get(0));
            String subQuery = this.generateSelect(a, false);
            args.aliasMap.setAliasCount(a.aliasMap.getAliasCount());
            return this.objToString(args.fillObj(args.condition.data)) + " NOT IN (" + subQuery + ")";
        }
        if (args.condition.type == ConditionTypes.notMember) {
            return this.objToString(args.fillObj(args.condition.data)) + " NOT MEMBER " + this.objToString(args.fillObj(args.condition.args.get(0)));
        }
        if (args.condition.type == ConditionTypes.reverseMember) {
            return this.objToString(args.fillObj(args.condition.args.get(0))) + " MEMBER " + this.objToString(args.fillObj(args.condition.data));
        }
        if (args.condition.type == ConditionTypes.reverseNotMember) {
            return this.objToString(args.fillObj(args.condition.args.get(0))) + " NOT MEMBER " + this.objToString(args.fillObj(args.condition.data));
        }
        throw new UnsupportedOperationException(args.condition.type + " not supported");
    }

    private String generateWhere(Args args, boolean having) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        if (args.whereClause.isAnd()) {
            if (having) {
                Where Optionalhaving = DataUtils.getAggregate((Where)args.whereClause);
                if (Optionalhaving != null) {
                    args.aggregateFunctions = this.generateWhere(args.fillWhere(Optionalhaving), false);
                }
                if (Optionalhaving == null) {
                    having = false;
                }
            }
            for (Or or : ((And)args.whereClause).getOrList()) {
                if (having && DataUtils.getAggregate((Where)or) != null) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append("(").append(this.generateWhere(args.fillWhere((Where)or), false)).append(")");
            }
            for (Condition condition : ((And)args.whereClause).getConditionList()) {
                if (having && DataUtils.getAggregate((Where)condition) != null) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(this.generateWhere(args.fillWhere((Where)condition), false));
            }
            for (ExpressionBoolean expBool : ((And)args.whereClause).getExpBoolList()) {
                if (having && DataUtils.getAggregate((Where)expBool) != null) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(this.generateWhere(args.fillWhere((Where)expBool), false));
            }
        } else if (args.whereClause.isOr()) {
            for (And and : ((Or)args.whereClause).getAndList()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" OR ");
                }
                sb.append(this.generateWhere(args.fillWhere((Where)and), false));
            }
            for (Condition condition : ((Or)args.whereClause).getConditionList()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" OR ");
                }
                sb.append(this.generateWhere(args.fillWhere((Where)condition), false));
            }
            for (ExpressionBoolean expBool : ((Or)args.whereClause).getExpBoolList()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" OR ");
                }
                sb.append(this.generateWhere(args.fillWhere((Where)expBool), false));
            }
        } else if (args.whereClause.isCondition()) {
            sb.append(this.generateCondition(args.fillCondition((Condition)args.whereClause)));
        } else if (args.whereClause.isExpression()) {
            sb.append(this.generateExpression(args.fillExp((IExpression)args.whereClause)));
        }
        return sb.toString();
    }

    private String generateJoin(Args args) {
        StringBuilder sb = new StringBuilder();
        for (Location joinLocation : args.toJoin.keySet()) {
            sb.append(" JOIN ");
            if (joinLocation.getLocation().size() == 1) {
                sb.append(args.aliasMap.get((Object)new Location(null))).append(".");
            }
            sb.append(joinLocation.toString()).append(" ").append(args.toJoin.get(joinLocation));
        }
        return sb.toString();
    }

    private void generateJoinWhere(Args args) {
        if (args.whereClause != null) {
            if (args.whereClause instanceof IExpression && DataUtils.expressionIsAggregate((IExpression)((IExpression)args.whereClause))) {
                args.aggregateFunctions = this.generateWhere(args, false);
                args.sb.append(this.generateJoin(args));
            } else if (args.whereClause instanceof Condition && null != DataUtils.getAggregate((Where)args.whereClause)) {
                args.aggregateFunctions = this.generateWhere(args, false);
                args.sb.append(this.generateJoin(args));
            } else {
                String where = " WHERE " + this.generateWhere(args, true);
                args.sb.append(this.generateJoin(args)).append(where);
            }
        } else if (args.toJoin.size() != 0) {
            args.sb.append(this.generateJoin(args));
        }
    }

    private void generateGroupByHaving(Args args) {
        if (args.aggregateFunctions != null || args.doGroupBy && args.selectNonAggregationAliases.size() != 0) {
            args.sb.append(" GROUP BY ");
            boolean isFirst = true;
            for (String s : args.selectNonAggregationAliases) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    args.sb.append(", ");
                }
                args.sb.append(s);
            }
        }
        if (args.aggregateFunctions != null) {
            args.sb.append(" HAVING ").append(args.aggregateFunctions);
        }
    }

    private String generateSelect(Args args, boolean isProjection) {
        if (args.queryParameter != null && args.queryParameter.parameters.containsKey(QueryParameterTypes.distinct)) {
            args.notDistinctOrAlreadyDone = false;
        }
        args.generatingSelect = true;
        String entityAlias = args.aliasMap.get((Object)new Location(new ArrayList(0)));
        args.sb.append("SELECT ");
        if (isProjection) {
            if (args.queryParameter == null || !(args.queryParameter instanceof QueryParameterWithFocus) || ((QueryParameterWithFocus)args.queryParameter).focusMap.size() == 0) {
                args.queryParameter = new QueryParameterWithFocus(args.queryParameter, null);
                QueryParameterWithFocus qpwf = (QueryParameterWithFocus)args.queryParameter;
                try {
                    for (Field f : args.entityClass.getFields()) {
                        if (!IData.class.isAssignableFrom(f.getType()) || ParameterAggregate.class.isAssignableFrom(f.getType())) continue;
                        qpwf.focus((IData)f.get(args.entity));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            boolean isFirst = true;
            for (Selectable o : ((QueryParameterWithFocus)args.queryParameter).focusMap.keySet()) {
                Object[] objs;
                if (isFirst) {
                    isFirst = false;
                } else {
                    args.sb.append(", ");
                }
                if (o instanceof IData) {
                    IData d = (IData)o;
                    if (d.getEntity() == args.entity) {
                        String alias = entityAlias + "." + DataUtils.findFieldNameByIData((IData)d);
                        if (!args.notDistinctOrAlreadyDone) {
                            args.sb.append("DISTINCT ");
                            args.notDistinctOrAlreadyDone = true;
                        }
                        args.sb.append(alias);
                        args.selectNonAggregationAliases.add(alias);
                        continue;
                    }
                    Location loc = this.findEntity(d.getEntity(), args);
                    String alias = args.aliasMap.get((Object)loc) + "." + DataUtils.findFieldNameByIData((IData)d);
                    if (!args.notDistinctOrAlreadyDone) {
                        args.sb.append("DISTINCT ");
                        args.notDistinctOrAlreadyDone = true;
                    }
                    args.sb.append(alias);
                    args.selectNonAggregationAliases.add(alias);
                    args.toJoin.put(loc, args.aliasMap.get((Object)loc));
                    continue;
                }
                if (!(o instanceof IExpression)) continue;
                args.sb.append(this.generateExpression(args.fillExp((IExpression)o)));
                if (DataUtils.expressionIsAggregate((IExpression)((IExpression)o))) {
                    args.doGroupBy = true;
                    continue;
                }
                IExpression exp = (IExpression)o;
                for (Object obj : objs = exp.expArgs()) {
                    if (!(obj instanceof IData)) continue;
                    Location location = this.findEntity(((IData)obj).getEntity(), args);
                    List locList = location.getLocation();
                    locList.add(DataUtils.findFieldNameByIData((IData)((IData)obj)));
                    Location loc = DataUtils.generateLocationAndFillMap((List)locList, (AliasMap)args.aliasMap);
                    args.selectNonAggregationAliases.add(args.aliasMap.get((Object)loc));
                }
            }
        } else {
            if (!args.notDistinctOrAlreadyDone) {
                args.sb.append("DISTINCT ");
                args.notDistinctOrAlreadyDone = true;
            }
            args.sb.append(entityAlias);
            args.selectNonAggregationAliases.add(entityAlias);
        }
        args.generatingSelect = false;
        args.sb.append(" FROM ").append(args.entityClass.getSimpleName()).append(" ").append(entityAlias);
        this.generateJoinWhere(args);
        this.generateGroupByHaving(args);
        if (args.queryParameter != null) {
            for (QueryParameterTypes type : args.queryParameter.parameters.keySet()) {
                Object[] argsArr = (Object[])args.queryParameter.parameters.get(type);
                if (type == QueryParameterTypes.orderBy) {
                    args.sb.append(" ORDER BY ");
                    for (Object o : argsArr) {
                        OrderBase order = (OrderBase)o;
                        Location loc = this.findEntity(order.data.getEntity(), args);
                        Field f = DataUtils.findFieldByContainedEntity((Object)order.data.getEntity(), (Object)args.entity);
                        args.sb.append(args.aliasMap.get((Object)loc)).append(".").append(f.getName());
                    }
                    continue;
                }
                if (type == QueryParameterTypes.limit || type == QueryParameterTypes.top || type == QueryParameterTypes.distinct) continue;
                throw new UnsupportedOperationException(type + " not supported");
            }
        }
        return args.sb.toString();
    }

    private void setParametersToQuery(Query query, QueryParameter parameter, ConstantMap constantMap) {
        if (parameter != null) {
            for (QueryParameterTypes type : parameter.parameters.keySet()) {
                Object[] args = (Object[])parameter.parameters.get(type);
                if (type == QueryParameterTypes.limit) {
                    query.setFirstResult(((Integer)args[0]).intValue()).setMaxResults((Integer)args[1] - (Integer)args[0] + 1);
                    continue;
                }
                if (type == QueryParameterTypes.top) {
                    query.setMaxResults(((Integer)args[0]).intValue());
                    continue;
                }
                if (type == QueryParameterTypes.orderBy || type == QueryParameterTypes.distinct) continue;
                throw new UnsupportedOperationException(type + " not supported");
            }
        }
        this.setConstants(query, (Map<Integer, Object>)constantMap);
    }

    private void setConstants(Query query, Map<Integer, Object> constantMap) {
        for (Integer i : constantMap.keySet()) {
            query.setParameter(i.intValue(), constantMap.get(i));
        }
    }

    private void initArgs(Args args, Object entity, Where whereClause, QueryParameter parameter) {
        args.sb = new StringBuilder();
        args.entity = entity;
        args.entityClass = entity.getClass();
        args.whereClause = whereClause;
        args.queryParameter = parameter;
        args.aliasMap = new AliasMap(aliasPrefix);
        args.constantMap = new ConstantMap();
        args.toJoin = new LinkedHashMap<Location, String>();
        args.selectNonAggregationAliases = new ArrayList<String>();
    }

    public <En> En find(Class<En> entityClass, Object pkValue) {
        return (En)this.entityManager.find(entityClass, pkValue);
    }

    public <En> List<En> list(En entity, Where whereClause, QueryParameter parameter) {
        Args args = new Args();
        this.initArgs(args, entity, whereClause, parameter);
        String selectQuery = this.generateSelect(args, false);
        this.logger.debug("Generated JPQL Query is : {} ---- WITH PARAMETERS : {}", (Object)selectQuery, (Object)args.constantMap);
        Query query = this.entityManager.createQuery(selectQuery);
        this.setParametersToQuery(query, parameter, args.constantMap);
        return query.getResultList();
    }

    private QueryParameterWithFocus validateQueryParameterWithFocus(Object entity, QueryParameterWithFocus parameter) {
        if (parameter == null) {
            try {
                Focus focus = new Focus();
                for (Field f : entity.getClass().getFields()) {
                    if (!IData.class.isAssignableFrom(f.getType()) || ParameterAggregate.class.isAssignableFrom(f.getType())) continue;
                    focus.focus((IData)f.get(entity));
                }
                parameter = new QueryParameterWithFocus(null, focus);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return parameter;
    }

    private String mapInit(Args args, Object entity, Where whereClause, QueryParameterWithFocus parameter) {
        this.initArgs(args, entity, whereClause, (QueryParameter)parameter);
        return this.generateSelect(args, true);
    }

    private List<Map<String, Object>> listToMap(List<Object> resultList, QueryParameterWithFocus parameter) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(resultList.size());
        for (Object res : resultList) {
            LinkedHashMap map = new LinkedHashMap();
            if (res.getClass().isArray()) {
                int i = 0;
                for (String alias : parameter.focusMap.values()) {
                    map.put(alias, ((Object[])res)[i]);
                    ++i;
                }
            } else {
                map.put(parameter.focusMap.values().iterator().next(), res);
            }
            list.add(map);
        }
        return list;
    }

    public List<Map<String, Object>> projection(Object entity, Where whereClause, QueryParameterWithFocus parameter) {
        Args args = new Args();
        parameter = this.validateQueryParameterWithFocus(entity, parameter);
        String selectQuery = this.mapInit(args, entity, whereClause, parameter);
        this.logger.debug("Generated JPQL Query is : {} ---- WITH PARAMETERS : {}", (Object)selectQuery, (Object)args.constantMap);
        Query query = this.entityManager.createQuery(selectQuery);
        this.setParametersToQuery(query, (QueryParameter)parameter, args.constantMap);
        return this.listToMap(query.getResultList(), (QueryParameterWithFocus)args.queryParameter);
    }

    private void updateInit(Args args, Object entity, Where whereClause, UpdateEntry[] entries) {
        this.initArgs(args, entity, whereClause, null);
        args.sb.append("UPDATE ").append(entity.getClass().getSimpleName()).append(" ").append(args.aliasMap.get((Object)new Location(null))).append(" SET ");
        boolean isFirst = true;
        for (UpdateEntry entry : entries) {
            if (isFirst) {
                isFirst = false;
            } else {
                args.sb.append(", ");
            }
            args.sb.append(DataUtils.findFieldNameByIData((IData)entry.data)).append(" = ").append(this.objToString(args.fillObj(entry.updateValue)));
        }
        if (args.whereClause != null) {
            args.sb.append(" WHERE ").append(this.generateWhere(args, false));
        }
    }

    public void update(Object entity, Where whereClause, UpdateEntry[] entries) {
        Args args = new Args();
        this.updateInit(args, entity, whereClause, entries);
        this.logger.debug("Generated JPQL Query is : {} ---- WITH PARAMETERS {}", (Object)args.sb.toString(), (Object)args.constantMap);
        Query query = this.entityManager.createQuery(args.sb.toString());
        this.setConstants(query, (Map<Integer, Object>)args.constantMap);
        query.executeUpdate();
    }

    private void removeInit(Args args, Object entity, Where whereClause) {
        this.initArgs(args, entity, whereClause, null);
        args.sb.append("DELETE FROM ").append(entity.getClass().getSimpleName()).append(" ").append(args.aliasMap.get((Object)new Location(null)));
        if (args.whereClause != null) {
            args.sb.append(" WHERE ").append(this.generateWhere(args, false));
        }
    }

    public void remove(Object entity, Where whereClause) {
        Args args = new Args();
        this.removeInit(args, entity, whereClause);
        this.logger.debug("Generated JPQL Query is : {} ---- WITH PARAMETERS {}", (Object)args.sb.toString(), (Object)args.constantMap);
        Query query = this.entityManager.createQuery(args.sb.toString());
        this.setConstants(query, (Map<Integer, Object>)args.constantMap);
        query.executeUpdate();
    }

    public void save(Object[] entities) {
        for (Object e : entities) {
            this.entityManager.persist(e);
        }
    }

    private static class Args {
        public StringBuilder sb;
        public Where whereClause;
        public QueryParameter queryParameter;
        public Object entity;
        public Class<?> entityClass;
        public AliasMap aliasMap;
        public ConstantMap constantMap;
        public Map<Location, String> toJoin;
        public IExpression expression;
        public Object obj;
        public Condition condition;
        public String aggregateFunctions;
        public List<String> selectNonAggregationAliases;
        public boolean doGroupBy = false;
        public boolean notDistinctOrAlreadyDone = true;
        public boolean generatingSelect = false;

        private Args() {
        }

        public Args doClone() {
            Args args = new Args();
            args.sb = this.sb;
            args.whereClause = this.whereClause;
            args.queryParameter = this.queryParameter;
            args.entity = this.entity;
            args.entityClass = this.entityClass;
            args.aliasMap = this.aliasMap;
            args.constantMap = this.constantMap;
            args.toJoin = this.toJoin;
            args.aggregateFunctions = this.aggregateFunctions;
            args.selectNonAggregationAliases = this.selectNonAggregationAliases;
            args.doGroupBy = this.doGroupBy;
            args.notDistinctOrAlreadyDone = this.notDistinctOrAlreadyDone;
            args.generatingSelect = this.generatingSelect;
            return args;
        }

        public Args fillObj(Object obj) {
            Args a = this.doClone();
            a.obj = obj;
            return a;
        }

        public Args fillExp(IExpression exp) {
            Args a = this.doClone();
            a.expression = exp;
            return a;
        }

        public Args fillWhere(Where where) {
            Args a = this.doClone();
            a.whereClause = where;
            return a;
        }

        public Args fillCondition(Condition condition) {
            Args a = this.doClone();
            a.condition = condition;
            return a;
        }

        public Args prepareForSubQuery(PreResult<?> query) {
            Args a = this.doClone();
            a.aliasMap = new AliasMap(JPQLDataAccess.aliasPrefix, this.aliasMap.getAliasCount());
            a.toJoin = new LinkedHashMap<Location, String>();
            a.sb = new StringBuilder();
            a.entity = query.entity;
            a.entityClass = query.entity.getClass();
            a.whereClause = query.whereClause;
            a.queryParameter = null;
            a.aggregateFunctions = null;
            a.selectNonAggregationAliases = new ArrayList<String>();
            a.doGroupBy = false;
            a.notDistinctOrAlreadyDone = true;
            a.generatingSelect = false;
            return a;
        }
    }
}

