/*
 * Decompiled with CFR 0.152.
 */
package net.cassite.daf4j.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.cassite.daf4j.DataUtils;
import net.cassite.daf4j.IData;
import net.cassite.daf4j.PreResult;
import net.cassite.daf4j.QueryParameter;
import net.cassite.daf4j.QueryParameterTypes;
import net.cassite.daf4j.Where;
import net.cassite.daf4j.ds.DSUtils;
import net.cassite.daf4j.ds.EntityDataParser;
import net.cassite.daf4j.ds.ParserPacket;
import net.cassite.daf4j.jpa.JPQLContext;
import net.cassite.daf4j.types.XBool;
import net.cassite.daf4j.types.XDate;
import net.cassite.daf4j.types.XDouble;
import net.cassite.daf4j.types.XInt;
import net.cassite.daf4j.types.XLong;
import net.cassite.daf4j.types.XString;
import net.cassite.daf4j.util.AliasMap;
import net.cassite.daf4j.util.Location;

public class JPQLEntityDataParser
implements EntityDataParser<JPQLContext, String> {
    public String parseData(JPQLContext jpqlContext, IData<?> iData) {
        return this.parseEntity(jpqlContext, iData.getEntity()) + "." + DataUtils.findFieldNameByIData(iData);
    }

    public String parseEntity(JPQLContext jpqlContext, Object o) {
        Location loc = JPQLEntityDataParser.findEntity(o, jpqlContext);
        return jpqlContext.aliasMap.get((Object)loc);
    }

    public String parsePlain(JPQLContext jpqlContext, Object o) {
        return "?" + jpqlContext.constantMap.add(o);
    }

    public <DS> String parseQuery(JPQLContext jpqlContext, PreResult<?> preResult, ParserPacket<JPQLContext, String, DS> parserPacket) throws Exception {
        JPQLContext cont = jpqlContext.copyForSubQuery(preResult.entity, preResult.parameter == null || !preResult.parameter.parameters.containsKey(QueryParameterTypes.distinct));
        String res = ((JPQLContext)DSUtils.listGenerationProcess((Object)cont, (Where)preResult.whereClause, (QueryParameter)preResult.parameter, parserPacket)).generalJPQL.toString();
        jpqlContext.aliasMap.setAliasCount(cont.aliasMap.getAliasCount());
        return res;
    }

    private static Location findEntity(Object entity, Object toFind, List<String> list, JPQLContext args, Set<Object> alreadySearched, List<List<String>> locationsMightBeJoined) {
        LinkedHashMap<Object, String> objectStringMap = new LinkedHashMap<Object, String>();
        try {
            for (Field f : entity.getClass().getFields()) {
                IData data;
                Object obj;
                Class cls;
                if (!IData.class.isAssignableFrom(f.getType())) continue;
                try {
                    cls = (Class<Integer>)((Object)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0]);
                }
                catch (ClassCastException e) {
                    Class<?> type = f.getType();
                    if (XInt.class.isAssignableFrom(type)) {
                        cls = Integer.class;
                    }
                    if (XLong.class.isAssignableFrom(type)) {
                        cls = Long.class;
                    }
                    if (XDouble.class.isAssignableFrom(type)) {
                        cls = Double.class;
                    }
                    if (XDate.class.isAssignableFrom(type)) {
                        cls = Date.class;
                    }
                    if (XString.class.isAssignableFrom(type)) {
                        cls = String.class;
                    }
                    if (XBool.class.isAssignableFrom(type)) {
                        cls = Boolean.class;
                    }
                    throw e;
                }
                if (cls.getName().startsWith("java.") || cls.getName().startsWith("javax.") || (obj = (data = (IData)f.get(entity)).get()) == null) continue;
                if (obj instanceof Iterable) {
                    Iterator it = ((Iterable)obj).iterator();
                    if (!it.hasNext()) continue;
                    Object o = it.next();
                    ArrayList<String> tmp = new ArrayList<String>(list);
                    tmp.add(f.getName());
                    locationsMightBeJoined.add(new ArrayList<String>(tmp));
                    if (o == toFind) {
                        list.add(f.getName());
                        if (toFind != args.entity) {
                            for (List<String> locationList : locationsMightBeJoined) {
                                Location loc = DataUtils.generateLocationAndFillMap(locationList, (AliasMap)args.aliasMap);
                                if (args.toJoin.containsKey(loc)) continue;
                                args.toJoin.put(loc, args.aliasMap.get((Object)loc));
                            }
                        }
                        return DataUtils.generateLocationAndFillMap(list, (AliasMap)args.aliasMap);
                    }
                    if (alreadySearched.contains(o)) continue;
                    alreadySearched.add(o);
                    objectStringMap.put(o, f.getName());
                    continue;
                }
                ArrayList<String> tmp = new ArrayList<String>(list);
                tmp.add(f.getName());
                locationsMightBeJoined.add(new ArrayList<String>(tmp));
                if (obj == toFind) {
                    list.add(f.getName());
                    if (toFind != args.entity) {
                        for (List<String> locationList : locationsMightBeJoined) {
                            Location loc = DataUtils.generateLocationAndFillMap(locationList, (AliasMap)args.aliasMap);
                            if (args.toJoin.containsKey(loc)) continue;
                            args.toJoin.put(loc, args.aliasMap.get((Object)loc));
                        }
                    }
                    return DataUtils.generateLocationAndFillMap(list, (AliasMap)args.aliasMap);
                }
                if (alreadySearched.contains(obj)) continue;
                alreadySearched.add(obj);
                objectStringMap.put(obj, f.getName());
            }
            for (Object obj : objectStringMap.keySet()) {
                ArrayList<String> nextList = new ArrayList<String>(list);
                nextList.add((String)objectStringMap.get(obj));
                ArrayList<List<String>> nextLocationsMightBeJoined = new ArrayList<List<String>>(locationsMightBeJoined);
                Location location = JPQLEntityDataParser.findEntity(obj, toFind, nextList, args, alreadySearched, nextLocationsMightBeJoined);
                if (null == location) continue;
                return location;
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static Location findEntity(Object toFind, JPQLContext args) {
        if (toFind == args.entity) {
            return new Location(null);
        }
        Location l = JPQLEntityDataParser.findEntity(args.entity, toFind, new ArrayList<String>(), args, new HashSet<Object>(), new ArrayList<List<String>>());
        if (l == null) {
            throw new IllegalArgumentException("Cannot find location of " + toFind);
        }
        return l;
    }
}

