/*
 * Decompiled with CFR 0.152.
 */
package net.christophermerrill.ShadowboxFx;

import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import net.christophermerrill.ShadowboxFx.CenteredPane;

public class ShadowboxPane
extends StackPane {
    Node _glass = null;

    public void showOverlayOnShadowbox(Node overlay) {
        CenteredPane glass = new CenteredPane();
        glass.getChildren().add((Object)overlay);
        glass.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5)");
        StackPane.setAlignment((Node)glass, (Pos)Pos.CENTER);
        this.getChildren().add((Object)glass);
        this._glass = glass;
        overlay.requestFocus();
    }

    public void removeOverlay() {
        if (this._glass != null) {
            Platform.runLater(() -> {
                this.getChildren().remove((Object)this._glass);
                this._glass = null;
            });
        }
    }

    public boolean isShowingOverlay() {
        return this._glass != null;
    }

    public static ShadowboxPane findFromNode(Node node) {
        while (!(node instanceof ShadowboxPane)) {
            if ((node = node.getParent()) != null) continue;
            throw new IllegalArgumentException("Unable to locate a ShadowboxDialogPane in the ancestry of the provided node");
        }
        return (ShadowboxPane)node;
    }
}

