/*
 * Decompiled with CFR 0.152.
 */
package net.christophermerrill.ShadowboxFx;

import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import net.christophermerrill.ShadowboxFx.ShadowboxPane;

public class ShadowboxedAlert {
    private final DialogPane _dialog;
    private ShadowboxPane _shadowbox;
    private ButtonType _button_pushed = null;
    private OnButtonPush _action;
    private static final PseudoClass HEADER_CLASS = PseudoClass.getPseudoClass((String)"header");
    private static final PseudoClass NOHEADER_CLASS = PseudoClass.getPseudoClass((String)"no-header");

    public ShadowboxedAlert(Alert.AlertType type, String header, String message, ButtonType ... buttons) {
        if (type.equals((Object)Alert.AlertType.NONE)) {
            throw new IllegalArgumentException("Unsupported AlertType: " + type);
        }
        this._dialog = new DialogPane();
        this._dialog.setHeaderText(header);
        this._dialog.setContentText(message);
        this._dialog.getStyleClass().add((Object)"alert");
        this._dialog.getStyleClass().add((Object)type.name().toLowerCase());
        if (buttons == null || buttons.length < 1) {
            buttons = type.equals((Object)Alert.AlertType.CONFIRMATION) ? new ButtonType[]{ButtonType.OK, ButtonType.CANCEL} : new ButtonType[]{ButtonType.OK};
        }
        for (ButtonType button_type : buttons) {
            this._dialog.getButtonTypes().add((Object)button_type);
        }
        this._dialog.pseudoClassStateChanged(HEADER_CLASS, true);
        this._dialog.pseudoClassStateChanged(NOHEADER_CLASS, false);
    }

    public void showInShadowbox(Node node) {
        this._shadowbox = ShadowboxPane.findFromNode(node);
        this._shadowbox.showOverlayOnShadowbox((Node)this._dialog);
        this.setupButtonListeners();
    }

    private void setupButtonListeners() {
        for (ButtonType type : this._dialog.getButtonTypes()) {
            Button button = (Button)this._dialog.lookupButton(type);
            button.setOnAction(event -> {
                this._button_pushed = type;
                boolean close = true;
                if (this._action != null) {
                    close = this._action.pushed(type);
                }
                if (close) {
                    this._shadowbox.removeOverlay();
                }
            });
        }
    }

    public ButtonType getResult() {
        return this._button_pushed;
    }

    public void onButtonPush(OnButtonPush action) {
        this._action = action;
    }

    public static interface OnButtonPush {
        public boolean pushed(ButtonType var1);
    }
}

