/*
 * Decompiled with CFR 0.152.
 */
package net.chronakis.struts.tiles;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import net.chronakis.struts.tiles.DynamicTilesUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.TilesException;
import org.apache.struts.tiles.xmlDefinition.DefinitionsFactory;
import org.apache.struts.tiles.xmlDefinition.I18nFactorySet;
import org.apache.struts.tiles.xmlDefinition.XmlDefinition;
import org.apache.struts.tiles.xmlDefinition.XmlDefinitionsSet;
import org.apache.struts.tiles.xmlDefinition.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTilesFactoryActual
extends I18nFactorySet {
    private static final Logger log = LoggerFactory.getLogger(DynamicTilesFactoryActual.class);
    private static final String ORIG_DEFS_FACTORY_KEY = "tiles.original.definitions.factory";
    private static String[] DEFPROPS = new String[]{"name", "path", "extends", "role"};
    private static final String XMLHEADER = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<!DOCTYPE tiles-definitions PUBLIC\n\"-//Apache Software Foundation//DTD Tiles Configuration 1.3//EN\"\n\"http://struts.apache.org/dtds/tiles-config_1_3.dtd\">\n";
    XmlDefinitionsSet xmlConfig;
    DefinitionsFactory origFactory;
    private DefinitionsFactoryConfig config = null;

    public void setConfig(DefinitionsFactoryConfig config) {
        this.config = config;
    }

    public void initFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        super.initFactory(servletContext, properties);
        if (this.config == null) {
            throw new DefinitionsFactoryException("initFactory() called before calling the setConfig(). This disables the compatibility workaround. Please call the setConfig() before initFactory()");
        }
        this.origFactory = new DefinitionsFactory(this.xmlConfig);
        DynamicTilesFactoryActual.setOriginalDefinitionsFactory(this.origFactory, this.config.getFactoryName(), servletContext);
        String filename = (String)properties.get("definitions-config");
        Map<String, String> vars = null;
        try {
            vars = DynamicTilesFactoryActual.readDefaultVariables(servletContext.getRealPath(filename));
            DynamicTilesUtils.setVariables(vars, this.config.getFactoryName(), servletContext);
        }
        catch (IOException e) {
            log.warn("Cound not process default variable values: " + e);
        }
    }

    protected XmlDefinitionsSet parseXmlFile(ServletContext servletContext, String filename, XmlDefinitionsSet xmlDefinitions) throws DefinitionsFactoryException {
        XmlDefinitionsSet rootXmlConfig = super.parseXmlFile(servletContext, filename, xmlDefinitions);
        if (rootXmlConfig == null) {
            return null;
        }
        try {
            DynamicTilesFactoryActual.process(rootXmlConfig);
        }
        catch (TilesException e) {
            throw new DefinitionsFactoryException((Exception)((Object)e));
        }
        if (log.isDebugEnabled()) {
            DynamicTilesFactoryActual.dump(rootXmlConfig, servletContext.getRealPath(filename));
        }
        this.xmlConfig = rootXmlConfig;
        return rootXmlConfig;
    }

    protected static void process(XmlDefinitionsSet definitions) throws DefinitionsFactoryException {
        Map defsMap = definitions.getDefinitions();
        HashMap<String, XmlDefinition> impliedMap = new HashMap<String, XmlDefinition>();
        for (XmlDefinition def : defsMap.values()) {
            HashMap<String, String> impliedAttrs = new HashMap<String, String>();
            LinkedList<String> customAttrs = new LinkedList<String>();
            Map attrs = def.getAttributes();
            for (Object k : attrs.keySet()) {
                String attrName = k.toString();
                if (!attrName.matches(".+?/.+")) continue;
                String[] parts = attrName.split("/");
                if (parts.length < 2) {
                    throw new DefinitionsFactoryException("Malformed nested reference " + attrName + " in definition " + def.getName());
                }
                String impSuperName = parts[0];
                String impSuperAttr = parts[1];
                String impName = def.getName() + "/" + impSuperName;
                customAttrs.add(attrName);
                XmlDefinition impDef = new XmlDefinition();
                impDef.setName(impName);
                impDef.setExtends(impSuperName);
                impDef.putAttribute(impSuperAttr, attrs.get(attrName));
                impliedMap.put(impName, impDef);
                String impliedAttrName = null;
                XmlDefinition superDef = def;
                while (superDef != null && impliedAttrName == null) {
                    Map superAttrs = superDef.getAttributes();
                    for (Object superAttrKey : superAttrs.keySet()) {
                        String superAttrVal = (String)superAttrs.get(superAttrKey);
                        if (superAttrVal == null || !superAttrVal.equals(impSuperName)) continue;
                        impliedAttrName = (String)superAttrKey;
                        break;
                    }
                    superDef = superDef.getExtends() == null ? null : definitions.getDefinition(superDef.getExtends());
                }
                if (impliedAttrName == null) {
                    throw new DefinitionsFactoryException("Failed to find attribute " + impSuperName + " in " + def.getName() + " and all it's parents");
                }
                impliedAttrs.put(impliedAttrName, def.getName() + "/" + impSuperName);
            }
            for (Object k : impliedAttrs.keySet()) {
                attrs.put(k, impliedAttrs.get(k));
            }
            for (String string : customAttrs) {
                attrs.remove(string);
            }
        }
        for (XmlDefinition impDef : impliedMap.values()) {
            definitions.putDefinition(impDef);
        }
    }

    protected static Map<String, String> readDefaultVariables(String filename) throws IOException {
        String propsFilename = DynamicTilesFactoryActual.replaceIgnoreCase("\\.xml$", ".default.properties", filename);
        File propsFile = new File(propsFilename);
        if (!propsFile.exists()) {
            throw new IOException("Tiles default variable file does not exist, starting with uninitialised values. File should be: " + propsFilename);
        }
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(propsFile);
        props.load(fis);
        HashMap<String, String> vars = new HashMap<String, String>();
        for (Object propKey : props.keySet()) {
            vars.put((String)propKey, props.getProperty((String)propKey));
        }
        log.info("Found and parsed default variable file at " + propsFilename);
        if (log.isTraceEnabled()) {
            props.list(System.out);
        }
        return vars;
    }

    public static String replaceIgnoreCase(String regex, String replacement, String subject) {
        Pattern p = Pattern.compile(regex, 2);
        Matcher m = p.matcher(subject);
        return m.replaceAll(replacement);
    }

    protected static void dump(XmlDefinitionsSet definitions, String origDefsFile) {
        String interFile = DynamicTilesFactoryActual.replaceIgnoreCase("\\.xml$", ".effective.xml", origDefsFile);
        try {
            FileOutputStream out = new FileOutputStream(interFile);
            DynamicTilesFactoryActual.dump(out, definitions);
            log.debug("Effective tiles file has been dumped to: " + interFile);
        }
        catch (IOException e) {
            log.warn("Could not write the intermediate configuration file at " + interFile + ". Reason: " + e);
        }
        if (log.isTraceEnabled()) {
            try {
                DynamicTilesFactoryActual.dump(System.out, definitions);
            }
            catch (IOException e) {
                log.warn("Could not print the intermediate configurations to stdout " + interFile + ". Reason: " + e);
            }
        }
    }

    protected static void dump(OutputStream out, XmlDefinitionsSet definitions) throws IOException {
        PrintWriter pw = new PrintWriter(out);
        pw.println(XMLHEADER);
        pw.println("<tiles-definitions>");
        Collection defs = definitions.getDefinitions().values();
        try {
            for (XmlDefinition def : defs) {
                pw.print("    <definition ");
                for (String propName : DEFPROPS) {
                    Object propVal = PropertyUtils.getProperty((Object)def, (String)propName);
                    if (propVal == null) continue;
                    pw.print(propName + "=\"" + propVal + "\" ");
                }
                pw.println(">");
                Map attrs = def.getAttributes();
                for (Object attrKey : attrs.keySet()) {
                    pw.println("       <put name=\"" + attrKey + "\" value=\"" + attrs.get(attrKey) + "\"/>");
                }
                pw.println("    </definition>");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        pw.println("</tiles-definitions>");
        pw.flush();
        pw.close();
    }

    public static void setOriginalDefinitionsFactory(DefinitionsFactory origFactory, String modulePrefix, ServletContext servletContext) {
        servletContext.setAttribute(ORIG_DEFS_FACTORY_KEY + modulePrefix, (Object)origFactory);
    }

    public static DefinitionsFactory getOriginalDefinitionsFactory(String modulePrefix, ServletContext servletContext) {
        return (DefinitionsFactory)servletContext.getAttribute(ORIG_DEFS_FACTORY_KEY + modulePrefix);
    }

    public static void removeOriginalDefinitionsFactory(String modulePrefix, ServletContext servletContext) {
        servletContext.removeAttribute(ORIG_DEFS_FACTORY_KEY + modulePrefix);
    }

    public static void main(String[] args) {
        String filename = "WebContent/WEB-INF/tiles-config-test.xml";
        String outfile = "WebContent/WEB-INF/tiles-config-test.effective.xml";
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (IOException ex) {
            System.out.println("can't open file '" + filename + "' : " + ex.getMessage());
            System.exit(-1);
        }
        XmlDefinitionsSet definitions = null;
        try {
            XmlParser parser = new XmlParser();
            parser.setValidating(true);
            definitions = new XmlDefinitionsSet();
            System.out.println("  Parse file");
            parser.parse((InputStream)input, definitions);
            System.out.println("  done.");
        }
        catch (Exception ex) {
            System.out.println("Error during parsing '" + filename + "' : " + ex.getMessage());
            ex.printStackTrace();
            System.exit(-1);
        }
        try {
            DynamicTilesFactoryActual.process(definitions);
        }
        catch (TilesException e) {
            e.printStackTrace();
        }
        try {
            DynamicTilesFactoryActual.dump(new FileOutputStream(outfile), definitions);
            DynamicTilesFactoryActual.dump(System.out, definitions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

