/*
 * Decompiled with CFR 0.152.
 */
package net.chronakis.struts.tiles;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.chronakis.struts.tiles.DynamicTilesFactoryActual;
import net.chronakis.struts.tiles.DynamicTilesUtils;
import org.apache.commons.chain.Context;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.commands.TilesPreProcessor;
import org.apache.struts.tiles.xmlDefinition.DefinitionsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTilesPreprocessor
extends TilesPreProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DynamicTilesPreprocessor.class);
    DefinitionsFactory origFactory;
    Map<String, String> vars;

    public boolean execute(Context context) throws Exception {
        logger.debug("execute() - START");
        ServletActionContext sacontext = (ServletActionContext)context;
        ModuleConfig moduleConfig = sacontext.getModuleConfig();
        String modulePrefix = "";
        if (moduleConfig == null) {
            logger.warn("Could not find the module config from the servlet action context. Using default module as prefix");
        } else {
            modulePrefix = moduleConfig.getPrefix();
        }
        logger.info("Using module prefix: " + modulePrefix);
        this.origFactory = DynamicTilesFactoryActual.getOriginalDefinitionsFactory(modulePrefix, sacontext.getContext());
        if (this.origFactory == null) {
            logger.debug("Cannot find the origFactory for prefix {} - Aborting variable substitution - execute() END", (Object)modulePrefix);
            return super.execute(context);
        }
        ForwardConfig forwardConfig = sacontext.getForwardConfig();
        if (forwardConfig == null || forwardConfig.getPath() == null) {
            logger.debug("No forwrd config - not a tiles forward - execute() END");
            return super.execute(context);
        }
        logger.debug("Searching for definiton for: " + forwardConfig.getPath());
        ComponentDefinition definition = this.getDefinition(forwardConfig.getPath(), (ServletRequest)sacontext.getRequest(), sacontext.getContext());
        if (definition == null) {
            logger.debug("No definition found for path: " + forwardConfig.getPath());
            return super.execute(context);
        }
        logger.debug("Definition for " + forwardConfig.getPath() + " is: name: " + definition.getName() + ", path: " + definition.getPath());
        this.vars = DynamicTilesPreprocessor.getVariables(modulePrefix, sacontext.getRequest(), sacontext.getContext());
        if (this.vars != null) {
            this.processVars(definition, sacontext.getRequest(), sacontext.getContext());
        }
        logger.debug("Definition for " + forwardConfig.getPath() + " became: name: " + definition.getName() + ", path: " + definition.getPath());
        logger.debug("TilesPreProcessor.execute() - END");
        return super.execute(context);
    }

    private void processVars(ComponentDefinition def, HttpServletRequest request, ServletContext context) throws NoSuchDefinitionException, DefinitionsFactoryException {
        ComponentDefinition origDef = this.origFactory.getDefinition(def.getName(), (ServletRequest)request, context);
        if (origDef == null) {
            logger.warn("Original definiton not found");
        } else {
            logger.info("Found original definiton");
        }
        def.setPath(this.substituteVars(origDef.getPath(), this.vars));
        Map attrs = def.getAttributes();
        for (Object attrKey : attrs.keySet()) {
            attrs.put(attrKey, this.substituteVars((String)origDef.getAttribute((String)attrKey), this.vars));
        }
        for (Object attrKey : attrs.keySet()) {
            String attrValue = (String)attrs.get(attrKey);
            ComponentDefinition subDef = this.getDefinition(attrValue, (ServletRequest)request, context);
            if (subDef == null) continue;
            logger.debug("  Attribute " + attrKey + " looks like a tile definition. Attempting to process nested tile");
            this.processVars(subDef, request, context);
        }
    }

    private String substituteVars(String subject, Map<String, String> vars) {
        String result = subject;
        logger.trace("Processing string " + subject);
        Pattern p = Pattern.compile("\\$\\{.+?\\}");
        Matcher m = p.matcher(subject);
        while (m.find()) {
            String varKey = subject.substring(m.start() + 2, m.end() - 1);
            String varVal = vars.get(varKey);
            if (varVal == null) {
                logger.warn("Variable " + varKey + " not found in any of the servletContext, session or request");
                continue;
            }
            logger.trace("Found replacement substring: " + varKey + " with value " + varVal);
            result = result.replaceAll("\\$\\{" + varKey + "\\}", varVal);
        }
        logger.trace("Processed string is: " + result);
        return result;
    }

    private ComponentDefinition getDefinition(String name, ServletRequest request, ServletContext context) {
        ComponentDefinition def = null;
        try {
            def = TilesUtil.getDefinition((String)name, (ServletRequest)request, (ServletContext)context);
        }
        catch (FactoryNotFoundException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (DefinitionsFactoryException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        return def;
    }

    protected static Map<String, String> getVariables(String modulePrefix, HttpServletRequest request, ServletContext context) {
        HashMap<String, String> vars = new HashMap<String, String>();
        Map<String, String> varsPart = DynamicTilesUtils.getVariables(modulePrefix, context);
        if (varsPart != null) {
            vars.putAll(varsPart);
        }
        if ((varsPart = DynamicTilesUtils.getVariables(modulePrefix, request.getSession())) != null) {
            vars.putAll(varsPart);
        }
        if ((varsPart = DynamicTilesUtils.getVariables(modulePrefix, (ServletRequest)request)) != null) {
            vars.putAll(varsPart);
        }
        return vars;
    }
}

