/*
 * Decompiled with CFR 0.152.
 */
package net.chronakis.struts.tiles;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.ModuleUtils;

public class DynamicTilesUtils {
    static final String VARIABLES_KEY = "DynamicTilesPreprocessorVariables";

    static ModuleConfig getModuleConfig(HttpServletRequest request, ServletContext servletContext) {
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
        if (moduleConfig == null) {
            ModuleUtils.getInstance().selectModule(request, servletContext);
            moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
        }
        return moduleConfig;
    }

    public static void setVariable(String name, String value, String modulePrefix, ServletContext context) {
        DynamicTilesUtils.getVariables(modulePrefix, context).put(name, value);
    }

    public static void setVariable(String name, String value, String modulePrefix, HttpSession session) {
        DynamicTilesUtils.getVariables(modulePrefix, session).put(name, value);
    }

    public static void setVariable(String name, String value, String modulePrefix, ServletRequest request) {
        DynamicTilesUtils.getVariables(modulePrefix, request).put(name, value);
    }

    public static String getVariable(String name, String modulePrefix, ServletContext context) {
        return DynamicTilesUtils.getVariables(modulePrefix, context).get(name);
    }

    public static String getVariable(String name, String modulePrefix, HttpSession session) {
        return DynamicTilesUtils.getVariables(modulePrefix, session).get(name);
    }

    public static String getVariable(String name, String modulePrefix, ServletRequest request) {
        return DynamicTilesUtils.getVariables(modulePrefix, request).get(name);
    }

    public static void removeVariable(String name, String modulePrefix, ServletContext context) {
        DynamicTilesUtils.getVariables(modulePrefix, context).remove(name);
    }

    public static void removeVariable(String name, String modulePrefix, HttpSession session) {
        DynamicTilesUtils.getVariables(modulePrefix, session).remove(name);
    }

    public static void removeVariable(String name, String modulePrefix, ServletRequest request) {
        DynamicTilesUtils.getVariables(modulePrefix, request).remove(name);
    }

    public static Map<String, String> getVariables(String modulePrefix, ServletContext context) {
        HashMap vars = (HashMap)context.getAttribute(VARIABLES_KEY);
        if (vars == null) {
            vars = new HashMap();
            context.setAttribute(VARIABLES_KEY, vars);
        }
        return vars;
    }

    public static Map<String, String> getVariables(String modulePrefix, HttpSession session) {
        HashMap vars = (HashMap)session.getAttribute(VARIABLES_KEY);
        if (vars == null) {
            vars = new HashMap();
            session.setAttribute(VARIABLES_KEY, vars);
        }
        return vars;
    }

    public static Map<String, String> getVariables(String modulePrefix, ServletRequest request) {
        HashMap vars = (HashMap)request.getAttribute(VARIABLES_KEY);
        if (vars == null) {
            vars = new HashMap();
            request.setAttribute(VARIABLES_KEY, vars);
        }
        return vars;
    }

    public static void setVariables(Map<String, String> vars, String modulePrefix, ServletContext context) {
        context.setAttribute(VARIABLES_KEY, vars);
    }

    public static void setVariables(Map<String, String> vars, String modulePrefix, HttpSession session) {
        session.setAttribute(VARIABLES_KEY, vars);
    }

    public static void setVariables(Map<String, String> variables, String modulePrefix, ServletRequest request) {
        request.setAttribute(VARIABLES_KEY, variables);
    }

    public static void removeVariables(String modulePrefix, ServletContext context) {
        context.removeAttribute(VARIABLES_KEY);
    }

    public static void removeVariables(String modulePrefix, HttpSession session) {
        session.removeAttribute(VARIABLES_KEY);
    }

    public static void removeVariables(String modulePrefix, ServletRequest request) {
        request.removeAttribute(VARIABLES_KEY);
    }
}

