/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.codestory.simplelenium.DomElement;
import net.codestory.simplelenium.DomElementFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;

@FunctionalInterface
public interface PageObject
extends DomElementFactory {
    public String url();

    public static <T extends PageObject> T create(Class<T> type) {
        try {
            PageObject pageObject = (PageObject)type.newInstance();
            PageObject.injectMissingElements(pageObject);
            return (T)pageObject;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to create Page Object of type " + type, e);
        }
    }

    public static void injectMissingPageObjects(Object instance) {
        try {
            for (Field field : instance.getClass().getDeclaredFields()) {
                if (!PageObject.class.isAssignableFrom(field.getType()) || Modifier.isFinal(field.getModifiers()) || field.get(instance) != null) continue;
                field.set(instance, PageObject.create(field.getType()));
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable inject missing Page Objects in object of type " + instance.getClass(), e);
        }
    }

    public static void injectMissingElements(PageObject pageObject) {
        try {
            for (Field field : pageObject.getClass().getDeclaredFields()) {
                if (!DomElement.class.isAssignableFrom(field.getType()) || Modifier.isFinal(field.getModifiers()) || field.get(pageObject) != null) continue;
                field.set(pageObject, new DomElement((By)new ByIdOrName(field.getName())));
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable inject missing elements in Page Object of type " + pageObject.getClass(), e);
        }
    }
}

