/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium.filters;

import java.util.Objects;
import java.util.function.Predicate;
import org.openqa.selenium.WebElement;

public class ElementFilter
implements Predicate<WebElement> {
    private static final ElementFilter ANY = new ElementFilter("", element -> true);
    private final String description;
    private final Predicate<WebElement> predicate;

    private ElementFilter(String description, Predicate<WebElement> predicate) {
        this.description = description;
        this.predicate = predicate;
    }

    public static ElementFilter any() {
        return ANY;
    }

    public static ElementFilter withText(String text) {
        return new ElementFilter(" with text [" + text + "]", element -> Objects.equals(element.getText(), text));
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean test(WebElement element) {
        return this.predicate.test(element);
    }
}

