/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Homoglyph {
    private static final List<Set<Integer>> homoglyphs = new ArrayList<Set<Integer>>();
    private final CachingLookup cache = new CachingLookup();

    public Homoglyph(List<Set<Integer>> homoglyphs) {
        Homoglyph.homoglyphs.addAll(homoglyphs);
    }

    public List<SearchResult> search(String text, Collection<String> targetWords) {
        ArrayList<SearchResult> allResults = new ArrayList<SearchResult>();
        CodePoints textCodepoints = new CodePoints(text);
        for (String targetWord : targetWords) {
            allResults.addAll(this.checkForWord(textCodepoints, new CodePoints(targetWord)));
        }
        return allResults;
    }

    public List<SearchResult> search(String text, String ... targetWords) {
        return this.search(text, Arrays.asList(targetWords));
    }

    private Collection<SearchResult> checkForWord(CodePoints text, CodePoints targetWord) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        int lastIndex = text.getLength() - targetWord.getLength();
        for (int i = 0; i <= lastIndex; ++i) {
            if (!this.hasWordAtIndex(text, targetWord, i)) continue;
            results.add(new SearchResult(i, text.subStringAt(i, targetWord.getLength()), targetWord.getText()));
        }
        return results;
    }

    private boolean hasWordAtIndex(CodePoints text, CodePoints targetWord, int index) {
        for (int i = 0; i < targetWord.getLength(); ++i) {
            int targetCharLower = Character.toLowerCase(targetWord.getValue(i));
            int targetCharUpper = Character.toUpperCase(targetWord.getValue(i));
            int textChar = text.getValue(index + i);
            if (this.checkForHomoglyphs(targetCharLower, textChar) || this.checkForHomoglyphs(targetCharUpper, textChar)) continue;
            return false;
        }
        return true;
    }

    private boolean checkForHomoglyphs(int cp1, int cp2) {
        Set<Integer> cp1Set = this.cache.lookup(cp1);
        return cp1Set.contains(cp2);
    }

    public static List<Set<Integer>> parseCharCodesFile(String path) throws IOException {
        String line;
        ArrayList<Set<Integer>> homoglyphs = new ArrayList<Set<Integer>>();
        BufferedReader reader = new BufferedReader(new FileReader(path));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            HashSet<Integer> set = new HashSet<Integer>();
            for (String charCode : line.split(",")) {
                try {
                    set.add(Integer.parseInt(charCode, 16));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            homoglyphs.add(set);
        }
        return homoglyphs;
    }

    public static class CachingLookup {
        private final Map<Integer, Set<Integer>> lookup = new HashMap<Integer, Set<Integer>>();

        public Set<Integer> lookup(int cp) {
            Set s = this.lookup.get(cp);
            if (s == null) {
                for (Set thisSet : homoglyphs) {
                    if (!thisSet.contains(cp)) continue;
                    s = thisSet;
                    break;
                }
                if (s == null) {
                    s = new HashSet<Integer>();
                    s.add(cp);
                }
                this.lookup.put(cp, s);
            }
            return s;
        }
    }

    public static class CodePoints {
        private final Integer[] codepoints;
        private final String text;

        public CodePoints(String text) {
            int codepoint;
            this.text = text;
            ArrayList<Integer> codepointList = new ArrayList<Integer>();
            for (int offset = 0; offset < text.length(); offset += Character.charCount(codepoint)) {
                codepoint = text.codePointAt(offset);
                codepointList.add(codepoint);
            }
            this.codepoints = codepointList.toArray(new Integer[0]);
        }

        public int getValue(int i) {
            return this.codepoints[i];
        }

        public int getLength() {
            return this.codepoints.length;
        }

        public String getText() {
            return this.text;
        }

        public String subStringAt(int s, int l) {
            StringBuilder sb = new StringBuilder(l);
            for (int i = 0; i < l; ++i) {
                sb.appendCodePoint(this.codepoints[s + i]);
            }
            return sb.toString();
        }
    }

    public static class SearchResult {
        public int index;
        public String match;
        public String word;

        public SearchResult(int index, String match, String word) {
            this.index = index;
            this.match = match;
            this.word = word;
        }
    }
}

