/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.List;
import net.codecrete.usb.USBAlternateInterface;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBEndpoint;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.USBAlternateInterfaceImpl;
import net.codecrete.usb.common.USBDescriptors;
import net.codecrete.usb.common.USBEndpointImpl;
import net.codecrete.usb.common.USBInterfaceImpl;

public class DescriptorParser {
    public static Configuration parseConfigurationDescriptor(MemorySegment desc, int vendorID, int productID) {
        Configuration config = DescriptorParser.parseConfiguration(desc);
        USBAlternateInterfaceImpl lastAlternate = null;
        int offset = DescriptorParser.peekDescLength(desc, 0);
        while ((long)offset < desc.byteSize()) {
            int descLength = DescriptorParser.peekDescLength(desc, offset);
            int descType = DescriptorParser.peekDescType(desc, offset);
            if (descType == 4) {
                USBInterfaceImpl intf = DescriptorParser.parseInterface(desc, offset);
                USBInterfaceImpl parent = config.findInterfaceByNumber(intf.number());
                if (parent != null) {
                    parent.addAlternate(intf.alternate());
                } else {
                    config.addInterface(intf);
                }
                lastAlternate = (USBAlternateInterfaceImpl)intf.alternate();
            } else if (descType == 5) {
                USBEndpointImpl lastEndpoint = DescriptorParser.parseEndpoint(desc, offset);
                if (lastAlternate != null) {
                    lastAlternate.addEndpoint(lastEndpoint);
                }
            } else if (descType != 11 && descType != 33 && descType != 36 && descType != 37) {
                System.err.printf("Info: [JavaDoesUSB] unsupported USB descriptor type 0x%02x of device 0x%04x/0x%04x - ignoring descriptor%n", descType, vendorID, productID);
            }
            offset += descLength;
        }
        return config;
    }

    private static Configuration parseConfiguration(MemorySegment descriptor) {
        MemorySegment desc = descriptor.asSlice(0L, USBDescriptors.Configuration.byteSize());
        Configuration config = new Configuration();
        if (2 != USBDescriptors.Configuration_bDescriptorType.get(desc)) {
            throw new USBException("Invalid USB configuration descriptor");
        }
        short totalLength = USBDescriptors.Configuration_wTotalLength.get(desc);
        if (descriptor.byteSize() != (long)totalLength) {
            throw new USBException("Invalid USB configuration descriptor length");
        }
        config.configValue = USBDescriptors.Configuration_bConfigurationValue.get(desc);
        config.attributes = USBDescriptors.Configuration_bmAttributes.get(desc);
        config.maxPower = USBDescriptors.Configuration_bMaxPower.get(desc);
        config.interfaces = new ArrayList<USBInterface>();
        return config;
    }

    private static USBInterfaceImpl parseInterface(MemorySegment descriptor, int offset) {
        MemorySegment desc = descriptor.asSlice((long)offset, USBDescriptors.Interface.byteSize());
        int number = 0xFF & USBDescriptors.Interface_bInterfaceNumber.get(desc);
        int altSetting = 0xFF & USBDescriptors.Interface_bAlternateSetting.get(desc);
        int classCode = 0xFF & USBDescriptors.Interface_bInterfaceClass.get(desc);
        int subclassCode = 0xFF & USBDescriptors.Interface_bInterfaceSubClass.get(desc);
        int protocol = 0xFF & USBDescriptors.Interface_bInterfaceProtocol.get(desc);
        USBAlternateInterfaceImpl alternate = new USBAlternateInterfaceImpl(altSetting, classCode, subclassCode, protocol, new ArrayList<USBEndpoint>());
        ArrayList<USBAlternateInterface> alternates = new ArrayList<USBAlternateInterface>();
        alternates.add(alternate);
        return new USBInterfaceImpl(number, alternates);
    }

    private static USBEndpointImpl parseEndpoint(MemorySegment descriptor, int offset) {
        MemorySegment desc = descriptor.asSlice((long)offset, USBDescriptors.Endpoint.byteSize());
        byte address = USBDescriptors.Endpoint_bEndpointAddress.get(desc);
        byte attributes = USBDescriptors.Endpoint_bmAttributes.get(desc);
        short maxPacketSize = USBDescriptors.Endpoint_wMaxPacketSize.get(desc);
        return new USBEndpointImpl(DescriptorParser.getEndpointNumber(address), DescriptorParser.getEndpointDirection(address), DescriptorParser.getEndpointType(attributes), maxPacketSize);
    }

    private static USBDirection getEndpointDirection(byte address) {
        return (address & 0x80) != 0 ? USBDirection.IN : USBDirection.OUT;
    }

    private static int getEndpointNumber(byte address) {
        return address & 0x7F;
    }

    private static USBTransferType getEndpointType(byte attributes) {
        return switch (attributes & 3) {
            case 1 -> USBTransferType.ISOCHRONOUS;
            case 2 -> USBTransferType.BULK;
            case 3 -> USBTransferType.INTERRUPT;
            default -> null;
        };
    }

    private static int peekDescLength(MemorySegment desc, int offset) {
        return 0xFF & desc.get(ValueLayout.JAVA_BYTE, (long)offset);
    }

    private static int peekDescType(MemorySegment desc, int offset) {
        return 0xFF & desc.get(ValueLayout.JAVA_BYTE, (long)(offset + 1));
    }

    public static class Configuration {
        public List<USBInterface> interfaces;
        public byte configValue;
        public byte attributes;
        public byte maxPower;

        void addInterface(USBInterface intf) {
            this.interfaces.add(intf);
        }

        public USBInterfaceImpl findInterfaceByNumber(int number) {
            return this.interfaces.stream().filter(intf -> intf.number() == number).findFirst().orElse(null);
        }
    }
}

