/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.Collections;
import java.util.List;
import net.codecrete.usb.USBControlTransfer;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBEndpoint;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.USBInterfaceImpl;

public abstract class USBDeviceImpl
implements USBDevice {
    protected final Object id_;
    protected final int vendorId_;
    protected final int productId_;
    protected final String manufacturer_;
    protected final String product_;
    protected final String serialNumber_;
    protected int classCode_;
    protected int subclassCode_;
    protected int protocolCode_;
    protected List<USBInterface> interfaces_;

    protected USBDeviceImpl(Object id, int vendorId, int productId, String manufacturer, String product, String serialNumber) {
        assert (id != null);
        this.id_ = id;
        this.vendorId_ = vendorId;
        this.productId_ = productId;
        this.manufacturer_ = manufacturer;
        this.product_ = product;
        this.serialNumber_ = serialNumber;
    }

    @Override
    public abstract void open();

    @Override
    public abstract void close();

    @Override
    public abstract boolean isOpen();

    protected void checkIsOpen() {
        if (!this.isOpen()) {
            throw new USBException("The device needs to be open to call this method");
        }
    }

    @Override
    public int productId() {
        return this.productId_;
    }

    @Override
    public int vendorId() {
        return this.vendorId_;
    }

    @Override
    public String product() {
        return this.product_;
    }

    @Override
    public String manufacturer() {
        return this.manufacturer_;
    }

    @Override
    public String serialNumber() {
        return this.serialNumber_;
    }

    @Override
    public int classCode() {
        return this.classCode_;
    }

    @Override
    public int subclassCode() {
        return this.subclassCode_;
    }

    @Override
    public int protocolCode() {
        return this.protocolCode_;
    }

    public Object getUniqueId() {
        return this.id_;
    }

    public void setClassCodes(int classCode, int subclassCode, int protocolCode) {
        this.classCode_ = classCode;
        this.subclassCode_ = subclassCode;
        this.protocolCode_ = protocolCode;
    }

    @Override
    public List<USBInterface> interfaces() {
        return Collections.unmodifiableList(this.interfaces_);
    }

    public void setInterfaces(List<USBInterface> interfaces) {
        this.interfaces_ = interfaces;
    }

    @Override
    public abstract void claimInterface(int var1);

    @Override
    public abstract void releaseInterface(int var1);

    public void setClaimed(int interfaceNumber, boolean claimed) {
        for (USBInterface intf : this.interfaces_) {
            if (intf.number() != interfaceNumber) continue;
            ((USBInterfaceImpl)intf).setClaimed(claimed);
            return;
        }
        throw new USBException("Internal error (interface not found)");
    }

    protected USBInterfaceImpl getInterface(int interfaceNumber) {
        return this.interfaces_.stream().filter(intf -> intf.number() == interfaceNumber).findFirst().orElse(null);
    }

    protected byte getEndpointAddress(int endpointNumber, USBDirection direction, USBTransferType transferType1, USBTransferType transferType2) {
        this.checkIsOpen();
        if (endpointNumber >= 1 && endpointNumber <= 127) {
            for (USBInterface intf : this.interfaces_) {
                if (!intf.isClaimed()) continue;
                for (USBEndpoint ep : intf.alternate().endpoints()) {
                    if (ep.number() != endpointNumber || ep.direction() != direction || ep.transferType() != transferType1 && ep.transferType() != transferType2) continue;
                    return (byte)(endpointNumber | (direction == USBDirection.IN ? 128 : 0));
                }
            }
        }
        this.throwInvalidEndpointException(endpointNumber, direction, transferType1, transferType2);
        return 0;
    }

    protected EndpointInfo getEndpoint(int endpointNumber, USBDirection direction, USBTransferType transferType1, USBTransferType transferType2) {
        this.checkIsOpen();
        if (endpointNumber >= 1 && endpointNumber <= 127) {
            for (USBInterface intf : this.interfaces_) {
                if (!intf.isClaimed()) continue;
                for (USBEndpoint ep : intf.alternate().endpoints()) {
                    if (ep.number() != endpointNumber || ep.direction() != direction || ep.transferType() != transferType1 && ep.transferType() != transferType2) continue;
                    return new EndpointInfo(intf.number(), ep.number(), (byte)(endpointNumber | (direction == USBDirection.IN ? 128 : 0)));
                }
            }
        }
        this.throwInvalidEndpointException(endpointNumber, direction, transferType1, transferType2);
        return null;
    }

    protected void throwInvalidEndpointException(int endpointNumber, USBDirection direction, USBTransferType transferType1, USBTransferType transferType2) {
        String transferTypeDesc = transferType2 == null ? transferType1.name() : String.format("%s or %s", transferType1.name(), transferType2.name());
        throw new USBException(String.format("Endpoint number %d does not exist, is not part of a claimed interface or is not valid for %s transfer in %s direction", endpointNumber, transferTypeDesc, direction.name()));
    }

    protected int getInterfaceNumber(int endpointNumber) {
        if (endpointNumber < 1 || endpointNumber > 127) {
            return -1;
        }
        for (USBInterface intf : this.interfaces_) {
            if (!intf.isClaimed()) continue;
            for (USBEndpoint ep : intf.alternate().endpoints()) {
                if (ep.number() != endpointNumber) continue;
                return intf.number();
            }
        }
        return -1;
    }

    @Override
    public abstract byte[] controlTransferIn(USBControlTransfer var1, int var2);

    @Override
    public abstract void controlTransferOut(USBControlTransfer var1, byte[] var2);

    @Override
    public abstract void transferOut(int var1, byte[] var2);

    @Override
    public abstract byte[] transferIn(int var1, int var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        USBDeviceImpl that = (USBDeviceImpl)o;
        return this.id_.equals(that.id_);
    }

    public int hashCode() {
        return this.id_.hashCode();
    }

    public String toString() {
        return "VID: 0x" + String.format("%04x", this.vendorId_) + ", PID: 0x" + String.format("%04x", this.productId_) + ", manufacturer: " + this.manufacturer_ + ", product: " + this.product_ + ", serial: " + this.serialNumber_ + ", ID: " + String.valueOf(this.id_);
    }

    public record EndpointInfo(int interfaceNumber, int endpointNumber, byte endpointAddress) {
    }
}

