/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.io.IOException;
import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.nio.file.Files;
import java.nio.file.Path;
import net.codecrete.usb.USBControlTransfer;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.DescriptorParser;
import net.codecrete.usb.common.USBDescriptors;
import net.codecrete.usb.common.USBDeviceImpl;
import net.codecrete.usb.common.USBInterfaceImpl;
import net.codecrete.usb.linux.IO;
import net.codecrete.usb.linux.gen.fcntl.fcntl;
import net.codecrete.usb.linux.gen.ioctl.ioctl;
import net.codecrete.usb.linux.gen.unistd.unistd;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_bulktransfer;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_ctrltransfer;

public class LinuxUSBDevice
extends USBDeviceImpl {
    private int fd = -1;

    LinuxUSBDevice(Object id, int vendorId, int productId, String manufacturer, String product, String serial) {
        super(id, vendorId, productId, manufacturer, product, serial);
        this.loadDescription((String)id);
    }

    private void loadDescription(String path) {
        byte[] descriptors;
        try {
            descriptors = Files.readAllBytes(Path.of(path, new String[0]));
        }
        catch (IOException e) {
            throw new USBException("Cannot read configuration descriptor", e);
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment descriptorsSegment = MemorySegment.ofArray(descriptors);
            MemorySegment deviceDesc = session.allocate((MemoryLayout)USBDescriptors.Device$Struct);
            deviceDesc.copyFrom(descriptorsSegment.asSlice(0L, USBDescriptors.Device$Struct.byteSize()));
            int classCode = 0xFF & USBDescriptors.Device_bDeviceClass.get(deviceDesc);
            int subclassCode = 0xFF & USBDescriptors.Device_bDeviceSubClass.get(deviceDesc);
            int protocolCode = 0xFF & USBDescriptors.Device_bDeviceProtocol.get(deviceDesc);
            this.setClassCodes(classCode, subclassCode, protocolCode);
            MemorySegment configDesc = session.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)(descriptors.length - 18));
            configDesc.copyFrom(descriptorsSegment.asSlice(USBDescriptors.Device$Struct.byteSize()));
            DescriptorParser.Configuration configuration = DescriptorParser.parseConfigurationDescriptor(configDesc, this.vendorId(), this.productId());
            this.setInterfaces(configuration.interfaces);
        }
    }

    @Override
    public boolean isOpen() {
        return this.fd != -1;
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            throw new USBException("the device is already open");
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment pathUtf8 = session.allocateUtf8String(this.id_.toString());
            this.fd = fcntl.open((Addressable)pathUtf8, fcntl.O_RDWR() | fcntl.O_CLOEXEC(), new Object[0]);
            if (this.fd == -1) {
                throw new USBException("Cannot open USB device", IO.getErrno());
            }
        }
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        for (USBInterface intf : this.interfaces_) {
            ((USBInterfaceImpl)intf).setClaimed(false);
        }
        unistd.close(this.fd);
        this.fd = -1;
    }

    @Override
    public void claimInterface(int interfaceNumber) {
        this.checkIsOpen();
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            throw new USBException(String.format("Invalid interface number: %d", interfaceNumber));
        }
        if (intf.isClaimed()) {
            throw new USBException(String.format("Interface %d has already been claimed", interfaceNumber));
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment intfNumSegment = session.allocate(ValueLayout.JAVA_INT, interfaceNumber);
            int ret = ioctl.ioctl(this.fd, -2147199729L, intfNumSegment.address());
            if (ret != 0) {
                throw new USBException("Cannot claim USB interface", IO.getErrno());
            }
            this.setClaimed(interfaceNumber, true);
        }
    }

    @Override
    public void releaseInterface(int interfaceNumber) {
        this.checkIsOpen();
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            throw new USBException(String.format("Invalid interface number: %d", interfaceNumber));
        }
        if (!intf.isClaimed()) {
            throw new USBException(String.format("Interface %d has not been claimed", interfaceNumber));
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment intfNumSegment = session.allocate(ValueLayout.JAVA_INT, interfaceNumber);
            int ret = ioctl.ioctl(this.fd, -2147199728L, intfNumSegment.address());
            if (ret != 0) {
                throw new USBException("Cannot release USB interface", IO.getErrno());
            }
            this.setClaimed(interfaceNumber, false);
        }
    }

    private MemorySegment createCtrlTransfer(MemorySession session, USBDirection direction, USBControlTransfer setup, MemorySegment data) {
        MemorySegment ctrlTransfer = session.allocate(usbdevfs_ctrltransfer.$LAYOUT());
        int bmRequest = (direction == USBDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
        usbdevfs_ctrltransfer.bRequestType$set(ctrlTransfer, (byte)bmRequest);
        usbdevfs_ctrltransfer.bRequest$set(ctrlTransfer, setup.request());
        usbdevfs_ctrltransfer.wValue$set(ctrlTransfer, setup.value());
        usbdevfs_ctrltransfer.wIndex$set(ctrlTransfer, setup.index());
        usbdevfs_ctrltransfer.wLength$set(ctrlTransfer, (short)data.byteSize());
        usbdevfs_ctrltransfer.data$set(ctrlTransfer, data.address());
        return ctrlTransfer;
    }

    @Override
    public byte[] controlTransferIn(USBControlTransfer setup, int length) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment data = session.allocate((long)length);
            MemorySegment ctrlTransfer = this.createCtrlTransfer(session, USBDirection.IN, setup, data);
            int res = ioctl.ioctl(this.fd, -1072147200L, ctrlTransfer.address());
            if (res < 0) {
                throw new USBException("Control IN transfer failed", IO.getErrno());
            }
            byte[] byArray = data.asSlice(0L, res).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }

    @Override
    public void controlTransferOut(USBControlTransfer setup, byte[] data) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment ctrlTransfer;
            int res;
            int dataLength = data != null ? data.length : 0;
            MemorySegment buffer = session.allocate((long)dataLength);
            if (dataLength != 0) {
                buffer.copyFrom(MemorySegment.ofArray(data));
            }
            if ((res = ioctl.ioctl(this.fd, -1072147200L, (ctrlTransfer = this.createCtrlTransfer(session, USBDirection.OUT, setup, buffer)).address())) < 0) {
                throw new USBException("Control OUT transfer failed", IO.getErrno());
            }
        }
    }

    private MemorySegment createBulkTransfer(MemorySession session, byte endpointAddress, MemorySegment data) {
        MemorySegment transfer = session.allocate(usbdevfs_bulktransfer.$LAYOUT());
        usbdevfs_bulktransfer.ep$set(transfer, 0xFF & endpointAddress);
        usbdevfs_bulktransfer.len$set(transfer, (int)data.byteSize());
        usbdevfs_bulktransfer.data$set(transfer, data.address());
        return transfer;
    }

    @Override
    public void transferOut(int endpointNumber, byte[] data) {
        byte endpointAddress = this.getEndpointAddress(endpointNumber, USBDirection.OUT, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment buffer = session.allocate((long)data.length);
            buffer.copyFrom(MemorySegment.ofArray(data));
            MemorySegment transfer = this.createBulkTransfer(session, endpointAddress, buffer);
            int res = ioctl.ioctl(this.fd, -1072147198L, transfer.address());
            if (res < 0) {
                throw new USBException(String.format("USB OUT transfer on endpoint %d failed", endpointNumber), IO.getErrno());
            }
        }
    }

    @Override
    public byte[] transferIn(int endpointNumber, int maxLength) {
        byte endpointAddress = this.getEndpointAddress(endpointNumber, USBDirection.IN, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment buffer = session.allocate((long)maxLength);
            MemorySegment transfer = this.createBulkTransfer(session, endpointAddress, buffer);
            int res = ioctl.ioctl(this.fd, -1072147198L, transfer.address());
            if (res < 0) {
                throw new USBException(String.format("USB IN transfer on endpoint %d failed", endpointNumber), IO.getErrno());
            }
            byte[] byArray = buffer.asSlice(0L, res).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }
}

