/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.List;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBException;
import net.codecrete.usb.common.USBDeviceRegistry;
import net.codecrete.usb.linux.Linux;
import net.codecrete.usb.linux.LinuxUSBDevice;
import net.codecrete.usb.linux.gen.select.fd_set;
import net.codecrete.usb.linux.gen.select.select;
import net.codecrete.usb.linux.gen.udev.udev;

public class LinuxUSBDeviceRegistry
extends USBDeviceRegistry {
    private static final MemorySegment SUBSYSTEM_USB = MemorySession.global().allocateUtf8String("usb");
    private static final MemorySegment MONITOR_NAME = MemorySession.global().allocateUtf8String("udev");
    private static final MemorySegment DEVTYPE_USB_DEVICE = MemorySession.global().allocateUtf8String("usb_device");

    @Override
    protected void monitorDevices() {
        int fd;
        MemoryAddress monitor;
        try {
            MemoryAddress udevInstance = udev.udev_new();
            if (udevInstance == MemoryAddress.NULL) {
                throw new USBException("internal error (udev_new)");
            }
            monitor = udev.udev_monitor_new_from_netlink((Addressable)udevInstance, (Addressable)MONITOR_NAME);
            if (monitor == MemoryAddress.NULL) {
                throw new USBException("internal error (udev_monitor_new_from_netlink)");
            }
            if (udev.udev_monitor_filter_add_match_subsystem_devtype((Addressable)monitor, (Addressable)SUBSYSTEM_USB, (Addressable)DEVTYPE_USB_DEVICE) < 0) {
                throw new USBException("internal error (udev_monitor_filter_add_match_subsystem_devtype)");
            }
            if (udev.udev_monitor_enable_receiving((Addressable)monitor) < 0) {
                throw new USBException("internal error (udev_monitor_enable_receiving)");
            }
            fd = udev.udev_monitor_get_fd((Addressable)monitor);
            if (fd < 0) {
                throw new USBException("internal error (udev_monitor_get_fd)");
            }
            List<USBDevice> deviceList = this.enumeratePresentDevices((Addressable)udevInstance);
            this.setInitialDeviceList(deviceList);
        }
        catch (Throwable e) {
            this.enumerationFailed(e);
            return;
        }
        while (true) {
            MemorySession session = MemorySession.openConfined();
            try {
                LinuxUSBDeviceRegistry.waitForFileDescriptor(fd, session);
                MemoryAddress udevDevice = udev.udev_monitor_receive_device((Addressable)monitor);
                if (udevDevice == null) continue;
                session.addCloseAction(() -> udev.udev_device_unref((Addressable)udevDevice));
                String action = LinuxUSBDeviceRegistry.getDeviceAction((Addressable)udevDevice);
                if ("add".equals(action)) {
                    this.onDeviceConnected(udevDevice);
                    continue;
                }
                if (!"remove".equals(action)) continue;
                this.onDeviceDisconnected(udevDevice);
                continue;
            }
            finally {
                if (session == null) continue;
                session.close();
                continue;
            }
            break;
        }
    }

    private List<USBDevice> enumeratePresentDevices(Addressable udevInstance) {
        ArrayList<USBDevice> result = new ArrayList<USBDevice>();
        try (MemorySession outerSession = MemorySession.openConfined();){
            MemoryAddress enumerate = udev.udev_enumerate_new(udevInstance);
            if (enumerate == MemoryAddress.NULL) {
                throw new USBException("internal error (udev_enumerate_new)");
            }
            outerSession.addCloseAction(() -> udev.udev_enumerate_unref((Addressable)enumerate));
            if (udev.udev_enumerate_add_match_subsystem((Addressable)enumerate, (Addressable)SUBSYSTEM_USB) < 0) {
                throw new USBException("internal error (udev_enumerate_add_match_subsystem)");
            }
            if (udev.udev_enumerate_scan_devices((Addressable)enumerate) < 0) {
                throw new USBException("internal error (udev_enumerate_scan_devices)");
            }
            MemoryAddress entry = udev.udev_enumerate_get_list_entry((Addressable)enumerate);
            while (entry != MemoryAddress.NULL) {
                try (MemorySession session = MemorySession.openConfined();){
                    MemoryAddress dev;
                    MemoryAddress path = udev.udev_list_entry_get_name((Addressable)entry);
                    if (path != MemoryAddress.NULL && (dev = udev.udev_device_new_from_syspath(udevInstance, (Addressable)path)) != MemoryAddress.NULL) {
                        session.addCloseAction(() -> udev.udev_device_unref((Addressable)dev));
                        USBDevice device = LinuxUSBDeviceRegistry.getDeviceDetails(dev);
                        if (device != null) {
                            result.add(device);
                        }
                    }
                }
                entry = udev.udev_list_entry_get_next((Addressable)entry);
            }
        }
        return result;
    }

    private void onDeviceConnected(MemoryAddress udevDevice) {
        USBDevice device = LinuxUSBDeviceRegistry.getDeviceDetails(udevDevice);
        if (device != null) {
            this.addDevice(device);
        }
    }

    private void onDeviceDisconnected(MemoryAddress udevDevice) {
        String devPath = LinuxUSBDeviceRegistry.getDeviceName((Addressable)udevDevice);
        if (devPath == null) {
            return;
        }
        this.closeAndRemoveDevice(devPath);
    }

    private static USBDevice getDeviceDetails(MemoryAddress udevDevice) {
        int vendorId = 0;
        int productId = 0;
        try {
            String idVendor = LinuxUSBDeviceRegistry.getDeviceAttribute((Addressable)udevDevice, "idVendor");
            if (idVendor == null) {
                return null;
            }
            String idProduct = LinuxUSBDeviceRegistry.getDeviceAttribute((Addressable)udevDevice, "idProduct");
            if (idProduct == null) {
                return null;
            }
            String devPath = LinuxUSBDeviceRegistry.getDeviceName((Addressable)udevDevice);
            if (devPath == null) {
                return null;
            }
            vendorId = Integer.parseInt(idVendor, 16);
            productId = Integer.parseInt(idProduct, 16);
            return new LinuxUSBDevice(devPath, vendorId, productId, LinuxUSBDeviceRegistry.getDeviceAttribute((Addressable)udevDevice, "manufacturer"), LinuxUSBDeviceRegistry.getDeviceAttribute((Addressable)udevDevice, "product"), LinuxUSBDeviceRegistry.getDeviceAttribute((Addressable)udevDevice, "serial"));
        }
        catch (Throwable e) {
            System.err.printf("Info: [JavaDoesUSB] failed to retrieve information about device 0x%04x/0x%04x - ignoring device%n", vendorId, productId);
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static String getDeviceAttribute(Addressable udevDevice, String attribute) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment sysattr = session.allocateUtf8String(attribute);
            MemoryAddress valueAddr = udev.udev_device_get_sysattr_value(udevDevice, (Addressable)sysattr);
            if (valueAddr == MemoryAddress.NULL) {
                String string = null;
                return string;
            }
            MemorySegment value = MemorySegment.ofAddress((MemoryAddress)valueAddr, (long)2000L, (MemorySession)session);
            String string = value.getUtf8String(0L);
            return string;
        }
    }

    private static String getDeviceName(Addressable udevDevice) {
        return Linux.createStringFromAddress(udev.udev_device_get_devnode(udevDevice));
    }

    private static String getDeviceAction(Addressable udevDevice) {
        return Linux.createStringFromAddress(udev.udev_device_get_action(udevDevice));
    }

    private static void waitForFileDescriptor(int fd, MemorySession session) {
        MemorySegment fds = session.allocate(fd_set.$LAYOUT());
        fds.set(ValueLayout.JAVA_LONG, (long)fd / ValueLayout.JAVA_LONG.bitSize(), 1L << (int)((long)fd % ValueLayout.JAVA_LONG.bitSize()));
        int res = select.select(fd + 1, (Addressable)fds, (Addressable)MemoryAddress.NULL, (Addressable)MemoryAddress.NULL, (Addressable)MemoryAddress.NULL);
        if (res <= 0) {
            throw new USBException("internal error (select)");
        }
    }
}

