/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import net.codecrete.usb.macos.gen.corefoundation.CFRange;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;

public class CoreFoundationHelper {
    public static String stringFromCFStringRef(MemoryAddress string) {
        String string2;
        block8: {
            MemorySession session = MemorySession.openConfined();
            try {
                long strLen = CoreFoundation.CFStringGetLength((Addressable)string);
                MemorySegment buffer = session.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, strLen);
                MemorySegment range = session.allocate(CFRange.$LAYOUT());
                CFRange.location$set(range, 0L);
                CFRange.length$set(range, strLen);
                CoreFoundation.CFStringGetCharacters((Addressable)string, range, (Addressable)buffer);
                string2 = new String(buffer.toArray(ValueLayout.JAVA_CHAR));
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            session.close();
        }
        return string2;
    }

    public static MemoryAddress createCFStringRef(String string) {
        try (MemorySession session = MemorySession.openConfined();){
            char[] charArray = string.toCharArray();
            MemorySegment chars = session.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, (long)charArray.length);
            chars.copyFrom(MemorySegment.ofArray(charArray));
            MemoryAddress memoryAddress = CoreFoundation.CFStringCreateWithCharacters((Addressable)MemoryAddress.NULL, (Addressable)chars, string.length());
            return memoryAddress;
        }
    }
}

