/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.ValueLayout;
import net.codecrete.usb.macos.CoreFoundationHelper;
import net.codecrete.usb.macos.IoKitUSB;
import net.codecrete.usb.macos.UUID;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;
import net.codecrete.usb.macos.gen.iokit.IOKit;

public class IoKitHelper {
    public static final MemoryAddress kIOUSBDeviceUserClientTypeID = UUID.CreateCFUUID(new byte[]{-99, -57, -73, -128, -98, -64, 17, -44, -91, 79, 0, 10, 39, 5, 40, 97});
    public static final MemoryAddress kIOUSBInterfaceUserClientTypeID = UUID.CreateCFUUID(new byte[]{45, -105, -122, -58, -98, -13, 17, -44, -83, 81, 0, 10, 39, 5, 40, 97});
    public static final MemoryAddress kIOUSBDeviceInterfaceID100 = UUID.CreateCFUUID(new byte[]{92, -127, -121, -48, -98, -13, 17, -44, -117, 69, 0, 10, 39, 5, 40, 97});
    public static final MemoryAddress kIOUSBInterfaceInterfaceID100 = UUID.CreateCFUUID(new byte[]{115, -55, 122, -24, -98, -13, 17, -44, -79, -48, 0, 10, 39, 5, 40, 97});
    public static final MemoryAddress kIOCFPlugInInterfaceID = UUID.CreateCFUUID(new byte[]{-62, 68, -24, 88, 16, -100, 17, -44, -111, -44, 0, 80, -28, -58, 66, 111});

    public static MemoryAddress getInterface(int service, Addressable pluginType, MemoryAddress interfaceId) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment plugHolder = session.allocate((ValueLayout.OfAddress)ValueLayout.ADDRESS, (Addressable)MemoryAddress.NULL);
            MemorySegment score = session.allocate(ValueLayout.JAVA_INT, 0);
            int ret = IOKit.IOCreatePlugInInterfaceForService(service, pluginType, (Addressable)kIOCFPlugInInterfaceID, (Addressable)plugHolder, (Addressable)score);
            if (ret != 0) {
                MemoryAddress memoryAddress = null;
                return memoryAddress;
            }
            MemoryAddress plug = plugHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L);
            MemorySegment intfHolder = session.allocate((ValueLayout.OfAddress)ValueLayout.ADDRESS, (Addressable)MemoryAddress.NULL);
            MemorySegment refiid = CoreFoundation.CFUUIDGetUUIDBytes((SegmentAllocator)session, (Addressable)interfaceId);
            ret = IoKitUSB.QueryInterface(plug, refiid, intfHolder.address());
            IoKitUSB.Release(plug);
            if (ret != 0) {
                MemoryAddress memoryAddress = null;
                return memoryAddress;
            }
            MemoryAddress memoryAddress = intfHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L);
            return memoryAddress;
        }
    }

    public static Integer getPropertyInt(int service, String key) {
        MemoryAddress cfKey = CoreFoundationHelper.createCFStringRef(key);
        MemoryAddress value = IOKit.IORegistryEntryCreateCFProperty(service, (Addressable)cfKey, (Addressable)MemoryAddress.NULL, 0);
        if (value == MemoryAddress.NULL) {
            return null;
        }
        Integer result = null;
        long type = CoreFoundation.CFGetTypeID((Addressable)value);
        if (type == CoreFoundation.CFNumberGetTypeID()) {
            try (MemorySession session = MemorySession.openConfined();){
                MemorySegment numberValue = session.allocate(ValueLayout.JAVA_INT, 0);
                if (CoreFoundation.CFNumberGetValue((Addressable)value, CoreFoundation.kCFNumberSInt32Type(), (Addressable)numberValue) != 0) {
                    result = numberValue.get(ValueLayout.JAVA_INT, 0L);
                }
            }
        }
        CoreFoundation.CFRelease((Addressable)value);
        return result;
    }

    public static String getPropertyString(int service, String key) {
        MemoryAddress cfKey = CoreFoundationHelper.createCFStringRef(key);
        MemoryAddress value = IOKit.IORegistryEntryCreateCFProperty(service, (Addressable)cfKey, (Addressable)MemoryAddress.NULL, 0);
        if (value == MemoryAddress.NULL) {
            return null;
        }
        String result = null;
        long type = CoreFoundation.CFGetTypeID((Addressable)value);
        if (type == CoreFoundation.CFStringGetTypeID()) {
            result = CoreFoundationHelper.stringFromCFStringRef(value);
        }
        CoreFoundation.CFRelease((Addressable)value);
        return result;
    }

    public static int getRefCount(MemoryAddress self) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment object = MemorySegment.ofAddress((MemoryAddress)self, (long)16L, (MemorySession)session);
            MemoryAddress dataAddr = object.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, ValueLayout.ADDRESS.byteSize());
            MemorySegment data = MemorySegment.ofAddress((MemoryAddress)dataAddr, (long)12L, (MemorySession)session);
            int n = data.get(ValueLayout.JAVA_INT, 8L);
            return n;
        }
    }
}

