/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.codecrete.usb.USBControlTransfer;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.DescriptorParser;
import net.codecrete.usb.common.USBDescriptors;
import net.codecrete.usb.common.USBDeviceImpl;
import net.codecrete.usb.macos.IoKitHelper;
import net.codecrete.usb.macos.IoKitUSB;
import net.codecrete.usb.macos.MacosUSBException;
import net.codecrete.usb.macos.gen.iokit.IOKit;
import net.codecrete.usb.macos.gen.iokit.IOUSBDevRequest;
import net.codecrete.usb.macos.gen.iokit.IOUSBFindInterfaceRequest;

public class MacosUSBDevice
extends USBDeviceImpl {
    private final MemoryAddress device;
    private int configurationValue;
    private List<InterfaceInfo> claimedInterfaces;
    private Map<Byte, EndpointInfo> endpoints;

    MacosUSBDevice(MemoryAddress device, Object id, int vendorId, int productId, String manufacturer, String product, String serial) {
        super(id, vendorId, productId, manufacturer, product, serial);
        this.device = device;
        this.loadDescription();
        IoKitUSB.AddRef(device);
    }

    @Override
    public boolean isOpen() {
        return this.claimedInterfaces != null;
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            throw new USBException("the device is already open");
        }
        int ret = IoKitUSB.USBDeviceOpen(this.device);
        if (ret != 0) {
            throw new MacosUSBException("unable to open USB device", ret);
        }
        ret = IoKitUSB.SetConfiguration(this.device, (byte)this.configurationValue);
        if (ret != 0) {
            throw new MacosUSBException("failed to set configuration", ret);
        }
        this.claimedInterfaces = new ArrayList<InterfaceInfo>();
        this.updateEndpointList();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        for (InterfaceInfo interfaceInfo : this.claimedInterfaces) {
            IoKitUSB.USBInterfaceClose(interfaceInfo.asAddress());
            IoKitUSB.Release(interfaceInfo.asAddress());
            this.setClaimed(interfaceInfo.interfaceNumber, false);
        }
        this.claimedInterfaces = null;
        this.endpoints = null;
        IoKitUSB.USBDeviceClose(this.device);
    }

    void closeFully() {
        this.close();
        IoKitUSB.Release(this.device);
    }

    private void loadDescription() {
        try (MemorySession session = MemorySession.openConfined();){
            try {
                MemorySegment descPtrHolder = session.allocate((MemoryLayout)ValueLayout.ADDRESS);
                int ret = IoKitUSB.GetConfigurationDescriptorPtr(this.device, (byte)0, descPtrHolder.address());
                if (ret != 0) {
                    throw new MacosUSBException("failed to query first configuration", ret);
                }
                MemorySegment configDescHeader = MemorySegment.ofAddress((MemoryAddress)descPtrHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L), (long)USBDescriptors.Configuration.byteSize(), (MemorySession)session);
                short totalLength = USBDescriptors.Configuration_wTotalLength.get(configDescHeader);
                MemorySegment configDesc = MemorySegment.ofAddress((MemoryAddress)descPtrHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L), (long)totalLength, (MemorySession)session);
                DescriptorParser.Configuration configuration = DescriptorParser.parseConfigurationDescriptor(configDesc, this.vendorId(), this.productId());
                this.configurationValue = 0xFF & configuration.configValue;
                this.setInterfaces(configuration.interfaces);
            }
            catch (Throwable e) {
                this.configurationValue = 0;
                throw e;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InterfaceInfo findInterface(int interfaceNumber) {
        try (MemorySession outerSession = MemorySession.openConfined();){
            int service;
            MemorySegment request = outerSession.allocate(IOUSBFindInterfaceRequest.$LAYOUT());
            IOUSBFindInterfaceRequest.bInterfaceClass$set(request, (short)IOKit.kIOUSBFindInterfaceDontCare());
            IOUSBFindInterfaceRequest.bInterfaceSubClass$set(request, (short)IOKit.kIOUSBFindInterfaceDontCare());
            IOUSBFindInterfaceRequest.bInterfaceProtocol$set(request, (short)IOKit.kIOUSBFindInterfaceDontCare());
            IOUSBFindInterfaceRequest.bAlternateSetting$set(request, (short)IOKit.kIOUSBFindInterfaceDontCare());
            MemorySegment iterHolder = outerSession.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            int ret = IoKitUSB.CreateInterfaceIterator(this.device, request.address(), iterHolder.address());
            int iter = iterHolder.get(ValueLayout.JAVA_INT, 0L);
            if (ret != 0) {
                throw new RuntimeException("CreateInterfaceIterator failed");
            }
            outerSession.addCloseAction(() -> IOKit.IOObjectRelease(iter));
            while ((service = IOKit.IOIteratorNext(iter)) != 0) {
                InterfaceInfo interfaceInfo;
                MemoryAddress intf;
                MemorySession session;
                block16: {
                    block15: {
                        session = MemorySession.openConfined();
                        int service_final = service;
                        session.addCloseAction(() -> IOKit.IOObjectRelease(service_final));
                        intf = IoKitHelper.getInterface(service, (Addressable)IoKitHelper.kIOUSBInterfaceUserClientTypeID, IoKitHelper.kIOUSBInterfaceInterfaceID100);
                        if (intf != null) break block15;
                        if (session == null) continue;
                        session.close();
                        continue;
                    }
                    MemorySegment intfNumberHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
                    IoKitUSB.GetInterfaceNumber(intf, intfNumberHolder.address());
                    if (intfNumberHolder.get(ValueLayout.JAVA_INT, 0L) == interfaceNumber) break block16;
                    IoKitUSB.Release(intf);
                    if (session == null) continue;
                    session.close();
                    continue;
                }
                try {
                    interfaceInfo = new InterfaceInfo(intf.toRawLongValue(), interfaceNumber);
                    if (session == null) return interfaceInfo;
                }
                catch (Throwable throwable) {
                    try {
                        if (session == null) throw throwable;
                        try {
                            session.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        throw new MacosUSBException(String.format("Invalid interface number: %d", interfaceNumber));
                    }
                }
                session.close();
                return interfaceInfo;
            }
        }
    }

    @Override
    public void claimInterface(int interfaceNumber) {
        this.checkIsOpen();
        InterfaceInfo interfaceInfo = this.findInterface(interfaceNumber);
        try {
            int ret = IoKitUSB.USBInterfaceOpen(interfaceInfo.asAddress());
            if (ret != 0) {
                throw new MacosUSBException("Failed to claim interface", ret);
            }
            this.setClaimed(interfaceNumber, true);
        }
        catch (Throwable t) {
            IoKitUSB.Release(interfaceInfo.asAddress());
            throw t;
        }
        this.claimedInterfaces.add(interfaceInfo);
        this.updateEndpointList();
    }

    @Override
    public void releaseInterface(int interfaceNumber) {
        this.checkIsOpen();
        Optional<InterfaceInfo> interfaceInfoOptional = this.claimedInterfaces.stream().filter(info -> info.interfaceNumber == interfaceNumber).findFirst();
        if (interfaceInfoOptional.isEmpty()) {
            throw new MacosUSBException(String.format("Invalid interface number: %d", interfaceNumber));
        }
        InterfaceInfo interfaceInfo = interfaceInfoOptional.get();
        int ret = IoKitUSB.USBInterfaceClose(interfaceInfo.asAddress());
        if (ret != 0) {
            throw new MacosUSBException("Failed to release interface", ret);
        }
        this.claimedInterfaces.remove(interfaceInfo);
        IoKitUSB.Release(interfaceInfo.asAddress());
        this.setClaimed(interfaceNumber, false);
        this.updateEndpointList();
    }

    private void updateEndpointList() {
        this.endpoints = new HashMap<Byte, EndpointInfo>();
        for (InterfaceInfo interfaceInfo : this.claimedInterfaces) {
            MemorySession session = MemorySession.openConfined();
            try {
                MemoryAddress intf = interfaceInfo.asAddress();
                MemorySegment numEndpointsHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                int ret = IoKitUSB.GetNumEndpoints(intf, numEndpointsHolder.address());
                if (ret != 0) {
                    throw new MacosUSBException("Failed to get number of endpoints", ret);
                }
                int numEndpoints = numEndpointsHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                for (int pipeIndex = 1; pipeIndex <= numEndpoints; ++pipeIndex) {
                    MemorySegment directionHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                    MemorySegment numberHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                    MemorySegment transferTypeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                    MemorySegment maxPacketSizeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_SHORT);
                    MemorySegment intervalHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                    ret = IoKitUSB.GetPipeProperties(intf, (byte)pipeIndex, directionHolder.address(), numberHolder.address(), transferTypeHolder.address(), maxPacketSizeHolder.address(), intervalHolder.address());
                    if (ret != 0) {
                        throw new MacosUSBException("Failed to get pipe properties", ret);
                    }
                    int endpointNumber = numberHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                    int direction = directionHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                    byte endpointAddress = (byte)(endpointNumber | direction << 7);
                    byte transferType = transferTypeHolder.get(ValueLayout.JAVA_BYTE, 0L);
                    EndpointInfo endpointInfo = new EndpointInfo(interfaceInfo.addr, (byte)pipeIndex, MacosUSBDevice.getTransferType(transferType));
                    this.endpoints.put(endpointAddress, endpointInfo);
                }
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
    }

    private EndpointInfo getEndpointInfo(int endpointNumber, USBDirection direction, USBTransferType transferType1, USBTransferType transferType2) {
        byte endpointAddress;
        EndpointInfo endpointInfo;
        if (this.endpoints != null && (endpointInfo = this.endpoints.get(endpointAddress = (byte)(endpointNumber | (direction == USBDirection.IN ? 128 : 0)))) != null && (endpointInfo.transferType == transferType1 || endpointInfo.transferType == transferType2)) {
            return endpointInfo;
        }
        String transferTypeDesc = transferType2 == null ? transferType1.name() : String.format("%s or %s", transferType1.name(), transferType2.name());
        throw new USBException(String.format("Endpoint number %d does not exist, is not part of a claimed interface or is not valid for %s transfer in %s direction", endpointNumber, transferTypeDesc, direction.name()));
    }

    private static MemorySegment createDeviceRequest(MemorySession session, USBDirection direction, USBControlTransfer setup, MemorySegment data) {
        MemorySegment deviceRequest = session.allocate(IOUSBDevRequest.$LAYOUT());
        int bmRequestType = (direction == USBDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
        IOUSBDevRequest.bmRequestType$set(deviceRequest, (byte)bmRequestType);
        IOUSBDevRequest.bRequest$set(deviceRequest, setup.request());
        IOUSBDevRequest.wValue$set(deviceRequest, setup.value());
        IOUSBDevRequest.wIndex$set(deviceRequest, setup.index());
        IOUSBDevRequest.wLength$set(deviceRequest, (short)data.byteSize());
        IOUSBDevRequest.pData$set(deviceRequest, data.address());
        return deviceRequest;
    }

    @Override
    public byte[] controlTransferIn(USBControlTransfer setup, int length) {
        this.checkIsOpen();
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment data = session.allocate((long)length);
            MemorySegment deviceRequest = MacosUSBDevice.createDeviceRequest(session, USBDirection.IN, setup, data);
            int ret = IoKitUSB.DeviceRequest(this.device, deviceRequest.address());
            if (ret != 0) {
                throw new MacosUSBException("Control IN transfer failed", ret);
            }
            int lenDone = IOUSBDevRequest.wLenDone$get(deviceRequest);
            byte[] byArray = data.asSlice(0L, lenDone).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }

    @Override
    public void controlTransferOut(USBControlTransfer setup, byte[] data) {
        this.checkIsOpen();
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment deviceRequest;
            int ret;
            int dataLength = data != null ? data.length : 0;
            MemorySegment dataSegment = session.allocate((long)dataLength);
            if (dataLength > 0) {
                dataSegment.copyFrom(MemorySegment.ofArray(data));
            }
            if ((ret = IoKitUSB.DeviceRequest(this.device, (deviceRequest = MacosUSBDevice.createDeviceRequest(session, USBDirection.OUT, setup, dataSegment)).address())) != 0) {
                throw new MacosUSBException("Control IN transfer failed", ret);
            }
        }
    }

    @Override
    public void transferOut(int endpointNumber, byte[] data) {
        EndpointInfo endpointInfo = this.getEndpointInfo(endpointNumber, USBDirection.OUT, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment nativeData = session.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)data.length);
            nativeData.copyFrom(MemorySegment.ofArray(data));
            int ret = IoKitUSB.WritePipe(endpointInfo.interfacAddress(), endpointInfo.pipeIndex, nativeData.address(), data.length);
            if (ret != 0) {
                throw new MacosUSBException(String.format("Sending data to endpoint %d failed", endpointNumber), ret);
            }
        }
    }

    @Override
    public byte[] transferIn(int endpointNumber, int maxLength) {
        EndpointInfo endpointInfo = this.getEndpointInfo(endpointNumber, USBDirection.IN, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment nativeData = session.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)maxLength);
            MemorySegment sizeHolder = session.allocate(ValueLayout.JAVA_INT, maxLength);
            int ret = IoKitUSB.ReadPipe(endpointInfo.interfacAddress(), endpointInfo.pipeIndex, nativeData.address(), sizeHolder.address());
            if (ret != 0) {
                throw new MacosUSBException(String.format("Receiving data from endpoint %d failed", endpointNumber), ret);
            }
            int size = sizeHolder.get(ValueLayout.JAVA_INT, 0L);
            byte[] result = new byte[size];
            MemorySegment resultSegment = MemorySegment.ofArray(result);
            resultSegment.copyFrom(nativeData.asSlice(0L, size));
            byte[] byArray = result;
            return byArray;
        }
    }

    private static USBTransferType getTransferType(byte macosTransferType) {
        return switch (macosTransferType) {
            case 1 -> USBTransferType.ISOCHRONOUS;
            case 2 -> USBTransferType.BULK;
            case 3 -> USBTransferType.INTERRUPT;
            default -> null;
        };
    }

    record InterfaceInfo(long addr, int interfaceNumber) {
        MemoryAddress asAddress() {
            return MemoryAddress.ofLong((long)this.addr);
        }
    }

    record EndpointInfo(long interfaceAddr, byte pipeIndex, USBTransferType transferType) {
        MemoryAddress interfacAddress() {
            return MemoryAddress.ofLong((long)this.interfaceAddr);
        }
    }
}

