/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.util.List;
import net.codecrete.usb.USBException;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.WindowsUSBException;
import net.codecrete.usb.windows.gen.advapi32.Advapi32;
import net.codecrete.usb.windows.gen.kernel32.GUID;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.setupapi.SP_DEVICE_INTERFACE_DATA;
import net.codecrete.usb.windows.gen.setupapi.SP_DEVICE_INTERFACE_DETAIL_DATA_W;
import net.codecrete.usb.windows.gen.setupapi.SetupAPI;

public class DeviceProperty {
    public static final MemorySegment DEVPKEY_Device_Address = DeviceProperty.createDEVPROPKEY(-1537465010, (short)-8420, (short)20221, (byte)-128, (byte)32, (byte)103, (byte)-47, (byte)70, (byte)-88, (byte)80, (byte)-32, 30);
    public static final MemorySegment DEVPKEY_Device_InstanceId = DeviceProperty.createDEVPROPKEY(2026065864, (short)4170, (short)19146, (byte)-98, (byte)-92, (byte)82, (byte)77, (byte)82, (byte)-103, (byte)110, (byte)87, 256);
    public static final MemorySegment DEVPKEY_Device_Parent = DeviceProperty.createDEVPROPKEY(1128310469, (short)-27654, (short)18182, (byte)-105, (byte)44, (byte)123, (byte)100, (byte)-128, (byte)8, (byte)-91, (byte)-89, 8);
    public static final MemorySegment DEVPKEY_Device_Service = DeviceProperty.createDEVPROPKEY(-1537465010, (short)-8420, (short)20221, (byte)-128, (byte)32, (byte)103, (byte)-47, (byte)70, (byte)-88, (byte)80, (byte)-32, 6);
    public static final MemorySegment DEVPKEY_Device_Children = DeviceProperty.createDEVPROPKEY(1128310469, (short)-27654, (short)18182, (byte)-105, (byte)44, (byte)123, (byte)100, (byte)-128, (byte)8, (byte)-91, (byte)-89, 9);
    public static final MemorySegment DEVPKEY_Device_HardwareIds = DeviceProperty.createDEVPROPKEY(-1537465010, (short)-8420, (short)20221, (byte)-128, (byte)32, (byte)103, (byte)-47, (byte)70, (byte)-88, (byte)80, (byte)-32, 3);

    public static int getDeviceIntProperty(Addressable devInfo, Addressable devInfoData, Addressable propertyKey) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment propertyTypeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            MemorySegment propertyValueHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (SetupAPI.SetupDiGetDevicePropertyW(devInfo, devInfoData, propertyKey, (Addressable)propertyTypeHolder, (Addressable)propertyValueHolder, (int)propertyValueHolder.byteSize(), (Addressable)MemoryAddress.NULL, 0) == 0) {
                throw new WindowsUSBException("Internal error (SetupDiGetDevicePropertyW)", Kernel32.GetLastError());
            }
            if (propertyTypeHolder.get(ValueLayout.JAVA_INT, 0L) != SetupAPI.DEVPROP_TYPE_UINT32()) {
                throw new USBException("Internal error (expected property type UINT32)");
            }
            int n = propertyValueHolder.get(ValueLayout.JAVA_INT, 0L);
            return n;
        }
    }

    public static String getDeviceStringProperty(Addressable devInfo, Addressable devInfoData, Addressable propertyKey) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment propertyValue = DeviceProperty.getProperty(devInfo, devInfoData, propertyKey, SetupAPI.DEVPROP_TYPE_STRING(), session);
            String string = Win.createStringFromSegment(propertyValue);
            return string;
        }
    }

    public static List<String> getDeviceStringListProperty(Addressable devInfo, Addressable devInfoData, Addressable propertyKey) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment propertyValue = DeviceProperty.getProperty(devInfo, devInfoData, propertyKey, SetupAPI.DEVPROP_TYPE_STRING() | SetupAPI.DEVPROP_TYPEMOD_LIST(), session);
            List<String> list = Win.createStringListFromSegment(propertyValue);
            return list;
        }
    }

    private static MemorySegment getProperty(Addressable devInfo, Addressable devInfoData, Addressable propertyKey, int propertyType, MemorySession session) {
        MemorySegment requiredSizeHolder;
        MemorySegment propertyTypeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
        if (SetupAPI.SetupDiGetDevicePropertyW(devInfo, devInfoData, propertyKey, (Addressable)propertyTypeHolder, (Addressable)MemoryAddress.NULL, 0, (Addressable)(requiredSizeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT)), 0) == 0) {
            // empty if block
        }
        if (propertyTypeHolder.get(ValueLayout.JAVA_INT, 0L) != propertyType) {
            throw new USBException("Internal error (unexpected property type)");
        }
        int stringLen = requiredSizeHolder.get(ValueLayout.JAVA_INT, 0L) / 2 - 1;
        MemorySegment propertyValueHolder = session.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, (long)(stringLen + 1));
        if (SetupAPI.SetupDiGetDevicePropertyW(devInfo, devInfoData, propertyKey, (Addressable)propertyTypeHolder, (Addressable)propertyValueHolder, (int)propertyValueHolder.byteSize(), (Addressable)MemoryAddress.NULL, 0) == 0) {
            throw new WindowsUSBException("Internal error (SetupDiGetDevicePropertyW)", Kernel32.GetLastError());
        }
        return propertyValueHolder;
    }

    public static List<String> findDeviceInterfaceGUIDs(MemoryAddress devInfoSetHandle, MemorySegment devInfo, MemorySession session) {
        MemoryAddress regKey = SetupAPI.SetupDiOpenDevRegKey((Addressable)devInfoSetHandle, (Addressable)devInfo, SetupAPI.DICS_FLAG_GLOBAL(), 0, SetupAPI.DIREG_DEV(), Advapi32.KEY_READ());
        if (Win.IsInvalidHandle(regKey)) {
            throw new WindowsUSBException("Cannot open device registry key", Kernel32.GetLastError());
        }
        session.addCloseAction(() -> Advapi32.RegCloseKey((Addressable)regKey));
        MemorySegment keyNameSegment = Win.createSegmentFromString("DeviceInterfaceGUIDs", session);
        MemorySegment valueTypeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
        MemorySegment valueSizeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
        int res = Advapi32.RegQueryValueExW((Addressable)regKey, (Addressable)keyNameSegment, (Addressable)MemoryAddress.NULL, (Addressable)valueTypeHolder, (Addressable)MemoryAddress.NULL, (Addressable)valueSizeHolder);
        if (res == Kernel32.ERROR_FILE_NOT_FOUND()) {
            return List.of();
        }
        if (res != 0 && res != Kernel32.ERROR_MORE_DATA()) {
            throw new WindowsUSBException("Internal error (RegQueryValueExW)", res);
        }
        int valueSize = valueSizeHolder.get(ValueLayout.JAVA_INT, 0L);
        MemorySegment value = session.allocate((long)valueSize);
        res = Advapi32.RegQueryValueExW((Addressable)regKey, (Addressable)keyNameSegment, (Addressable)MemoryAddress.NULL, (Addressable)valueTypeHolder, (Addressable)value, (Addressable)valueSizeHolder);
        if (res != 0) {
            throw new WindowsUSBException("Internal error (RegQueryValueExW)", res);
        }
        return Win.createStringListFromSegment(value);
    }

    public static String getDevicePath(String instanceID, Addressable interfaceGuid) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment instanceIDSegment = Win.createSegmentFromString(instanceID, session);
            MemoryAddress devInfoSetHandle = SetupAPI.SetupDiGetClassDevsW(interfaceGuid, (Addressable)instanceIDSegment, (Addressable)MemoryAddress.NULL, SetupAPI.DIGCF_PRESENT() | SetupAPI.DIGCF_DEVICEINTERFACE());
            if (Win.IsInvalidHandle(devInfoSetHandle)) {
                throw new USBException("internal error (SetupDiGetClassDevsW)");
            }
            session.addCloseAction(() -> SetupAPI.SetupDiDestroyDeviceInfoList((Addressable)devInfoSetHandle));
            MemorySegment devIntfData = session.allocate(SP_DEVICE_INTERFACE_DATA.$LAYOUT());
            SP_DEVICE_INTERFACE_DATA.cbSize$set(devIntfData, (int)devIntfData.byteSize());
            if (SetupAPI.SetupDiEnumDeviceInterfaces((Addressable)devInfoSetHandle, (Addressable)MemoryAddress.NULL, interfaceGuid, 0, (Addressable)devIntfData) == 0) {
                throw new USBException("internal error (SetupDiEnumDeviceInterfaces)");
            }
            int devicePathOffset = 4;
            MemorySegment intfDetailData = session.allocate(524L);
            SP_DEVICE_INTERFACE_DETAIL_DATA_W.cbSize$set(intfDetailData, (int)SP_DEVICE_INTERFACE_DETAIL_DATA_W.sizeof());
            int intfDetailDataSize = (int)intfDetailData.byteSize();
            if (SetupAPI.SetupDiGetDeviceInterfaceDetailW((Addressable)devInfoSetHandle, (Addressable)devIntfData, (Addressable)intfDetailData, intfDetailDataSize, (Addressable)MemoryAddress.NULL, (Addressable)MemoryAddress.NULL) == 0) {
                throw new WindowsUSBException("Internal error (SetupDiGetDeviceInterfaceDetailW)", Kernel32.GetLastError());
            }
            String string = Win.createStringFromSegment(intfDetailData.asSlice(4L));
            return string;
        }
    }

    public static MemorySegment createDEVPROPKEY(int data1, short data2, short data3, byte data4_0, byte data4_1, byte data4_2, byte data4_3, byte data4_4, byte data4_5, byte data4_6, byte data4_7, int pid) {
        MemorySegment propKey = MemorySession.global().allocate(GUID.sizeof() + ValueLayout.JAVA_INT.byteSize());
        Win.setGUID(propKey, data1, data2, data3, data4_0, data4_1, data4_2, data4_3, data4_4, data4_5, data4_6, data4_7);
        propKey.set(ValueLayout.JAVA_INT, 16L, pid);
        return propKey;
    }
}

