/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.util.List;
import net.codecrete.usb.USBControlTransfer;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.USBRecipient;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.DescriptorParser;
import net.codecrete.usb.common.USBDeviceImpl;
import net.codecrete.usb.common.USBInterfaceImpl;
import net.codecrete.usb.common.USBStructs;
import net.codecrete.usb.windows.CompositeFunction;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.WindowsUSBException;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.winusb.WinUSB;

public class WindowsUSBDevice
extends USBDeviceImpl {
    private final List<CompositeFunction> functions;
    private boolean isOpen_;

    WindowsUSBDevice(String devicePath, List<CompositeFunction> functions, int vendorId, int productId, String manufacturer, String product, String serial, MemorySegment configDesc) {
        super(devicePath, vendorId, productId, manufacturer, product, serial);
        this.functions = functions;
        this.readDescription(configDesc);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen_;
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            throw new USBException("the device is already open");
        }
        this.isOpen_ = true;
    }

    private void readDescription(MemorySegment configDesc) {
        DescriptorParser.Configuration configuration = DescriptorParser.parseConfigurationDescriptor(configDesc, this.vendorId(), this.productId());
        this.setInterfaces(configuration.interfaces);
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        for (USBInterface intf : this.interfaces_) {
            if (!intf.isClaimed()) continue;
            this.releaseInterface(intf.number());
        }
        this.isOpen_ = false;
    }

    private CompositeFunction findFunction(int interfaceNumber) {
        return this.functions.stream().filter(func -> func.firstInterfaceNumber() == interfaceNumber).findFirst().orElse(null);
    }

    private CompositeFunction findAnyOpenFunction() {
        return this.functions.stream().filter(func -> func.firstInterfaceHandle() != null).findFirst().orElse(null);
    }

    private CompositeFunction findControlTransferFunction(USBControlTransfer setup) {
        int interfaceNumber = -1;
        int endpointNumber = -1;
        if (setup.recipient() == USBRecipient.INTERFACE) {
            interfaceNumber = setup.index() & 0xFF;
        } else if (setup.recipient() == USBRecipient.ENDPOINT && (endpointNumber = setup.index() & 0xFF) != 0 && (interfaceNumber = this.getInterfaceNumber(endpointNumber)) == -1) {
            interfaceNumber = -2;
        }
        CompositeFunction function = null;
        if (interfaceNumber >= 0) {
            function = this.findFunction(interfaceNumber);
        } else if (interfaceNumber == -1) {
            function = this.findAnyOpenFunction();
        }
        if (function == null || function.firstInterfaceHandle() == null) {
            throw new USBException("Interface not claimed for control transfer");
        }
        return function;
    }

    @Override
    public void claimInterface(int interfaceNumber) {
        this.checkIsOpen();
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            throw new USBException(String.format("Invalid interface number: %d", interfaceNumber));
        }
        if (intf.isClaimed()) {
            throw new USBException(String.format("Interface %d has already been claimed", interfaceNumber));
        }
        CompositeFunction function = this.findFunction(interfaceNumber);
        if (function == null) {
            throw new USBException(String.format("Interface number %d cannot be claimed (no DeviceInterfaceGUID?)", interfaceNumber));
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment pathSegment = Win.createSegmentFromString(function.devicePath(), session);
            MemoryAddress deviceHandle = Kernel32.CreateFileW((Addressable)pathSegment, Kernel32.GENERIC_WRITE() | Kernel32.GENERIC_READ(), Kernel32.FILE_SHARE_WRITE() | Kernel32.FILE_SHARE_READ(), (Addressable)MemoryAddress.NULL, Kernel32.OPEN_EXISTING(), Kernel32.FILE_ATTRIBUTE_NORMAL() | Kernel32.FILE_FLAG_OVERLAPPED(), (Addressable)MemoryAddress.NULL);
            if (Win.IsInvalidHandle(deviceHandle)) {
                throw new WindowsUSBException(String.format("Cannot open USB device %s", function.devicePath()), Kernel32.GetLastError());
            }
            try {
                MemorySegment interfaceHandleHolder = session.allocate((MemoryLayout)ValueLayout.ADDRESS);
                if (WinUSB.WinUsb_Initialize((Addressable)deviceHandle, (Addressable)interfaceHandleHolder) == 0) {
                    throw new WindowsUSBException("Cannot open WinUSB device", Kernel32.GetLastError());
                }
                MemoryAddress interfaceHandle = interfaceHandleHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L);
                function.setDeviceHandle(deviceHandle);
                function.setFirstInterfaceHandle(interfaceHandle);
            }
            catch (Throwable e) {
                Kernel32.CloseHandle((Addressable)deviceHandle);
                throw e;
            }
        }
        this.setClaimed(interfaceNumber, true);
    }

    @Override
    public void releaseInterface(int interfaceNumber) {
        this.checkIsOpen();
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            throw new USBException(String.format("Invalid interface number: %d", interfaceNumber));
        }
        if (!intf.isClaimed()) {
            throw new USBException(String.format("Interface %d has not been claimed", interfaceNumber));
        }
        CompositeFunction function = this.findFunction(interfaceNumber);
        assert (function != null);
        if (function.deviceHandle() != null) {
            WinUSB.WinUsb_Free((Addressable)function.firstInterfaceHandle());
            function.setFirstInterfaceHandle(null);
            Kernel32.CloseHandle((Addressable)function.deviceHandle());
            function.setDeviceHandle(null);
        }
        this.setClaimed(interfaceNumber, false);
    }

    private MemorySegment createSetupPacket(MemorySession session, USBDirection direction, USBControlTransfer setup, MemorySegment data) {
        MemorySegment setupPacket = session.allocate((MemoryLayout)USBStructs.SetupPacket$Struct);
        int bmRequest = (direction == USBDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
        USBStructs.SetupPacket_bmRequest.set(setupPacket, (byte)bmRequest);
        USBStructs.SetupPacket_bRequest.set(setupPacket, setup.request());
        USBStructs.SetupPacket_wValue.set(setupPacket, setup.value());
        USBStructs.SetupPacket_wIndex.set(setupPacket, setup.index());
        USBStructs.SetupPacket_wLength.set(setupPacket, (short)(data != null ? data.byteSize() : 0L));
        return setupPacket;
    }

    @Override
    public byte[] controlTransferIn(USBControlTransfer setup, int length) {
        this.checkIsOpen();
        CompositeFunction function = this.findControlTransferFunction(setup);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment buffer = session.allocate((long)length);
            MemorySegment setupPacket = this.createSetupPacket(session, USBDirection.IN, setup, buffer);
            MemorySegment lengthHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (WinUSB.WinUsb_ControlTransfer((Addressable)function.firstInterfaceHandle(), setupPacket, (Addressable)buffer, (int)buffer.byteSize(), (Addressable)lengthHolder, (Addressable)MemoryAddress.NULL) == 0) {
                throw new WindowsUSBException("Control transfer IN failed", Kernel32.GetLastError());
            }
            int rxLength = lengthHolder.get(ValueLayout.JAVA_INT, 0L);
            byte[] byArray = buffer.asSlice(0L, rxLength).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }

    @Override
    public void controlTransferOut(USBControlTransfer setup, byte[] data) {
        this.checkIsOpen();
        CompositeFunction function = this.findControlTransferFunction(setup);
        try (MemorySession session = MemorySession.openConfined();){
            int dataLength = data != null ? data.length : 0;
            MemorySegment buffer = session.allocate((long)dataLength);
            if (dataLength != 0) {
                buffer.copyFrom(MemorySegment.ofArray(data));
            }
            MemorySegment setupPacket = this.createSetupPacket(session, USBDirection.OUT, setup, buffer);
            MemorySegment lengthHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (WinUSB.WinUsb_ControlTransfer((Addressable)function.firstInterfaceHandle(), setupPacket, (Addressable)buffer, (int)buffer.byteSize(), (Addressable)lengthHolder, (Addressable)MemoryAddress.NULL) == 0) {
                throw new WindowsUSBException("Control transfer OUT failed", Kernel32.GetLastError());
            }
        }
    }

    @Override
    public void transferOut(int endpointNumber, byte[] data) {
        this.checkIsOpen();
        USBDeviceImpl.EndpointInfo endpoint = this.getEndpoint(endpointNumber, USBDirection.OUT, USBTransferType.BULK, USBTransferType.INTERRUPT);
        CompositeFunction function = this.findFunction(endpoint.interfaceNumber());
        assert (function != null);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment buffer = session.allocate((long)data.length);
            buffer.copyFrom(MemorySegment.ofArray(data));
            MemorySegment lengthHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (WinUSB.WinUsb_WritePipe((Addressable)function.firstInterfaceHandle(), endpoint.endpointAddress(), (Addressable)buffer, (int)buffer.byteSize(), (Addressable)lengthHolder, (Addressable)MemoryAddress.NULL) == 0) {
                throw new WindowsUSBException("Bulk/interrupt transfer OUT failed", Kernel32.GetLastError());
            }
        }
    }

    @Override
    public byte[] transferIn(int endpointNumber, int maxLength) {
        USBDeviceImpl.EndpointInfo endpoint = this.getEndpoint(endpointNumber, USBDirection.IN, USBTransferType.BULK, USBTransferType.INTERRUPT);
        CompositeFunction function = this.findFunction(endpoint.interfaceNumber());
        assert (function != null);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment buffer = session.allocate((long)maxLength);
            MemorySegment lengthHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (WinUSB.WinUsb_ReadPipe((Addressable)function.firstInterfaceHandle(), endpoint.endpointAddress(), (Addressable)buffer, (int)buffer.byteSize(), (Addressable)lengthHolder, (Addressable)MemoryAddress.NULL) == 0) {
                throw new WindowsUSBException("Bulk/interrupt transfer IN failed", Kernel32.GetLastError());
            }
            int len = lengthHolder.get(ValueLayout.JAVA_INT, 0L);
            byte[] byArray = buffer.asSlice(0L, len).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }
}

