/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Addressable;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBException;
import net.codecrete.usb.common.USBDescriptors;
import net.codecrete.usb.common.USBDeviceImpl;
import net.codecrete.usb.common.USBDeviceRegistry;
import net.codecrete.usb.common.USBStructs;
import net.codecrete.usb.windows.CompositeFunction;
import net.codecrete.usb.windows.DeviceProperty;
import net.codecrete.usb.windows.USBHelper;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.WindowsUSBDevice;
import net.codecrete.usb.windows.WindowsUSBException;
import net.codecrete.usb.windows.gen.kernel32.GUID;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.ole32.Ole32;
import net.codecrete.usb.windows.gen.setupapi.SP_DEVICE_INTERFACE_DATA;
import net.codecrete.usb.windows.gen.setupapi.SP_DEVINFO_DATA;
import net.codecrete.usb.windows.gen.setupapi.SetupAPI;
import net.codecrete.usb.windows.gen.usbioctl.USBIoctl;
import net.codecrete.usb.windows.gen.user32.DEV_BROADCAST_DEVICEINTERFACE_W;
import net.codecrete.usb.windows.gen.user32.DEV_BROADCAST_HDR;
import net.codecrete.usb.windows.gen.user32.MSG;
import net.codecrete.usb.windows.gen.user32.User32;
import net.codecrete.usb.windows.gen.user32.WNDCLASSEXW;

public class WindowsUSBDeviceRegistry
extends USBDeviceRegistry {
    private static final Pattern MULTIPLE_INTERFACE_ID = Pattern.compile("USB\\\\VID_[0-9A-Fa-f]{4}&PID_[0-9A-Fa-f]{4}&MI_([0-9A-Fa-f]{2})");

    @Override
    protected void monitorDevices() {
        MemorySession session = MemorySession.openConfined();
        try {
            MemoryAddress hwnd;
            try {
                MemorySegment className = Win.createSegmentFromString("USB_MONITOR", session);
                MemorySegment windowName = Win.createSegmentFromString("USB device monitor", session);
                MemoryAddress instance = Kernel32.GetModuleHandleW((Addressable)MemoryAddress.NULL);
                MethodHandle handleWindowMessageMH = MethodHandles.lookup().findVirtual(WindowsUSBDeviceRegistry.class, "handleWindowMessage", MethodType.methodType(Long.TYPE, MemoryAddress.class, Integer.TYPE, Long.TYPE, Long.TYPE)).bindTo(this);
                MemorySegment handleWindowMessageStub = Linker.nativeLinker().upcallStub(handleWindowMessageMH, FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG), session);
                MemorySegment wx = session.allocate(WNDCLASSEXW.$LAYOUT());
                WNDCLASSEXW.cbSize$set(wx, (int)wx.byteSize());
                WNDCLASSEXW.lpfnWndProc$set(wx, handleWindowMessageStub.address());
                WNDCLASSEXW.hInstance$set(wx, instance);
                WNDCLASSEXW.lpszClassName$set(wx, className.address());
                User32.RegisterClassExW((Addressable)wx);
                hwnd = User32.CreateWindowExW(0, (Addressable)className, (Addressable)windowName, 0, 0, 0, 0, 0, (Addressable)User32.HWND_MESSAGE(), (Addressable)MemoryAddress.NULL, (Addressable)instance, (Addressable)MemoryAddress.NULL);
                if (hwnd == MemoryAddress.NULL) {
                    throw new WindowsUSBException("internal error (CreateWindowExW)", Kernel32.GetLastError());
                }
                MemorySegment notificationFilter = session.allocate(DEV_BROADCAST_DEVICEINTERFACE_W.$LAYOUT());
                DEV_BROADCAST_DEVICEINTERFACE_W.dbcc_size$set(notificationFilter, (int)notificationFilter.byteSize());
                DEV_BROADCAST_DEVICEINTERFACE_W.dbcc_devicetype$set(notificationFilter, User32.DBT_DEVTYP_DEVICEINTERFACE());
                DEV_BROADCAST_DEVICEINTERFACE_W.dbcc_classguid$slice(notificationFilter).copyFrom(USBHelper.GUID_DEVINTERFACE_USB_DEVICE);
                MemoryAddress notifyHandle = User32.RegisterDeviceNotificationW((Addressable)hwnd, (Addressable)notificationFilter, User32.DEVICE_NOTIFY_WINDOW_HANDLE());
                if (notifyHandle == MemoryAddress.NULL) {
                    throw new WindowsUSBException("internal error (RegisterDeviceNotificationW)", Kernel32.GetLastError());
                }
                this.enumeratePresentDevices();
            }
            catch (Throwable e) {
                this.enumerationFailed(e);
                if (session != null) {
                    session.close();
                }
                return;
            }
            MemorySegment msg = session.allocate(MSG.$LAYOUT());
            while (User32.GetMessageW((Addressable)msg, (Addressable)hwnd, 0, 0) > 0) {
            }
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void enumeratePresentDevices() {
        ArrayList<USBDevice> deviceList = new ArrayList<USBDevice>();
        try (MemorySession outerSession = MemorySession.openConfined();){
            MemoryAddress devInfoSetHandle = SetupAPI.SetupDiGetClassDevsW((Addressable)USBHelper.GUID_DEVINTERFACE_USB_DEVICE, (Addressable)MemoryAddress.NULL, (Addressable)MemoryAddress.NULL, SetupAPI.DIGCF_PRESENT() | SetupAPI.DIGCF_DEVICEINTERFACE());
            if (Win.IsInvalidHandle(devInfoSetHandle)) {
                throw new USBException("internal error (SetupDiGetClassDevsW)");
            }
            outerSession.addCloseAction(() -> SetupAPI.SetupDiDestroyDeviceInfoList((Addressable)devInfoSetHandle));
            MemorySegment devInfo = MemorySegment.allocateNative((MemoryLayout)SP_DEVINFO_DATA.$LAYOUT(), (MemorySession)outerSession);
            SP_DEVINFO_DATA.cbSize$set(devInfo, (int)SP_DEVINFO_DATA.$LAYOUT().byteSize());
            HashMap<String, MemoryAddress> hubHandles = new HashMap<String, MemoryAddress>();
            outerSession.addCloseAction(() -> hubHandles.forEach((path, handle) -> Kernel32.CloseHandle((Addressable)handle)));
            int i = 0;
            while (true) {
                if (SetupAPI.SetupDiEnumDeviceInfo((Addressable)devInfoSetHandle, i, (Addressable)devInfo) == 0) {
                    int err = Kernel32.GetLastError();
                    if (err == Kernel32.ERROR_NO_MORE_ITEMS() || err == Kernel32.ERROR_SUCCESS()) break;
                    throw new USBException("Internal error (SetupDiEnumDeviceInfo) ");
                }
                String instanceID = DeviceProperty.getDeviceStringProperty((Addressable)devInfoSetHandle, (Addressable)devInfo, (Addressable)DeviceProperty.DEVPKEY_Device_InstanceId);
                String devicePath = DeviceProperty.getDevicePath(instanceID, (Addressable)USBHelper.GUID_DEVINTERFACE_USB_DEVICE);
                try {
                    deviceList.add(this.createDeviceFromDeviceInfo(devInfoSetHandle, devInfo, devicePath, hubHandles));
                }
                catch (Throwable e) {
                    System.err.printf("Info: [JavaDoesUSB] failed to retrieve information about device %s - ignoring device%n", devicePath);
                    e.printStackTrace(System.err);
                }
                ++i;
            }
            this.setInitialDeviceList(deviceList);
        }
    }

    private List<CompositeFunction> getCompositeFunctions(List<String> childrenIds) {
        ArrayList<CompositeFunction> functions = new ArrayList<CompositeFunction>();
        block8: for (String instanceId : childrenIds) {
            MemorySession session = MemorySession.openConfined();
            try {
                MemoryAddress devInfoSetHandle = SetupAPI.SetupDiCreateDeviceInfoList((Addressable)MemoryAddress.NULL, (Addressable)MemoryAddress.NULL);
                if (Win.IsInvalidHandle(devInfoSetHandle)) {
                    throw new WindowsUSBException("Cannot create device info list", Kernel32.GetLastError());
                }
                session.addCloseAction(() -> SetupAPI.SetupDiDestroyDeviceInfoList((Addressable)devInfoSetHandle));
                MemorySegment devInfo = session.allocate(SP_DEVINFO_DATA.$LAYOUT());
                SP_DEVINFO_DATA.cbSize$set(devInfo, (int)devInfo.byteSize());
                MemorySegment instanceIdSegment = Win.createSegmentFromString(instanceId, session);
                if (SetupAPI.SetupDiOpenDeviceInfoW((Addressable)devInfoSetHandle, (Addressable)instanceIdSegment, (Addressable)MemoryAddress.NULL, 0, (Addressable)devInfo) == 0) {
                    throw new WindowsUSBException("Internal error (SetupDiOpenDeviceInfoW)", Kernel32.GetLastError());
                }
                List<String> hardwareIds = DeviceProperty.getDeviceStringListProperty((Addressable)devInfoSetHandle, (Addressable)devInfo, (Addressable)DeviceProperty.DEVPKEY_Device_HardwareIds);
                int interfaceNumber = WindowsUSBDeviceRegistry.extractInterfaceNumber(hardwareIds);
                if (interfaceNumber == -1) continue;
                List<String> guids = DeviceProperty.findDeviceInterfaceGUIDs(devInfoSetHandle, devInfo, session);
                for (String guid : guids) {
                    MemorySegment clsid;
                    MemorySegment guidSegment = Win.createSegmentFromString(guid, session);
                    if (Ole32.CLSIDFromString((Addressable)guidSegment, (Addressable)(clsid = session.allocate(GUID.$LAYOUT()))) != 0) continue;
                    try {
                        String devicePath = DeviceProperty.getDevicePath(instanceId, (Addressable)clsid);
                        functions.add(new CompositeFunction(interfaceNumber, devicePath));
                        continue block8;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
        return functions;
    }

    private USBDevice createDeviceFromDeviceInfo(MemoryAddress devInfoSetHandle, MemorySegment devInfo, String devicePath, HashMap<String, MemoryAddress> hubHandles) {
        try (MemorySession session = MemorySession.openConfined();){
            ArrayList<CompositeFunction> functions;
            String deviceService;
            int usbPortNum = DeviceProperty.getDeviceIntProperty((Addressable)devInfoSetHandle, (Addressable)devInfo, (Addressable)DeviceProperty.DEVPKEY_Device_Address);
            String parentInstanceID = DeviceProperty.getDeviceStringProperty((Addressable)devInfoSetHandle, (Addressable)devInfo, (Addressable)DeviceProperty.DEVPKEY_Device_Parent);
            String hubPath = DeviceProperty.getDevicePath(parentInstanceID, (Addressable)USBHelper.GUID_DEVINTERFACE_USB_HUB);
            MemoryAddress hubHandle = hubHandles.get(hubPath);
            if (hubHandle == null) {
                MemorySegment hubPathSeg = Win.createSegmentFromString(hubPath, session);
                hubHandle = Kernel32.CreateFileW((Addressable)hubPathSeg, Kernel32.GENERIC_WRITE(), Kernel32.FILE_SHARE_WRITE(), (Addressable)MemoryAddress.NULL, Kernel32.OPEN_EXISTING(), 0, (Addressable)MemoryAddress.NULL);
                if (Win.IsInvalidHandle(hubHandle)) {
                    throw new USBException("Cannot open USB hub", Kernel32.GetLastError());
                }
                hubHandles.put(hubPath, hubHandle);
            }
            if (WindowsUSBDeviceRegistry.isCompositeDevice(deviceService = DeviceProperty.getDeviceStringProperty((Addressable)devInfoSetHandle, (Addressable)devInfo, (Addressable)DeviceProperty.DEVPKEY_Device_Service))) {
                functions = this.getCompositeFunctions(DeviceProperty.getDeviceStringListProperty((Addressable)devInfoSetHandle, (Addressable)devInfo, (Addressable)DeviceProperty.DEVPKEY_Device_Children));
            } else {
                functions = new ArrayList<CompositeFunction>();
                functions.add(new CompositeFunction(0, devicePath));
            }
            USBDevice uSBDevice = this.createDevice(devicePath, functions, hubHandle, usbPortNum);
            return uSBDevice;
        }
    }

    private USBDevice createDevice(String devicePath, List<CompositeFunction> functions, MemoryAddress hubHandle, int usbPortNum) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment connInfo = session.allocate((MemoryLayout)USBHelper.USB_NODE_CONNECTION_INFORMATION_EX$Struct);
            USBHelper.USB_NODE_CONNECTION_INFORMATION_EX_ConnectionIndex.set(connInfo, usbPortNum);
            MemorySegment sizeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (Kernel32.DeviceIoControl((Addressable)hubHandle, USBIoctl.IOCTL_USB_GET_NODE_CONNECTION_INFORMATION_EX(), (Addressable)connInfo, (int)connInfo.byteSize(), (Addressable)connInfo, (int)connInfo.byteSize(), (Addressable)sizeHolder, (Addressable)MemoryAddress.NULL) == 0) {
                throw new WindowsUSBException("Internal error (cannot get device descriptor)", Kernel32.GetLastError());
            }
            MemorySegment deviceDesc = USBHelper.USB_NODE_CONNECTION_INFORMATION_EX_DeviceDescriptor$slice(connInfo);
            int manufacturerIndex = 0xFF & USBDescriptors.Device_iManufacturer.get(deviceDesc);
            String manufacturer = this.getStringDescriptor((Addressable)hubHandle, usbPortNum, manufacturerIndex);
            int productIndex = 0xFF & USBDescriptors.Device_iProduct.get(deviceDesc);
            String product = this.getStringDescriptor((Addressable)hubHandle, usbPortNum, productIndex);
            int serialNumberIndex = 0xFF & USBDescriptors.Device_iSerialNumber.get(deviceDesc);
            String serialNumber = this.getStringDescriptor((Addressable)hubHandle, usbPortNum, serialNumberIndex);
            int vendorId = 0xFFFF & USBDescriptors.Device_idVendor.get(deviceDesc);
            int productId = 0xFFFF & USBDescriptors.Device_idProduct.get(deviceDesc);
            MemorySegment configDesc = this.getDescriptor((Addressable)hubHandle, usbPortNum, 2, 0, (short)0, session);
            WindowsUSBDevice device = new WindowsUSBDevice(devicePath, functions, vendorId, productId, manufacturer, product, serialNumber, configDesc);
            int classCode = 0xFF & USBDescriptors.Device_bDeviceClass.get(deviceDesc);
            int subclassCode = 0xFF & USBDescriptors.Device_bDeviceSubClass.get(deviceDesc);
            int protocolCode = 0xFF & USBDescriptors.Device_bDeviceProtocol.get(deviceDesc);
            device.setClassCodes(classCode, subclassCode, protocolCode);
            WindowsUSBDevice windowsUSBDevice = device;
            return windowsUSBDevice;
        }
    }

    private MemorySegment getDescriptor(Addressable hubHandle, int usbPortNumber, int descriptorType, int index, short languageID, MemorySession session) {
        return this.getDescriptor(hubHandle, usbPortNumber, descriptorType, index, languageID, 0, session);
    }

    private MemorySegment getDescriptor(Addressable hubHandle, int usbPortNumber, int descriptorType, int index, short languageID, int requestSize, MemorySession session) {
        int expectedSize;
        int size = requestSize != 0 ? requestSize + (int)USBHelper.USB_DESCRIPTOR_REQUEST_Data$Offset : 256;
        MemorySegment descriptorRequest = session.allocate((long)size);
        USBHelper.USB_DESCRIPTOR_REQUEST_ConnectionIndex.set(descriptorRequest, usbPortNumber);
        MemorySegment setupPacket = descriptorRequest.asSlice(USBHelper.USB_DESCRIPTOR_REQUEST_SetupPacket$Offset, USBStructs.SetupPacket$Struct.byteSize());
        USBStructs.SetupPacket_bmRequest.set(setupPacket, (byte)-128);
        USBStructs.SetupPacket_bRequest.set(setupPacket, (byte)6);
        USBStructs.SetupPacket_wValue.set(setupPacket, (short)(descriptorType << 8 | index));
        USBStructs.SetupPacket_wIndex.set(setupPacket, languageID);
        USBStructs.SetupPacket_wLength.set(setupPacket, (short)((long)size - USBHelper.USB_DESCRIPTOR_REQUEST_Data$Offset));
        MemorySegment effectiveSizeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
        if (Kernel32.DeviceIoControl(hubHandle, USBIoctl.IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION(), (Addressable)descriptorRequest, size, (Addressable)descriptorRequest, size, (Addressable)effectiveSizeHolder, (Addressable)MemoryAddress.NULL) == 0) {
            throw new WindowsUSBException(String.format("Cannot retrieve descriptor %d", index), Kernel32.GetLastError());
        }
        if (descriptorType != 2) {
            expectedSize = 0xFF & descriptorRequest.get(ValueLayout.JAVA_BYTE, USBHelper.USB_DESCRIPTOR_REQUEST_Data$Offset);
        } else {
            MemorySegment configDesc = descriptorRequest.asSlice(USBHelper.USB_DESCRIPTOR_REQUEST_Data$Offset, USBDescriptors.Configuration.byteSize());
            expectedSize = USBDescriptors.Configuration_wTotalLength.get(configDesc);
        }
        long effectiveSize = (long)effectiveSizeHolder.get(ValueLayout.JAVA_INT, 0L) - USBHelper.USB_DESCRIPTOR_REQUEST_Data$Offset;
        if (effectiveSize != (long)expectedSize) {
            if (requestSize != 0) {
                throw new USBException("Unexpected descriptor size");
            }
            return this.getDescriptor(hubHandle, usbPortNumber, descriptorType, index, languageID, expectedSize, session);
        }
        return descriptorRequest.asSlice(USBHelper.USB_DESCRIPTOR_REQUEST_Data$Offset, effectiveSize);
    }

    private String getStringDescriptor(Addressable hubHandle, int usbPortNumber, int index) {
        if (index == 0) {
            return null;
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment stringDesc = this.getDescriptor(hubHandle, usbPortNumber, 3, index, (short)1033, session);
            int stringLen = 0xFF & USBHelper.USB_STRING_DESCRIPTOR_bLength.get(stringDesc);
            char[] chars = stringDesc.asSlice(USBHelper.USB_STRING_DESCRIPTOR_bString$Offset, stringLen - 2).toArray(ValueLayout.JAVA_CHAR);
            String string = new String(chars);
            return string;
        }
    }

    private long handleWindowMessage(MemoryAddress hWnd, int uMsg, long wParam, long lParam) {
        if (uMsg == User32.WM_DEVICECHANGE() && (wParam == (long)User32.DBT_DEVICEARRIVAL() || wParam == (long)User32.DBT_DEVICEREMOVECOMPLETE())) {
            try (MemorySession session = MemorySession.openConfined();){
                MemorySegment data = MemorySegment.ofAddress((MemoryAddress)MemoryAddress.ofLong((long)lParam), (long)DEV_BROADCAST_DEVICEINTERFACE_W.sizeof(), (MemorySession)session);
                if (DEV_BROADCAST_HDR.dbch_devicetype$get(data) == User32.DBT_DEVTYP_DEVICEINTERFACE()) {
                    MemorySegment nameSlice = MemorySegment.ofAddress((MemoryAddress)DEV_BROADCAST_DEVICEINTERFACE_W.dbcc_name$slice(data).address(), (long)500L, (MemorySession)session);
                    String devicePath = Win.createStringFromSegment(nameSlice);
                    if (wParam == (long)User32.DBT_DEVICEARRIVAL()) {
                        this.onDeviceConnected(devicePath);
                    } else {
                        this.onDeviceDisconnected(devicePath);
                    }
                    long l = 0L;
                    return l;
                }
            }
        }
        return User32.DefWindowProcW((Addressable)hWnd, uMsg, wParam, lParam);
    }

    private void onDeviceConnected(String devicePath) {
        try (MemorySession session = MemorySession.openConfined();){
            int err;
            MemoryAddress devInfoSetHandle = SetupAPI.SetupDiGetClassDevsW((Addressable)USBHelper.GUID_DEVINTERFACE_USB_DEVICE, (Addressable)MemoryAddress.NULL, (Addressable)MemoryAddress.NULL, SetupAPI.DIGCF_PRESENT() | SetupAPI.DIGCF_DEVICEINTERFACE());
            if (Win.IsInvalidHandle(devInfoSetHandle)) {
                throw new WindowsUSBException("internal error (SetupDiGetClassDevsW)", Kernel32.GetLastError());
            }
            session.addCloseAction(() -> SetupAPI.SetupDiDestroyDeviceInfoList((Addressable)devInfoSetHandle));
            MemorySegment devIntfData = session.allocate(SP_DEVICE_INTERFACE_DATA.$LAYOUT());
            SP_DEVICE_INTERFACE_DATA.cbSize$set(devIntfData, (int)devIntfData.byteSize());
            MemorySegment devicePathSegment = Win.createSegmentFromString(devicePath, session);
            if (SetupAPI.SetupDiOpenDeviceInterfaceW((Addressable)devInfoSetHandle, (Addressable)devicePathSegment, 0, (Addressable)devIntfData) == 0) {
                throw new WindowsUSBException("internal error (SetupDiOpenDeviceInterfaceW)", Kernel32.GetLastError());
            }
            MemorySegment devInfo = session.allocate(SP_DEVINFO_DATA.$LAYOUT());
            SP_DEVINFO_DATA.cbSize$set(devInfo, (int)devInfo.byteSize());
            if (SetupAPI.SetupDiGetDeviceInterfaceDetailW((Addressable)devInfoSetHandle, (Addressable)devIntfData, (Addressable)MemoryAddress.NULL, 0, (Addressable)MemoryAddress.NULL, (Addressable)devInfo) == 0 && (err = Kernel32.GetLastError()) != Kernel32.ERROR_INSUFFICIENT_BUFFER()) {
                throw new USBException("internal error (SetupDiGetDeviceInterfaceDetailW)", err);
            }
            HashMap<String, MemoryAddress> hubHandles = new HashMap<String, MemoryAddress>();
            session.addCloseAction(() -> hubHandles.forEach((path, handle) -> Kernel32.CloseHandle((Addressable)handle)));
            try {
                USBDevice device = this.createDeviceFromDeviceInfo(devInfoSetHandle, devInfo, devicePath, hubHandles);
                this.addDevice(device);
            }
            catch (Throwable e) {
                System.err.printf("Info: [JavaDoesUSB] failed to retrieve information about device %s - ignoring device%n", devicePath);
                e.printStackTrace(System.err);
            }
        }
    }

    private void onDeviceDisconnected(String devicePath) {
        this.closeAndRemoveDevice(devicePath);
    }

    @Override
    protected int findDeviceIndex(List<USBDevice> deviceList, Object deviceId) {
        String id = deviceId.toString();
        for (int i = 0; i < deviceList.size(); ++i) {
            USBDeviceImpl dev = (USBDeviceImpl)deviceList.get(i);
            if (!id.equalsIgnoreCase(dev.getUniqueId().toString())) continue;
            return i;
        }
        return -1;
    }

    private static boolean isCompositeDevice(String deviceService) {
        return "usbccgp".equalsIgnoreCase(deviceService);
    }

    private static int extractInterfaceNumber(List<String> hardwareIds) {
        for (String id : hardwareIds) {
            Matcher matcher = MULTIPLE_INTERFACE_ID.matcher(id);
            if (!matcher.find()) continue;
            String intfHexNumber = matcher.group(1);
            try {
                return Integer.parseInt(intfHexNumber, 16);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1;
    }
}

