/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import net.codecrete.usb.USBException;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;

public class WindowsUSBException
extends USBException {
    public WindowsUSBException(String message) {
        super(message);
    }

    public WindowsUSBException(String message, int errorCode) {
        super(String.format("%s - %s", message, WindowsUSBException.getErrorMessage(errorCode)), errorCode);
    }

    public WindowsUSBException(String message, Throwable cause) {
        super(message, cause);
    }

    private static String getErrorMessage(int errorCode) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment messagePointerHolder = session.allocate((MemoryLayout)ValueLayout.ADDRESS);
            Kernel32.FormatMessageW(Kernel32.FORMAT_MESSAGE_ALLOCATE_BUFFER() | Kernel32.FORMAT_MESSAGE_FROM_SYSTEM() | Kernel32.FORMAT_MESSAGE_IGNORE_INSERTS(), (Addressable)MemoryAddress.NULL, errorCode, 0, (Addressable)messagePointerHolder, 0, (Addressable)MemoryAddress.NULL);
            MemoryAddress messagePointer = messagePointerHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L);
            String message = Win.createStringFromSegment(MemorySegment.ofAddress((MemoryAddress)messagePointer, (long)4000L, (MemorySession)session));
            Kernel32.LocalFree((Addressable)messagePointer);
            String string = message.trim();
            return string;
        }
    }
}

