/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows.gen.kernel32;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import net.codecrete.usb.windows.gen.kernel32.Constants$root;
import net.codecrete.usb.windows.gen.kernel32.RuntimeHelper;
import net.codecrete.usb.windows.gen.kernel32.constants$0;
import net.codecrete.usb.windows.gen.kernel32.constants$1;

public class Kernel32 {
    public static ValueLayout.OfByte C_CHAR = Constants$root.C_CHAR$LAYOUT;
    public static ValueLayout.OfShort C_SHORT = Constants$root.C_SHORT$LAYOUT;
    public static ValueLayout.OfInt C_INT = Constants$root.C_LONG$LAYOUT;
    public static ValueLayout.OfInt C_LONG = Constants$root.C_LONG$LAYOUT;
    public static ValueLayout.OfLong C_LONG_LONG = Constants$root.C_LONG_LONG$LAYOUT;
    public static ValueLayout.OfFloat C_FLOAT = Constants$root.C_FLOAT$LAYOUT;
    public static ValueLayout.OfDouble C_DOUBLE = Constants$root.C_DOUBLE$LAYOUT;
    public static ValueLayout.OfAddress C_POINTER = Constants$root.C_POINTER$LAYOUT;

    Kernel32() {
    }

    public static int FILE_SHARE_READ() {
        return 1;
    }

    public static int FILE_SHARE_WRITE() {
        return 2;
    }

    public static int FILE_ATTRIBUTE_NORMAL() {
        return 128;
    }

    public static int OPEN_EXISTING() {
        return 3;
    }

    public static int FILE_FLAG_OVERLAPPED() {
        return 0x40000000;
    }

    public static int FORMAT_MESSAGE_ALLOCATE_BUFFER() {
        return 256;
    }

    public static int FORMAT_MESSAGE_IGNORE_INSERTS() {
        return 512;
    }

    public static int FORMAT_MESSAGE_FROM_SYSTEM() {
        return 4096;
    }

    public static MethodHandle CreateFileW$MH() {
        return RuntimeHelper.requireNonNull(constants$0.CreateFileW$MH, "CreateFileW");
    }

    public static MemoryAddress CreateFileW(Addressable lpFileName, int dwDesiredAccess, int dwShareMode, Addressable lpSecurityAttributes, int dwCreationDisposition, int dwFlagsAndAttributes, Addressable hTemplateFile) {
        MethodHandle mh$ = Kernel32.CreateFileW$MH();
        try {
            return mh$.invokeExact(lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle CloseHandle$MH() {
        return RuntimeHelper.requireNonNull(constants$0.CloseHandle$MH, "CloseHandle");
    }

    public static int CloseHandle(Addressable hObject) {
        MethodHandle mh$ = Kernel32.CloseHandle$MH();
        try {
            return mh$.invokeExact(hObject);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle GetLastError$MH() {
        return RuntimeHelper.requireNonNull(constants$0.GetLastError$MH, "GetLastError");
    }

    public static int GetLastError() {
        MethodHandle mh$ = Kernel32.GetLastError$MH();
        try {
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle DeviceIoControl$MH() {
        return RuntimeHelper.requireNonNull(constants$0.DeviceIoControl$MH, "DeviceIoControl");
    }

    public static int DeviceIoControl(Addressable hDevice, int dwIoControlCode, Addressable lpInBuffer, int nInBufferSize, Addressable lpOutBuffer, int nOutBufferSize, Addressable lpBytesReturned, Addressable lpOverlapped) {
        MethodHandle mh$ = Kernel32.DeviceIoControl$MH();
        try {
            return mh$.invokeExact(hDevice, dwIoControlCode, lpInBuffer, nInBufferSize, lpOutBuffer, nOutBufferSize, lpBytesReturned, lpOverlapped);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle GetModuleHandleW$MH() {
        return RuntimeHelper.requireNonNull(constants$0.GetModuleHandleW$MH, "GetModuleHandleW");
    }

    public static MemoryAddress GetModuleHandleW(Addressable lpModuleName) {
        MethodHandle mh$ = Kernel32.GetModuleHandleW$MH();
        try {
            return mh$.invokeExact(lpModuleName);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle LocalFree$MH() {
        return RuntimeHelper.requireNonNull(constants$0.LocalFree$MH, "LocalFree");
    }

    public static MemoryAddress LocalFree(Addressable hMem) {
        MethodHandle mh$ = Kernel32.LocalFree$MH();
        try {
            return mh$.invokeExact(hMem);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle FormatMessageW$MH() {
        return RuntimeHelper.requireNonNull(constants$1.FormatMessageW$MH, "FormatMessageW");
    }

    public static int FormatMessageW(int dwFlags, Addressable lpSource, int dwMessageId, int dwLanguageId, Addressable lpBuffer, int nSize, Addressable Arguments) {
        MethodHandle mh$ = Kernel32.FormatMessageW$MH();
        try {
            return mh$.invokeExact(dwFlags, lpSource, dwMessageId, dwLanguageId, lpBuffer, nSize, Arguments);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int GENERIC_READ() {
        return Integer.MIN_VALUE;
    }

    public static int GENERIC_WRITE() {
        return 0x40000000;
    }

    public static int ERROR_SUCCESS() {
        return 0;
    }

    public static int ERROR_FILE_NOT_FOUND() {
        return 2;
    }

    public static int ERROR_INSUFFICIENT_BUFFER() {
        return 122;
    }

    public static int ERROR_MORE_DATA() {
        return 234;
    }

    public static int ERROR_NO_MORE_ITEMS() {
        return 259;
    }
}

