/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.core;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.cofcool.chaos.server.common.core.Message;
import net.cofcool.chaos.server.common.core.Result;
import net.cofcool.chaos.server.common.core.SimpleExecuteResult;

public interface ExecuteResult<T>
extends Result<T> {
    public T entity();

    public Result.ResultState state();

    @Override
    default public boolean successful() {
        return this.state() == Result.ResultState.SUCCESSFUL;
    }

    public T orElse(T var1);

    @Nullable
    default public <R> R apply(Function<T, R> fn) {
        if (this.orElse(null) != null) {
            return fn.apply(this.entity());
        }
        return null;
    }

    public static <T> ExecuteResult<T> of(T entity, Result.ResultState state, String code, String msg) {
        return new SimpleExecuteResult<T>(state, Message.of(code, msg, entity));
    }

    public static <T> ExecuteResult<T> of(Result.ResultState state, Message<T> msg) {
        return new SimpleExecuteResult<T>(state, msg);
    }
}

