/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.core;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cofcool.chaos.server.common.core.SimplePage;

public interface Page<T>
extends Serializable {
    public static final long MILLISECONDS_FLAG = Integer.MAX_VALUE;
    public static final long MILLISECONDS_RATIO = 1000L;
    public static final int PAGE_SIZE = 15;
    public static final int PAGE_MAX_SIZE = 200;
    public static final int PAGE_MIN_SIZE = 1;
    public static final int PAGE_NUMBER_FIRST_PAGE = 0;

    @Nullable
    public T getCondition();

    public void setCondition(T var1);

    public List<T> getContent();

    public String getWords();

    public int getPageNumber();

    public int getPageSize();

    public long getTotal();

    public int getPages();

    public boolean isFirstPage();

    public boolean isLastPage();

    public long getStartDate();

    public long getEndDate();

    public void checkPage();

    public static Date convertToDate(long date) {
        if (date > Integer.MAX_VALUE) {
            return new Date(date);
        }
        return new Date(date * 1000L);
    }

    public static <T> Page<T> empty() {
        return SimplePage.empty();
    }

    public static <T> Page<T> emptyPageForRequest() {
        return new SimplePage(0, 15);
    }

    @Nonnull
    public static <T> Page<T> checkPage(@Nullable Page<T> pageCondition) {
        if (pageCondition == null) {
            pageCondition = Page.emptyPageForRequest();
        }
        pageCondition.checkPage();
        return pageCondition;
    }
}

