/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.core;

import java.util.NoSuchElementException;
import java.util.Objects;
import net.cofcool.chaos.server.common.core.ExecuteResult;
import net.cofcool.chaos.server.common.core.Message;
import net.cofcool.chaos.server.common.core.Result;

public class SimpleExecuteResult<T>
implements ExecuteResult<T> {
    private static final long serialVersionUID = 345300521174121626L;
    private T entity;
    private Result.ResultState state;
    private Message<T> message;

    public SimpleExecuteResult(Result.ResultState state, Message<T> message) {
        this.entity = message.data();
        this.state = state;
        this.message = message;
    }

    @Override
    public T entity() {
        if (!this.successful() || this.entity == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.entity;
    }

    @Override
    public Result.ResultState state() {
        return this.state;
    }

    @Override
    public T orElse(T newVal) {
        return this.entity == null ? newVal : this.entity;
    }

    public void setMessage(Message<T> message) {
        Objects.requireNonNull(message);
        this.message = message;
        this.entity = message.data();
    }

    @Override
    public Message<T> result() {
        return this.message;
    }
}

