/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.core;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.cofcool.chaos.server.common.core.Page;

public class SimplePage<T>
implements Page<T> {
    private static final long serialVersionUID = -76703640096908564L;
    private static final Page<?> EMPTY_PAGE = new SimplePage(Collections.emptyList());
    private long startDate;
    private long endDate;
    private int pageNumber;
    private int pageSize;
    private long total;
    private int pages;
    private boolean isFirstPage;
    private boolean isLastPage;
    private List<T> content;
    private String words;
    private T condition;

    @Override
    @Nullable
    public T getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(T condition) {
        this.condition = condition;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public List<T> getContent() {
        return this.content;
    }

    protected void setContent(List<T> content) {
        this.content = content;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public int getPages() {
        return this.pages;
    }

    @Override
    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    @Override
    public boolean isLastPage() {
        return this.isLastPage;
    }

    @Override
    public long getStartDate() {
        return this.startDate;
    }

    @Override
    public long getEndDate() {
        return this.endDate;
    }

    @Override
    public String getWords() {
        return this.words;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setFirstPage(boolean firstPage) {
        this.isFirstPage = firstPage;
    }

    public void setLastPage(boolean lastPage) {
        this.isLastPage = lastPage;
    }

    public void setWords(String words) {
        this.words = words;
    }

    @Override
    public void checkPage() {
        if (this.pageSize < 1 || this.pageSize > 200) {
            this.pageSize = 15;
        }
        if (this.pageNumber < 0) {
            this.pageNumber = 0;
        }
    }

    public static <T> Page<T> empty() {
        return EMPTY_PAGE;
    }

    public SimplePage() {
    }

    protected SimplePage(List<T> content) {
        this.content = content;
    }

    public SimplePage(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, 0L, 0L);
    }

    public SimplePage(int pageNumber, int pageSize, long startDate, long endDate) {
        this(pageNumber, pageSize, startDate, endDate, null);
    }

    public SimplePage(int pageNumber, int pageSize, long startDate, long endDate, String words) {
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
        this.startDate = startDate;
        this.endDate = endDate;
        this.words = words;
    }

    public String toString() {
        return "SimplePage(startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", pages=" + this.getPages() + ", isFirstPage=" + this.isFirstPage() + ", isLastPage=" + this.isLastPage() + ", content=" + this.getContent() + ", words=" + this.getWords() + ", condition=" + this.getCondition() + ")";
    }
}

