/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.cofcool.chaos.server.common.core.Message;
import net.cofcool.chaos.server.common.core.Page;
import net.cofcool.chaos.server.common.core.QueryResult;

public class SimpleQueryResult<T>
implements QueryResult<T, Map<String, Object>> {
    private static final long serialVersionUID = 3886864123428767070L;
    private Page<T> page;
    private Object ext;
    private Message<Map<String, Object>> message;

    public SimpleQueryResult(@Nonnull Page<T> page, String code, String msg) {
        this(page, null, code, msg);
    }

    public SimpleQueryResult(Page<T> page, Object ext, String code, String msg) {
        Objects.requireNonNull(page);
        Objects.requireNonNull(page.getContent());
        this.page = page;
        this.ext = ext;
        this.message = Message.of(code, msg, this.createResultMap(page));
    }

    @Override
    public Page<T> page() {
        return this.page;
    }

    @Override
    public Object ext() {
        return this.ext;
    }

    public void setExt(Object ext) {
        this.ext = ext;
    }

    private Map<String, Object> createResultMap(Page<T> page) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("totalRow", page.getTotal());
        result.put("list", page.getContent());
        result.put("firstPage", page.isFirstPage());
        result.put("lastPage", page.isLastPage());
        result.put("pageNumber", page.getPageNumber());
        result.put("pageSize", page.getPageSize());
        result.put("totalPage", page.getPages());
        result.put("ext", this.ext);
        return result;
    }

    @Override
    public Message<Map<String, Object>> result() {
        return this.message;
    }
}

