/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.core;

import java.util.Objects;
import net.cofcool.chaos.server.common.core.DataAccess;
import net.cofcool.chaos.server.common.core.ExceptionCodeManager;
import net.cofcool.chaos.server.common.core.Page;
import net.cofcool.chaos.server.common.core.PageProcessor;
import net.cofcool.chaos.server.common.core.QueryResult;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SimpleService<T>
implements DataAccess<T> {
    private PageProcessor<T> pageProcessor;
    private ExceptionCodeManager exceptionCodeManager;

    public PageProcessor<T> getPageProcessor() {
        return this.pageProcessor;
    }

    public void setPageProcessor(PageProcessor<T> pageProcessor) {
        this.pageProcessor = pageProcessor;
    }

    public ExceptionCodeManager getExceptionCodeManager() {
        return this.exceptionCodeManager;
    }

    @Autowired
    public void setExceptionCodeManager(ExceptionCodeManager exceptionCodeManager) {
        this.exceptionCodeManager = exceptionCodeManager;
    }

    @Override
    public QueryResult<T, ?> query(Page<T> condition, T entity) {
        Page<T> page = Page.checkPage(condition);
        Objects.requireNonNull(this.getPageProcessor());
        return QueryResult.of(this.getPageProcessor().process(page, this.queryWithPage(page, entity)), this.exceptionCodeManager.getCode("SERVER_OK"), this.exceptionCodeManager.getDescription("SERVER_OK_DESC"));
    }

    protected abstract Object queryWithPage(Page<T> var1, T var2);
}

